(function ($) {
    "use strict";
    $(document).ready(function () {
        /*
        * Enable pro settings
        */
        var pro_feature_arr = ['#reservation_form_display_page', '#wpc_user_notification_for_confirm_req',
            '#wpc_admin_notification_for_confirm_req', '#wpc_admin_cancel_notification', '#wpc_admin_booking_confirm_subject', '#wpc_admin_booking_cancel_subject', '#wpc_confirm_email_subject', '#wpc_rejected_email_subject', '#wpc_user_notification_for_cancel_req'
        ];

        $.map(pro_feature_arr, function (value, index) {
            $(value).attr('disabled', false);
        });

        // hide text
        $(".wpc-pro-text").css('display', 'none');

        //remove class
        var pro_feature_editor_arr = [
            '#wp-wpc_admin_booking_confirm_email-wrap', '#wp-wpc_admin_booking_cancel_email-wrap', '#wp-wpc_rejected_email-wrap', '#wp-wpc_confirm_email-wrap'
        ];
        $.map(pro_feature_editor_arr, function (value, index) {
            $(value).css({
                'opacity': 'unset',
                'background': 'transparent',
                'pointer-events': 'unset'
            });
        });
        
        // select2
        $(".wpc_pro_multi_product").select2();
        $(".wpc_pro_multi_cat").select2();

        /*
        * Discount
        */

        //standarad
        function check_percentage_discount(data) {
            if (data == 'standard') {
                var wpc_pro_discount_percentage = $(".wpc_pro_discount_percentage").val();
                if (wpc_pro_discount_percentage !== '' && wpc_pro_discount_percentage !== '0') {
                    $(".wpc_pro_order_standarad_off_amount").val("");
                    $(".wpc_pro_discount_standarad_off").val("");
                    alert("You have already select percentage discount");
                }
            } else if (data == 'percentage') {
                var wpc_pro_discount_standarad_off = $(".wpc_pro_discount_standarad_off").val();
                var wpc_pro_order_standarad_off_amount = $(".wpc_pro_order_standarad_off_amount").val();
                if (
                    (wpc_pro_discount_standarad_off !== '' && wpc_pro_discount_standarad_off !== '0') ||
                    (wpc_pro_order_standarad_off_amount !== '' && wpc_pro_order_standarad_off_amount !== '0')
                ) {
                    $(".wpc_pro_discount_percentage").val("");
                    alert("You have already select standard discount");
                }
            }

        }

        $('input[name="wpc_pro_order_standarad_off_amount"]').on('keyup', function () {
            check_percentage_discount("standard");
        });

        $('input[name="wpc_pro_discount_standarad_off"]').on('keyup', function () {
            var wpc_pro_order_standarad_off_amount = $(".wpc_pro_order_standarad_off_amount").val();
            if (wpc_pro_order_standarad_off_amount == '' || wpc_pro_order_standarad_off_amount == '0') {
                alert("Please fill standard order amount");
            }
        });

        //percentage
        $('.wpc_pro_discount_main_block').on('keyup', 'input[name="wpc_pro_discount_percentage"]', function () {
            check_percentage_discount("percentage");
        });

        /*
        * Metabox time picker
        */
        $('#wpc_pro_preparing_time,#wpc_pro_delivery_time').timepicker({
            timeFormat: "H:i",
            step      : 15  //time gaph in minutes
        });

        // Weekly pickup schedule dynamically increase decrease
        add_week_block('pickup_schedule_block', 'wpc-weekly-schedule-list', 'pickup_weekly_block', '.pickup_schedule_main_block' , '.wpc-weekly-schedule-btn' , '.add_pickup_weekly_block' , 'wpc_pickup_weekly_schedule' , 'wpc_pickup_weekly_schedule_start_time' , 'wpc_pickup_weekly_schedule_end_time' , 'remove_pickup_block','wpc_pickup_weekly_clear'); 

        // remove pickeup exception block
        var remove_pickup_blcok = { parent_block:'.pickup_schedule_main_block', remove_button:'.remove_pickup_block'
        , removing_block:'.pickup_schedule_block' };

        remove_block( remove_pickup_blcok );

        // Weekly delivery schedule dynamically increase decrease
        add_week_block('delivery_schedule_block', 'wpc-weekly-schedule-list', 'delivery_weekly_block', '.delivery_schedule_main_block' , '.wpc-weekly-schedule-btn' , '.add_delivery_weekly_block' , 'wpc_delivery_schedule' , 'wpc_delivery_weekly_schedule_start_time' , 'wpc_delivery_weekly_schedule_end_time' , 'remove_delivery_block','wpc_delivery_weekly_clear'); 

        var remove_delivery_blcok = { parent_block:'.delivery_schedule_main_block', remove_button:'.remove_delivery_block'
        , removing_block:'.delivery_schedule_block' };

        remove_block( remove_delivery_blcok );

        // Check overlapping single and multi slot schedule
        var multi_time = []; 
        // time flatpicker
        $('.wpc-meta').on('focus', ".wpc_pro_time_picker", function () {
            $(this).timepicker({
                timeFormat    : "h:i A",
            });
        });
        
        $('.wpc-meta').on('focus', ".multi_start_time,.multi_end_time", function () {
            $(this).timepicker({
                timeFormat    : "h:i A",
                listWidth     : 1  //full width
            });
            $(this).on('changeTime',function(){
                var element = $(this).attr('name');
                var value   = $(this).val();
                var id      = $(this).attr('id'); var obj = {};
                if ( element == 'multi_start_time[]' || element == 'multi_end_time[]' ) {
                    // find index of same id and name  
                    let index = multi_time.findIndex( (ele)=> ele.id === id && ele.name === element )
                    // remove same index object
                    if (index !== -1) multi_time.splice(index, 1);
                    if (multi_time.some(ele=> ele.value === value) ) {
                        alert("Time already exist. Please select another day.")
                        $(this).val(" ")
                    }else{
                        obj.id      = id;
                        obj.name    = element;
                        obj.value   = value;
                        multi_time.push( obj )
                    }
                }
                $(this).timepicker('hide');
            })
        });
        
        var time_class = ['.wpc_pickup_weekly_schedule_start_time','.wpc_pickup_weekly_schedule_end_time','.wpc_delivery_weekly_schedule_start_time',,'.wpc_delivery_weekly_schedule_end_time',
        '.wpc_exception_end_time'];
         // date timepicker  
         $.map(time_class,function(value,index){
            $('.pickup_schedule_main_block,.delivery_schedule_main_block').on('focus', value , function(){
                $(this).timepicker({
                    timeFormat: 'h:i A',
                    interval: 30,
                    dynamic: true,
                    dropdown: true,
                    scrollbar: true
                });
            }); 
        });

        //clear action
        var clear_class = ['.wpc_pickup_weekly_clear','.wpc_delivery_weekly_clear','.wpc_multi_clear'];

        $.each(clear_class,function(ind,val){
            $('.pickup_schedule_main_block,.delivery_schedule_main_block,.multi_schedule').on('click', val ,function(){
                var id = $(this).attr('id');
                switch ( ind ) {
                    case 0:
                        // pickup
                        $('.wpc_pickup_weekly_schedule_start_time_'+id).val('');
                        $('.wpc_pickup_weekly_schedule_end_time_'+id).val('');
                    case 1:
                        // delivery
                        $('.wpc_delivery_weekly_schedule_start_time_'+id).val('');
                        $('.wpc_delivery_weekly_schedule_end_time_'+id).val('');
                    case 2:
                        // multi schedule
                        $('.multi_start_time_'+id).val('');
                        $('.multi_end_time_'+id).val('');
                        $('.schedule_name_'+id).val('');
                        $('.seat_capacity_'+id).val('');
                    default:
                        break;
                }
            })
        })
       
        // pickup weekly schedule select
        var pickup_selected_values = new Array();
        $('.pickup_weekly_block :checkbox').each(function () {
            if ($(this).is(":checked")) {
                pickup_selected_values.push($(this).attr('class'))
            }
        });

        $('.pickup_schedule_main_block').on('change', '.pickup_weekly_block :checkbox', function () {
            var value = $(this).attr('class');
            if ($(this).is(":checked")) {
                var check = $.inArray(value, pickup_selected_values);
                // if not exist , push in array
                if (check == -1) {
                    pickup_selected_values.push(value);
                } else {
                    $(this).prop("checked", false);
                    alert(value.toUpperCase() + " " + "day exist. Please check another day");
                }
            } else {
                pickup_selected_values.splice(pickup_selected_values.indexOf(value), 1);
            }
        });

        // delivery weekly schedule select
        var delivery_selected_values = new Array();
        $('.delivery_weekly_block :checkbox').each(function () {
            if ($(this).is(":checked")) {
                delivery_selected_values.push($(this).attr('class'))
            }
        });

        $('.delivery_schedule_main_block').on('change', '.delivery_weekly_block :checkbox', function () {
            var value = $(this).attr('class');
            if ($(this).is(":checked")) {
                var check = $.inArray(value, delivery_selected_values);
                // if not exist , push in array
                if (check == -1) {
                    delivery_selected_values.push(value);
                } else {
                    $(this).prop("checked", false);
                    alert(value.toUpperCase() + " " + "day exist. Please check another day");
                }
            } else {
                delivery_selected_values.splice(delivery_selected_values.indexOf(value), 1);
            }
        });

        // pickup exception shcedule dynamically increase decrease

        var pickup_exception_obj = {wrapper_block: '.pickup_exception_block' , parent_block:'.pick_add_section',second_wrapper:'exception_block',
        append_wrapper:'.pickup_exception_main_block',button_wrapper:'.add_pickup_exception_block',date_name:'wpc_pickup_exception_date',
        remove_button:'remove_pickup_exception_block'};

        add_repeating_block( pickup_exception_obj , 'order_time_exception' );

        // remove pickeup exception block
        var remove_weekly_blcok = { parent_block:'.pickup_exception_main_block', remove_button:'.remove_pickup_exception_block'
        , removing_block:'.exception_block' };

        remove_block( remove_weekly_blcok );

        // delivery exception shcedule dynamically increase decrease

        var delivery_exception_obj = {wrapper_block: '.delivery_exception_block' , parent_block:'.delivery_add_section',second_wrapper:'exception_block',
        append_wrapper:'.delivery_exception_main_block',button_wrapper:'.add_delivery_exception_block',date_name:'wpc_delivery_exception_date',
        remove_button:'remove_delivery_exception_block'};
     
        add_repeating_block( delivery_exception_obj , 'order_time_exception' );

        // remove pickeup exception block
        var remove_weekly_blcok = { parent_block:'.delivery_exception_main_block', remove_button:'.remove_delivery_exception_block'
        , removing_block:'.exception_block' };

        remove_block( remove_weekly_blcok );

        // reservation extra field dynamically increase decrease
        var reserve_extra_field_obj = {wrapper_block: '.extra_field_block' , parent_block:'.reserv_extra_section',second_wrapper:'schedule_block',
        append_wrapper:'.reserv_extra_main_block',button_wrapper:'.add_reserve_extra_block',label_name:'reserv_extra_label', place_ho_name:'reserv_extra_place_ho',
        remove_button:'remove_reserve_extra_field'};

        add_repeating_block( reserve_extra_field_obj , 'reservation_extra_field' );

        // remove reservation extra field block
        var remove_reserv_extra_blcok = { parent_block:'.reserv_extra_main_block', remove_button:'.remove_reserve_extra_field'
        , removing_block:'.schedule_block' };

        remove_block( remove_reserv_extra_blcok );

        // reservation multislot dynamically increase decrease
        var reserve_multi_slot_obj = {wrapper_block: '.multi_schedule_block' , parent_block:'.multi_block_add_section',second_wrapper:'multi_schedule_wrap',
        append_wrapper:'.multi_schedule',button_wrapper:'.add_multi_schedule', multi_start_time:'multi_start_time', multi_end_time:'multi_end_time',
        schedule_name:'schedule_name',seat_capacity:'seat_capacity',remove_button:'remove_reserve_multi_field',clear_button:'wpc_multi_clear'};

        add_repeating_block( reserve_multi_slot_obj , 'multi_slot_scheudle' );

        // remove reservation multislot block
        var remove_reserv_multi_slot = { parent_block:'.multi_schedule', remove_button:'.remove_reserve_multi_field'
        , removing_block:'.multi_schedule_wrap' };

        remove_block( remove_reserv_multi_slot );

        // add repeating block 
        function add_repeating_block( obj , block_name='') {
            var increase = $(obj.wrapper_block).length;
            $( obj.parent_block ).on( 'click' , obj.button_wrapper , function(e) {
                increase++;
                switch ( block_name ) {
                    case "order_time_exception":
                        var dateText = $(this).data("date_text");
                        $( obj.append_wrapper ).append(
                            '<div class="'+obj.second_wrapper+' d-flex mb-2">'+
                                '<input type="text" name="'+obj.date_name+'[]" class="'+ obj.date_name +' wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="'+dateText+'" id="'+obj.date_name+'_'+increase+'" />'+
                                '<span class="wpc-btn dashicons dashicons-no-alt '+ obj.remove_button +' wpc_icon_middle_position"></span>'+
                            '</div>');
                        break;
                    case "reservation_extra_field":
                        var label_text = $(this).data("label_text");
                        var placeholder_text = $(this).data("placeholder_text");
                        $( obj.append_wrapper ).append(
                            '<div class="wpc-schedule-field '+obj.second_wrapper+' d-flex mb-2">'+
                                '<input type="text" name="'+obj.label_name+'[]" class="'+ obj.label_name +' wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="'+label_text+'" id="'+obj.label_name+'_'+increase+'" />'+
                                '<input type="text" name="'+obj.place_ho_name+'[]" class="'+ obj.place_ho_name +' wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="'+placeholder_text+'" id="'+obj.place_ho_name+'_'+increase+'" />'+
                                '<span class="wpc-btn dashicons dashicons-no-alt '+ obj.remove_button +' wpc_icon_middle_position"></span>'+
                            '</div>'); 
                        break;
                    case "multi_slot_scheudle":
                        var start_time      = $(this).data("start_time");
                        var end_time        = $(this).data("end_time");
                        var schedule_name   = $(this).data("schedule_name");
                        var seat_capactiy   = $(this).data("seat_capactiy");
                        $( obj.append_wrapper ).append(
                            '<div class="wpc-schedule-field '+obj.second_wrapper+' d-flex mb-2">'+
                                '<input type="text" name="'+obj.multi_start_time+'[]" id='+ increase +' class="'+ obj.multi_start_time+'_'+increase +' multi_start_time  wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="'+start_time+'" id="'+obj.multi_start_time+'_'+increase+'" />'+
                                '<input type="text" name="'+obj.multi_end_time+'[]"   id='+ increase +' class="'+ obj.multi_end_time+'_'+increase +' multi_end_time wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="'+end_time+'" id="'+obj.multi_end_time+'_'+increase+'" />'+
                                '<input type="text" name="'+obj.schedule_name+'[]" class="'+ obj.schedule_name+'_'+increase +' wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="'+schedule_name+'" id="'+obj.schedule_name+'_'+increase+'" />'+
                                '<input type="text" name="'+obj.seat_capacity+'[]" class="'+ obj.seat_capacity+'_'+increase +' wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="'+seat_capactiy+'" id="'+obj.seat_capacity+'_'+increase+'" />'+
                                '<span class="'+obj.clear_button+'" id='+ increase +'> clear </span>'+
                                '<span class="wpc-btn dashicons dashicons-no-alt '+ obj.remove_button +' wpc_icon_middle_position"></span>'+
                            '</div>'); 
                        break;
                    default:
                        break;
                }       
            });
        }
        // load date flatpickr
        var date_class = ['wpc_pickup_exception_date', 'wpc_delivery_exception_date'];
        
        $.map(date_class, function (value, index) {
            $('.pickup_exception_main_block,.delivery_exception_main_block').on('focus', "." + value, function () {
                $(this).flatpickr({
                    dateFormat: 'yy-m-d',
                });
            });
        });

        // single / multi slot show hide
        var multi_schedule          = $(".multi_schedule_block");
        var single_schedule         = $(".single_schedule");
        var reser_multi_schedule    = $("#reser_multi_schedule");
        if ( reser_multi_schedule.is(':checked') ) {
            single_schedule.addClass("hide_field");
        }

        reser_multi_schedule.on('change',function(){
            if ($(this).is(':checked')) {
                multi_schedule.fadeIn();
                single_schedule.fadeOut();
                multi_schedule.removeClass("hide_field");

            }else{
                multi_schedule.addClass("hide_field");
                multi_schedule.fadeOut();
                single_schedule.fadeIn();
                single_schedule.removeClass("hide_field");
            }
        });

    });
  
})(jQuery);


// print reservation details
function wpc_pro_pirnt_content_area(divContents) {
    "use strict";
    var mywindow = window.open('', 'PRINT', 'height=400,width=600');
    if (divContents == "print_reservation_details") {
        mywindow.document.write('<style type="text/css">' +
            'table{' +
            'width:100%;' +
            '}' +
            'table th, table td {' +
            'border:1px solid #000;' +
            'padding:0.5em;' +
            '}' +
            '</style>');
    } else {
        mywindow.document.write('<style type="text/css">' +
            'table{' +
            'width:100%;' +
            '}' +
            'table th, table td {' +
            'border:1px solid #000;' +
            'padding:0.5em;' +
            '}' +
            '</style>');
    }
    mywindow.document.write('</head><body >');
    mywindow.document.write(document.getElementById(divContents).innerHTML);
    mywindow.document.write('</body></html>');
    mywindow.document.close(); // necessary for IE >= 10
    mywindow.focus(); // necessary for IE >= 10*/
    mywindow.print();
    return true;
}

