<?php

namespace WpCafe\Widgets\Wpc_Food_Menu_Tab;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \WpCafe\Utils\Wpc_Utilities as Wpc_Utilities;

defined( "ABSPATH" ) || exit;

class Wpc_Food_Menu_Tab extends Widget_Base {

    /**
     * Retrieve the widget name.
     * @return string Widget name.
     */
    public function get_name() {
        return 'wpc-menu-tab';
    }

    /**
     * Retrieve the widget title.
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'WPC Food Menu Tab', 'wpcafe' );
    }

    /**
     * Retrieve the widget icon.
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-menu-card';
    }

    /**
     * Retrieve the widget category.
     * @return string Widget category.
     */
    public function get_categories() {
        return ['wpcafe-menu'];
    }

    protected function _register_controls() {
        $get_data = apply_filters( 'elementor/control/search_control' , false);

        // Start of event section
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__( 'WPC Food Menu Tab', 'wpcafe' ),
            ]
        );

        $this->add_control(
            'food_tab_menu_style',
            [
                'label'   => esc_html__( 'Menu tab Style', 'wpcafe' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1' => esc_html__( 'Menu Style 1', 'wpcafe' ),
                ],
            ]
        );

        $this->add_control(
            'food_menu_tabs',
            [
                'label'   => esc_html__( 'Tabs', 'wpcafe' ),
                'type'    => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'tab_title' => esc_html__( 'Add Label', 'wpcafe' ),
                        'post_cats' => 1,
                    ],
                ],
                'fields'  => [
                    [
                        'name'        => 'post_cats',
                        'label'       => esc_html__( 'Select Categories', 'wpcafe' ),
                        'type'        => Controls_Manager::SELECT2,
                        'options'     => $this->get_menu_category(),
                        'label_block' => true,
                        'multiple'    => true,
                    ],

                    [
                        'name'    => 'tab_title',
                        'label'   => esc_html__( 'Tab title', 'wpcafe' ),
                        'type'    => Controls_Manager::TEXT,
                        'default' => 'Add Label',
                    ],

                ],
            ]
        );

        $this->add_control(
            'wpc_menu_count',
            [
                'label'   => esc_html__( 'Menu count', 'wpcafe' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '6',
            ]
        );
        $this->add_control(
            'wpc_menu_order',
            [
                'label'   => __( 'Menu Order', 'wpcafe' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC'  => __( 'ASC', 'wpcafe' ),
                    'DESC' => __( 'DESC', 'wpcafe' ),
                ],
            ]
        );
        $this->add_control(
            'show_thumbnail',
            [
                'label'        => esc_html__( 'Show Thumbnail', 'wpcafe' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'wpcafe' ),
                'label_off'    => esc_html__( 'Hide', 'wpcafe' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'show_item_status',
            [
                'label'        => esc_html__( 'Show Item Status', 'wpcafe' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'wpcafe' ),
                'label_off'    => esc_html__( 'Hide', 'wpcafe' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'wpc_show_desc',
            [
                'label'        => esc_html__( 'Show Description', 'wpcafe' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'wpcafe' ),
                'label_off'    => esc_html__( 'Hide', 'wpcafe' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $this->add_control(
            'wpc_desc_limit',
            [
                'label'     => esc_html__( 'Description Limit', 'wpcafe' ),
                'type'      => Controls_Manager::NUMBER,
                'default'   => '15',
                'condition' => ['wpc_show_desc' => 'yes'],
            ]
        );

        $this->add_control(
            'addtocart_link_show',
            [
                'label'        => esc_html__( 'Use Title Link?', 'wpcafe' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'wpcafe' ),
                'label_off'    => esc_html__( 'Hide', 'wpcafe' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $this->add_control(
            'wpc_cart_button_show',
            [
                'label'        => esc_html__( 'Show add to cart button', 'wpcafe' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'wpcafe' ),
                'label_off'    => esc_html__( 'Hide', 'wpcafe' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        
        if( is_array( $get_data ) && count( $get_data )>0 && isset( $get_data['search_control'] ) ){
            $this->add_control( $get_data['search_control']['name'], $get_data['search_control']['parameter']);
        }

        $this->end_controls_section();
        // item status style section
        $this->start_controls_section(
            'item_status_style',
            [
                'label'     => __( 'Item Status Style', 'wpcafe' ),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_item_status' => 'yes'],
            ]
        );
        $this->add_control(
            'wpc_menu_item_status_color',
            [
                'label'     => esc_html__( 'Item Status Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-menu-tag li' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'wpc_menu_item_status_bg_color',
            [
                'label'     => esc_html__( 'Item Status BG Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-menu-tag li' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'wpc_menu_status_typo',
                'label'    => esc_html__( 'Typography', 'wpcafe' ),
                'selector' => '{{WRAPPER}} .wpc-menu-tag li',
            ]
        );
        $this->add_responsive_control(
            'wpc_menu_item_status_paddding',
            [
                'label'      => esc_html__( 'Padding', 'wpcafe' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .wpc-menu-tag li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // item cart button style section
        $this->start_controls_section(
            'item_cart_button_style',
            [
                'label'     => __( 'Cart Button Style', 'wpcafe' ),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['wpc_cart_button_show' => 'yes'],
            ]
        );
        $this->add_control(
            'wpc_cart_color',
            [
                'label'     => esc_html__( 'Cart Button Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-food-menu-item .wpc-add-to-cart a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'wpc_cart_button_bg_color',
            [
                'label'     => esc_html__( 'Cart Button BG Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-food-menu-item .wpc-add-to-cart a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'wpc_cart_button_typo',
                'label'    => esc_html__( 'Typography', 'wpcafe' ),
                'selector' => '{{WRAPPER}} .wpc-food-menu-item .wpc-add-to-cart a i',
            ]
        );
        $this->add_responsive_control(
            'cart_btn_width',
            [
                'label'      => __( 'Width', 'wpcafe' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 45,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .wpc-food-menu-item .wpc-add-to-cart a' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'cart_btn_height',
            [
                'label'      => __( 'Height', 'wpcafe' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 45,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .wpc-food-menu-item .wpc-add-to-cart a' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'wpc_cart_btn_paddding',
            [
                'label'      => esc_html__( 'Padding', 'wpcafe' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .wpc-food-menu-item .wpc-add-to-cart a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Start of nav section
        $this->start_controls_section(
            'nav_style',
            [
                'label' => __( 'Nav style', 'wpcafe' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'nav_align',
            [
                'label'     => esc_html__( 'Alignment', 'wpcafe' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [

                    'left'    => [
                        'title' => esc_html__( 'Left', 'wpcafe' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'wpcafe' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'   => [
                        'title' => esc_html__( 'Right', 'wpcafe' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'wpcafe' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}}  .wpc-nav' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		//Responsive control end

        //control for nav typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'wpc_nav_typography',
                'label'    => esc_html__( 'Nav Title Typography', 'wpcafe' ),
                'selector' => '{{WRAPPER}} .wpc-nav li a',
            ]
        );

        //start of nav color tabs (normal and hover)
        $this->start_controls_tabs(
            'wpc_nav_tabs'
        );

        //start of nav normal color tab
        $this->start_controls_tab(
            'wpc_nav_normal_tab',
            [
                'label' => __( 'Normal', 'wpcafe' ),
            ]
        );

        $this->add_control(
            'wpc_nav_color',
            [
                'label'     => esc_html__( 'Nav Title Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-nav li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'nav_border',
                'label'    => esc_html__( 'Border', 'wpcafe' ),
                'selector' => '{{WRAPPER}} .wpc-nav li a',
            ]
        );

        $this->end_controls_tab();

		//end of nav normal color tab

        //start of nav active color tab
        $this->start_controls_tab(
            'wpc_nav_active_tab',
            [
                'label' => __( 'Active', 'wpcafe' ),
            ]
        );
        $this->add_control(
            'wpc_nav_active_color',
            [
                'label'     => esc_html__( 'Nav active color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-nav li a.wpc-active' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .wpc-nav li a:after'      => 'border-color: {{VALUE}} transparent transparent transparent;',
                ],
            ]
        );

        $this->add_control(
            'wpc_nav_angle_active_color',
            [
                'label'     => esc_html__( 'Nav Angle Active color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-nav li a:after' => 'border-color: {{VALUE}}  transparent transparent transparent;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'nav_border_active',
                'label'    => esc_html__( 'Border active', 'wpcafe' ),
                'selector' => '{{WRAPPER}} .wpc-nav li a.wpc-active',
            ]
        );
        $this->end_controls_tab();
        //end of nav hover color tab

        $this->end_controls_tabs();
        //end of nav color tabs (normal and hover)

        $this->end_controls_section();
		// End of nav section

        // title style section
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title Style', 'wpcafe' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'wpc_menu_title_color',
            [
                'label'     => esc_html__( 'Title Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-post-title a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'wpc_menu_title_hover_color',
            [
                'label'     => esc_html__( 'Title Hover Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-post-title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'wpc_menu_title_bg_color',
            [
                'label'     => esc_html__( 'Title BG Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-post-title a' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'wpc_menu_price_bg_color',
            [
                'label'     => esc_html__( 'Price BG Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-food-menu-item .wpc-food-inner-content .wpc-menu-currency' => 'background: {{VALUE}};',
                ],
            ]
        );
        //control for title typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'wpc_menu_title',
                'label'    => esc_html__( 'Title Typography', 'wpcafe' ),
                'selector' => '{{WRAPPER}} .wpc-post-title',
            ]
        );
        $this->add_responsive_control(
            'wpc_title_margin',
            [
                'label'      => esc_html__( 'Title Margin', 'wpcafe' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .wpc-post-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // price style section
        $this->start_controls_section(
            'price_style',
            [
                'label' => __( 'Price Style', 'wpcafe' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'wpc_menu_price_color',
            [
                'label'     => esc_html__( 'Price Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-menu-currency' => 'color: {{VALUE}};',
                ],
            ]
        );

        //control for title typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'wpc_menu_price',
                'label'    => esc_html__( 'Price Typography', 'wpcafe' ),
                'selector' => '{{WRAPPER}} .wpc-menu-currency',
            ]
        );

        $this->end_controls_section();

        // description style section
        $this->start_controls_section(
            'wpc_desc_style',
            [
                'label' => __( 'Description Style', 'wpcafe' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'wpc_menu_desc_color',
            [
                'label'     => esc_html__( 'Description Color', 'wpcafe' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpc-food-inner-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        //control for title typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'wpc_menu_desc',
                'label'    => esc_html__( 'Description Typography', 'wpcafe' ),
                'selector' => '{{WRAPPER}} .wpc-food-inner-content p',
            ]
        );

        $this->add_responsive_control(
            'wpc_desc_margin',
            [
                'label'      => esc_html__( 'Description Margin', 'wpcafe' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .wpc-food-inner-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // advance style section
        $this->start_controls_section(
            'wpc_advance_style',
            [
                'label' => __( 'Advance Style', 'wpcafe' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'wpc_box_margin',
            [
                'label'      => esc_html__( 'Margin', 'wpcafe' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .wpc-food-menu-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'wpc_box_padding',
            [
                'label'      => esc_html__( 'Padding', 'wpcafe' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .wpc-food-menu-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings             = $this->get_settings();
        $style                = $settings["food_tab_menu_style"];
        //check if woocommerce exists
        if (!class_exists('Woocommerce')) { return; }

        $food_menu_tabs       = $settings["food_menu_tabs"];
        $show_item_status     = $settings["show_item_status"];
        $show_thumbnail       = $settings["show_thumbnail"];
        $wpc_menu_count       = $settings["wpc_menu_count"];
        $title_link_show      = $settings["addtocart_link_show"];
        $wpc_cart_button      = $settings["wpc_cart_button_show"];
        $wpc_show_desc        = $settings["wpc_show_desc"];
        $wpc_desc_limit       = $settings["wpc_desc_limit"];
        $wpc_menu_order       = $settings["wpc_menu_order"];
        $widget_id            = $this->get_id();

        $class = ($title_link_show=='yes')? '' : 'wpc-no-link';
        apply_filters( 'elementor/control/search_data' , $settings , $widget_id , 'wpc-food-menu-tab' );
        ?>
        <div class="wpc-food-tab-wrapper wpc-nav-shortcode main_wrapper_<?php echo esc_html($widget_id)?>">
            <ul class="wpc-nav">
                <?php
                if( is_array( $food_menu_tabs ) ){
                    foreach ($food_menu_tabs as $tab_key => $value) {
                        $active_class = (($tab_key == array_keys($food_menu_tabs)[0]) ? 'wpc-active' : ' ');
                        ?>
                        <li>
                            <a href='#' class='wpc-tab-a <?php echo esc_attr($active_class); ?>' data-id='tab<?php echo esc_attr($this->get_id()) . "-" . $value['_id']; ?>'
                            data-cat_id='<?php echo isset($value['post_cats'][0] ) ? intval( $value['post_cats'][0] ) : 0 ; ?>'>
                                <span><?php echo esc_html($value['tab_title']); ?></span>
                            </a>
                        </li>
                        <?php
                    }
                }
                ?>
            </ul>
            <div class="wpc-tab-content wpc-widget-wrapper">
                <?php
                if( is_array( $food_menu_tabs ) ){
                    foreach ($food_menu_tabs as $content_key => $value) {
                        if(isset( $value['post_cats'][0] )){
                            $active_class = (($content_key == array_keys($food_menu_tabs)[0]) ? 'tab-active' : ' ');
                            ?>
                            <div class='wpc-tab <?php echo esc_attr($active_class); ?>' data-id='tab<?php echo esc_attr($this->get_id()) . "-" . $value['_id']; ?>'
                            data-cat_id='<?php echo isset($value['post_cats'][0] ) ? intval( $value['post_cats'][0] ) : 0 ; ?>'>
                            <div class="tab_template_<?php echo isset($value['post_cats'][0] ) ? intval( $value['post_cats'][0] ) : 0 ; ?>"></div>
                                <div class="template_data_<?php echo isset($value['post_cats'][0] ) ? intval( $value['post_cats'][0] ) : 0 ; ?>">
                                <?php
                                $products = Wpc_Utilities::product_query( "product", $wpc_menu_count , $value['post_cats'], $wpc_menu_order );
                                include WPC_DIR . "/widgets/wpc-food-menu-tab/style/{$style}.php";
                                ?>
                                </div>
                            </div><!-- Tab pane 1 end -->
                            <?php 
                        }
                    } 
                }
                ?>
            </div><!-- Tab content-->
        </div>
        <?php
    }

    protected function get_menu_category() {
        return Wpc_Utilities::get_menu_category();
    }

}
