<?php

namespace WpCafe\Core\Widgets;

defined("ABSPATH") || exit;

use WpCafe\Utils\Wpc_Utilities as Utils;
use WpCafe\Traits\Wpc_Singleton;
use WpCafe\Utils\Wpc_Utilities;

/**
 * create post type class
 */
class Hook
{

    use Wpc_Singleton;

    private $settings_obj = null;
    public $wpc_message   = '';
    public $wpc_cart_css  = '';
    /**
     * call hooks
     */
    public function init()
    {
        $settings = $this->settings_obj =  \WpCafe\Core\Base\Wpc_Settings_Field::instance()->get_settings_option();

        // add shortcode
        add_shortcode('wpc_food_menu_tab', [$this, 'wpc_food_menu_tab']);
        add_shortcode('wpc_food_menu_list', [$this, 'wpc_food_menu_list']);
        add_shortcode('wpc_reservation_form', [$this, 'wpc_booking_form_shortcode']);

        // add minicart to header
        add_action('wp_head', [$this, 'wpc_custom_inline_css']);
        add_action('wp_head', [$this, 'wpc_custom_mini_cart']);

        // add new field in checkout page
        if ( isset($settings['wpcafe_food_location']) && $settings['wpcafe_food_location'] == 'on' && class_exists('WooCommerce')) {
            add_action('woocommerce_checkout_before_customer_details', [$this, 'wpc_location_checkout_form']);
            add_action('woocommerce_checkout_process', [$this, 'wpc_validate_location']);
            add_action('woocommerce_checkout_create_order', [$this, 'wpc_location_update_meta'], 10, 2);
        }

        // menu order action
        add_action('product_cat_add_form_fields', [$this, 'wpc_product_cat_taxonomy_add_new_meta_field'], 10, 1);
        add_action('product_cat_edit_form_fields', [$this, 'wpc_product_cat_taxonomy_edit_meta_field'], 10, 1);
        add_action('edited_product_cat', [$this, 'wpc_product_cat_taxonomy_save_meta_field'], 10, 1);
        add_action('create_product_cat', [$this, 'wpc_product_cat_taxonomy_save_meta_field'], 10, 1);

        //Displaying Additional Columns
        add_filter('manage_edit-product_cat_columns', [$this, 'wpc_custom_fields_list_title']);
        add_action('manage_product_cat_custom_column', [$this, 'wpc_custom_fields_list_diplay'], 10, 3);

        if (class_exists('woocommerce')) {
            // update cart counter 
            add_filter('woocommerce_add_to_cart_fragments', [$this, 'wpc_add_to_cart_count_fragment_refresh'], 30, 1);
            add_filter('woocommerce_add_to_cart_fragments', [$this, 'wpc_add_to_cart_content_fragment_refresh']);
        }
    }

    /**
     * Create a shortcode to render the reservation form.
     * Print the reservation form's HTML code.
     */
    public function wpc_booking_form_shortcode($atts)
    {
        ob_start();
        $settings = $this->settings_obj;
        $result_data = apply_filters('wpcafe/action/reservation_template', $atts);

        $from_field_label = "From"; $to_field_label = "To"; $show_form_field = "on"; $show_to_field = "on";
        $from_to_column = "wpc-col-md-6"; $required_from_field = 'on'; $required_to_field = 'on';$view = 'yes'; 
        $column_lg = 'wpc-col-lg-6';$column_md = 'wpc-col-md-12'; $booking_button_text = "Book a table"; $cancell_button_text = "Request Cancellation";

        if ( is_array($result_data) ) {
            if ( isset( $result_data['calender_view']) ) {
                $view      = $result_data['calender_view'];
                $column_lg = isset($result_data['column_lg']) ? $result_data['column_lg'] : 'wpc-col-lg-6';
                $column_md = isset($result_data['column_md']) ? $result_data['column_md'] : 'wpc-col-md-12';
            }
            if(isset( $result_data['from_field_label'] ) && isset( $result_data['to_field_label'] )  ) {
                $from_field_label   =  $result_data['from_field_label'];
                $to_field_label     =  $result_data['to_field_label'];
                $show_form_field    =  $result_data['show_form_field'];
                $show_to_field      =  $result_data['show_to_field'];
                $required_from_field=  $result_data['required_from_field'];
                $required_to_field  =  $result_data['required_to_field'];

                if(!( $show_form_field =='on' && $show_to_field =='on' ) ){
                    $from_to_column = "wpc-col-md-12";
                }

                $booking_button_text = $result_data['form_booking_button'];
                $cancell_button_text = $result_data['form_cancell_button'];
            }
        }

        $seat_capacity = isset( $result_data['seat_capacity'] ) ? $result_data['seat_capacity'] : 20;

        $booking_status = isset( $result_data['booking_status'] ) ? $result_data['booking_status']: '';
        include_once 'reservation-form-template.php';

        if (! isset($settings['wpc_allow_cancellation']) || 
        (isset($settings['wpc_allow_cancellation']) && $settings['wpc_allow_cancellation'] == "on" ) ) {
            include_once 'cancellation-form-template.php';
        }

        $content = ob_get_clean();

        return $content;
    }

    /**
     * Food menu shortcode
     *
     * @param $atts
     * @param $content
     */
    public function wpc_food_menu_tab($atts)
    {
        if (!class_exists('Woocommerce')) {
            return;
        }

        ob_start();

        $atts = extract(shortcode_atts([
            'wpc_food_categories'   => '',
            'no_of_product'         => 5,
            'product_thumbnail'     => "on",
            'wpc_cart_button'       => "on"
        ], $atts));

        $unique_id = md5(md5(microtime()));
        $wpc_cat_arr      = explode(',', $wpc_food_categories);

        if (count($wpc_cat_arr) > 0) {
            $wpc_cat_sort_arr = [];
            $i                = 0;

            foreach ($wpc_cat_arr as $value) {
                $i++;
                if ($wpc_cat = get_term_by('id', $value, 'product_cat')) {
                    $wpc_get_menu_order = get_term_meta($wpc_cat->term_id, 'wpc_menu_order_priority', true);
                    if ($wpc_get_menu_order == '') {
                        $wpc_cat_sort_arr[$i] = $value;
                    } else {
                        $wpc_cat_sort_arr[$wpc_get_menu_order] = $value;
                    }
                }
            }
            ksort($wpc_cat_sort_arr);
?>
            <div class="wpc-food-tab-wrapper wpc-food-menu-wrapper wpc-nav-shortcode">
                <ul class="wpc-nav">
                    <?php
                    foreach ($wpc_cat_sort_arr as $key => $value) {
                        if ($wpc_cat = get_term_by('id', $value, 'product_cat')) {
                            $active_class = (($key == array_keys($wpc_cat_sort_arr)[0]) ? 'wpc-active' : ' ');
                    ?>
                            <li>
                                <a href="#" data-id="tab_<?php echo intval($key); ?>" class="wpc-tab-a <?php echo esc_attr($active_class); ?>" data-toggle="tab" aria-expanded="true">
                                    <span><?php echo esc_attr_e($wpc_cat->name, 'wpcafe'); ?></span>
                                </a>
                            </li>
                    <?php
                        }
                    }
                    ?>
                </ul>
                <div class='wpc-tab-content wpc-widget-wrapper'>
                    <?php
                    foreach ($wpc_cat_sort_arr as $current_key => $value) {
                        $products = Wpc_Utilities::product_query("product", $no_of_product, [$value], "DESC");
                        $active_class = (($current_key == array_keys($wpc_cat_sort_arr)[0]) ? 'tab-active' : ' ');
                    ?>
                        <div class='wpc-tab <?php echo esc_attr($active_class); ?>' data-id='tab_<?php echo intval($current_key); ?>'>
                            <div class='wpc-row'>
                                <?php if (is_array($products) && count($products) > 0) :
                                    foreach ($products as $product) { ?>
                                        <div class='wpc-col-lg-6'>
                                            <div class='wpc-food-menu-item wpc-row'>
                                                <?php
                                                // show tag
                                                if ($product_thumbnail == "on") {
                                                ?>
                                                    <div class="wpc-col-md-3">
                                                        <div class="wpc-food-menu-thumb">
                                                            <a href="<?php echo esc_url(get_permalink($product->get_id())); ?>">
                                                                <?php echo Wpc_Utilities::wpc_kses($product->get_image()) ?>
                                                            </a>
                                                        </div>
                                                    </div>
                                                <?php
                                                }
                                                ?>
                                                <div class="wpc-col-md-9">
                                                    <div class="wpc-food-inner-content">
                                                        <div class="wpc-menu-tag-wrap">
                                                            <?php
                                                            Utils::wpc_tag($product->get_id(), $product->is_in_stock());
                                                            $price = '';
                                                            if (wc_get_price_including_tax($product)) {
                                                                $price      = wc_get_price_including_tax($product);
                                                            } else {
                                                                $price = wc_get_price_excluding_tax($product);
                                                            }
                                                            if ($product->get_price_suffix() != '') { ?>
                                                                <ul class="wpc-menu-tag">
                                                                    <li>
                                                                        <?php if (wc_get_price_including_tax($product)) {
                                                                            // get percentage tax
                                                                            echo Wpc_Utilities::wpc_kses($product->get_price_suffix());
                                                                        } ?>
                                                                    </li>
                                                                </ul>
                                                            <?php
                                                            } ?>
                                                        </div>
                                                        <h3 class="wpc-post-title">
                                                            <a href="<?php echo esc_url(get_permalink($product->get_id())); ?>"><?php echo esc_html($product->get_name());  ?> </a>
                                                            <?php if ($product->get_type() !== 'variable') { ?>
                                                                <span class="wpc-menu-currency"><?php echo Wpc_Utilities::wpc_render(get_woocommerce_currency_symbol()); ?> <span class="wpc-menu-price"><?php echo esc_html($price); ?></span></span>
                                                            <?php } else {
                                                                    $var_price = Wpc_Utilities::get_variation_price($product)
                                                                ?>
                                                                <span class="wpc-menu-currency"><span class="wpc-menu-price"><?php echo esc_html($var_price); ?></span></span>
                                                            <?php
                                                            } ?>
                                                        </h3>
                                                        <?php
                                                        // show product details
                                                        echo  Wpc_Utilities::wpc_kses(get_the_excerpt($product->get_id()));
                                                        // cart button
                                                        echo  Wpc_Utilities::product_add_to_cart($product, $wpc_cart_button, "", "", $unique_id);
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                <?php }
                                endif; ?>
                            </div>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>
        <?php
        }

        return ob_get_clean();
    }

    /**
     * Food menu list block
     *
     * @param Type $var
     */
    public function wpc_food_menu_list($atts)
    {
        if (!class_exists('Woocommerce')) { return; }
        ob_start();

        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories' => '',
                'no_of_product' => 5,
                'wpc_cart_button' => 'on'
            ],
            $atts
        ));

        // category sorting from backend
        $wpc_cat_arr      = explode(',', $wpc_food_categories);

        if (is_array($wpc_cat_arr) && count($wpc_cat_arr) > 0) {
            $products = Wpc_Utilities::product_query("product", $no_of_product, $wpc_cat_arr, "DESC");
        ?>
            <div class='wpc-food-wrapper wpc-nav-shortcode'>
                <div class="wpc-widget-wrapper">
                    <?php if (is_array($products) && count($products) > 0) :
                        foreach ($products as $product) { ?>
                            <div class="wpc-food-menu-item wpc-row">
                                <!-- thumbnail -->
                                <?php if ($product->get_image()) { ?>
                                    <div class="wpc-col-md-3">
                                        <div class="wpc-food-menu-thumb">
                                            <a href="<?php echo esc_url(get_permalink($product->get_id())); ?>">
                                                <?php echo Wpc_Utilities::wpc_kses($product->get_image()) ?>
                                            </a>
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="wpc-col-md-9">
                                    <div class="wpc-food-inner-content">
                                        <!-- display tag -->
                                        <div class="wpc-menu-tag-wrap">
                                            <?php
                                            Utils::wpc_tag($product->get_id(), $product->is_in_stock());
                                            $price = '';
                                            if (wc_get_price_including_tax($product)) {
                                                $price      = wc_get_price_including_tax($product);
                                            } else {
                                                $price = wc_get_price_excluding_tax($product);
                                            }
                                            ?>
                                            <?php if ($product->get_price_suffix() != '') { ?>
                                                <ul class="wpc-menu-tag">
                                                    <li>
                                                        <?php if (wc_get_price_including_tax($product)) {
                                                            // get percentage tax
                                                            echo Wpc_Utilities::wpc_kses($product->get_price_suffix());
                                                        } ?>
                                                    </li>
                                                </ul>
                                            <?php } ?>
                                        </div>
                                        <h3 class="wpc-post-title">
                                            <a href="<?php echo esc_url(get_permalink($product->get_id())); ?>"><?php echo esc_html($product->get_name());  ?> </a>
                                            <?php if ($product->get_type() !== 'variable') { ?>
                                                <span class="wpc-menu-currency"><?php echo Wpc_Utilities::wpc_render(get_woocommerce_currency_symbol()); ?> <span class="wpc-menu-price"><?php echo esc_html($price); ?></span></span>
                                            <?php } else {
                                                    $var_price = Wpc_Utilities::get_variation_price($product)
                                                 ?>
                                                <span class="wpc-menu-currency"><span class="wpc-menu-price"><?php echo esc_html($var_price); ?></span></span>
                                            <?php
                                            } ?>
                                        </h3>
                                        <?php
                                        // show product details
                                        echo  Wpc_Utilities::wpc_kses(get_the_excerpt($product->get_id()));
                                        // cart button
                                        echo  Wpc_Utilities::product_add_to_cart($product, $wpc_cart_button);
                                        ?>
                                    </div>
                                </div>
                            </div>
                    <?php  }
                    endif;  ?>
                </div>
            </div>
        <?php
        }
        return ob_get_clean();
    }

    /**
     * Mini cart for frontend
     *
     */
    public function wpc_custom_mini_cart(){
        if (!class_exists('WooCommerce')) {  return; }
        // show location
        if (is_front_page()) {
            Utils::get_location_details();
        }
        $settings       = $this->settings_obj;
        if ( !isset($settings['wpcafe_allow_cart']) || ( isset($settings['wpcafe_allow_cart'])
            && $settings['wpcafe_allow_cart'] == 'on' ) ) {
            $wpc_cart_icon  = '';
            // icon
            if (isset($settings['wpc_mini_cart_icon'])) {
                $wpc_cart_icon = $settings['wpc_mini_cart_icon'] != '' ? $settings['wpc_mini_cart_icon'] : 'wpcafe-cart_icon';
            } else {
                $wpc_cart_icon = 'wpcafe-cart_icon';
            }

        ?>
            <ul class="wpc_cart_block"><a href="#" class="wpc_cart_icon">
                    <i class="<?php echo esc_attr($wpc_cart_icon); ?>"></i>
                    <sup class="basket-item-count" style="display: inline-block;">
                        <span class="cart-items-count count" id="wpc-mini-cart-count">
                        </span>
                    </sup>
                </a>
                <li class="wpc-menu-mini-cart wpc_background_color">
                    <div class="widget_shopping_cart_content">
                        <?php
                        is_object(WC()->cart) ? woocommerce_mini_cart() : '';
                        ?>
                    </div>
                </li>
            </ul>
        <?php
        }
    }

    /**
     * Cart count  function
     *
     * @param [type] $fragments
     */
    public function wpc_add_to_cart_count_fragment_refresh($fragments){
        ob_start();
        ?>
        <div id="wpc-mini-cart-count">
            <?php echo WC()->cart->get_cart_contents_count(); ?>
        </div>
        <?php
        $fragments['#wpc-mini-cart-count'] = ob_get_clean();
        return $fragments;
    }

    /**
     * Cart count  function
     *
     * @param [type] $fragments
     */
    public function wpc_add_to_cart_content_fragment_refresh($fragments){
        ob_start();
        ?>
        <div class="widget_shopping_cart_content">
            <?php
            is_object(WC()->cart) ? woocommerce_mini_cart() : '';
            ?>
        </div>
        <?php
        $fragments['div.widget_shopping_cart_content'] = ob_get_clean();
        return $fragments;
    }

    /**
     * Location field in checkout form
     *
     */
    public function wpc_location_checkout_form(){
        $domain   = 'woocommerce';
        $checkout = WC()->checkout;
        ?>
        <div id="wpc_location_field">
            <?php
            // get loctaion
            $wpc_loctaion     = get_terms('wpcafe_location', ['taxonomy' => 'wpcafe_location', 'hide_empty' => 0, 'orderby' => 'DESC', 'parent' => 0]);
            $wpc_loctaion_arr = ['' => esc_html__('Select a loctaion', 'wpcafe')];

            foreach ($wpc_loctaion as $value) {
                $wpc_loctaion_arr["$value->slug"] = $value->name;
            }
            woocommerce_form_field('wpc_location_name', [
                'type'        => 'select',
                'class'       => ['wpc-location form-row-wide'],
                'label'       => esc_html__('Order location', 'wpcafe'),
                'placeholder' => esc_html__('Enter location', 'wpcafe'),
                'required'    => true,
                'options'     => $wpc_loctaion_arr,
            ], $checkout->get_value('wpc_location_name'));
            ?>
        </div>
        <?php
    }

    /**
     * Valid location select option
     *
     */
    public function wpc_validate_location(){
        if (sanitize_text_field(isset($_POST['wpc_location_name'])) && empty(sanitize_text_field($_POST['wpc_location_name']))) {
            wc_add_notice(esc_html__('Please select a location', 'wpcafe'), 'error');
        }
    }

    /**
     * Update location select option
     *
     * @param [type] $order
     */
    public function wpc_location_update_meta($order){

        if (sanitize_text_field(isset($_POST['wpc_location_name'])) && !empty(sanitize_text_field($_POST['wpc_location_name']))) {
            $order->update_meta_data('wpc_location_name', sanitize_text_field($_POST['wpc_location_name']));
        }
    }

    /**
     * Category new field for set priority
     *
     */
    public function wpc_product_cat_taxonomy_add_new_meta_field(){
    ?>
        <div class="form-field">
            <label for="wpc_menu_order_priority"><?php esc_html_e('Order menu', 'wpcafe'); ?></label>
            <input type="text" name="wpc_menu_order_priority" id="wpc_menu_order_priority">
        </div>
    <?php
    }

    /**
     * Category edit field for set priority
     *
     * @param [type] $term
     */
    public function wpc_product_cat_taxonomy_edit_meta_field($term){
        //getting term ID
        $term_id                 = $term->term_id;
        $wpc_menu_order_priority = get_term_meta($term_id, 'wpc_menu_order_priority', true);
        ?>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="wpc_menu_order_priority"><?php esc_html_e('Order menu', 'wpcafe'); ?></label></th>
            <td>
                <input type="text" name="wpc_menu_order_priority" id="wpc_menu_order_priority" value="<?php echo esc_attr($wpc_menu_order_priority) ? esc_attr($wpc_menu_order_priority) : ''; ?>">
            </td>
        </tr>
        <?php
    }

    /**
     * Category save field for set priority
     *
     * @param [type] $term
     */
    public function wpc_product_cat_taxonomy_save_meta_field($term_id){
        $wpc_menu_order_priority = filter_input(INPUT_POST, 'wpc_menu_order_priority');
        update_term_meta($term_id, 'wpc_menu_order_priority', $wpc_menu_order_priority);
    }

    /**
     * Order menu column added to category admin screen.
     *
     * @param mixed $columns
     */
    public function wpc_custom_fields_list_title($columns){
        $columns['wpc_menu_order_priority'] = esc_html__('Order menu', 'wpcafe');
        $columns['cat_id']                  = esc_html__('ID', 'wpcafe');
        return $columns;
    }

    /**
     * Order menu column value added to product category admin screen.
     *
     * @param string $columns
     * @param string $column
     * @param int $id term ID
     */
    public function wpc_custom_fields_list_diplay($columns, $column, $id){
        if ('wpc_menu_order_priority' == $column) {
            $columns = esc_html(get_term_meta($id, 'wpc_menu_order_priority', true));
        } elseif ('cat_id' == $column) {
            $columns = esc_html($id);
        }

        return $columns;
    }

    /**
     * Custom inline css
     *
     */
    public function wpc_custom_inline_css(){
        if (!class_exists('WooCommerce')) {
            return;
        }
        $settings       = $this->settings_obj;

        $wpc_custom_css = '';

        // cart bg color
        if (isset($settings['wpc_primary_color'])) {
            $bg_color = $settings['wpc_primary_color'] ? $settings['wpc_primary_color'] : "#5D78FF ";
            $wpc_custom_css .= '.wpc_background_color { background-color : ' . esc_attr($bg_color) . '}';
            //button
            $wpc_custom_css .= '
                .wpc_cart_block .wpc_background_color a.button.wc-forward,
                .wpc-food-menu-item .wpc-food-inner-content .wpc-menu-tag li,
                .wpc_cart_block .wpc_cart_icon,
                .picker__holder .picker__box,
                .wpc-food-menu-item .wpc-add-to-cart a,
                .wpc-reservation-field.date .flatpickr-calendar,
                .wpc-category-list-style1 .wpc-category-title a, .wpc-category-list-style3 .wpc-category-title a,
                .wpc-reservation-form .wpc_reservation_user_info,
                body.woocomerce-layout-override-enable.woocommerce-cart .woocommerce .button,
                body.woocomerce-layout-override-enable .woocommerce button.button.alt,
                body.woocomerce-layout-override-enable.archive .products .product .button,
                body.woocomerce-layout-override-enable.archive .products .product .added_to_cart,
                body.woocomerce-layout-override-enable.single-product .products .product .button,
                body.woocomerce-layout-override-enable.single-product .products .product .added_to_cart,
                body.woocomerce-layout-override-enable.woocommerce #respond input#submit,
                .wpc-food-menu-item .wpc-menu-tag li,
                body.woocomerce-layout-override-enable.woocommerce button.button.alt,
                body.woocomerce-layout-override-enable.single-product div.product .woocommerce-tabs ul li.active,
                body.woocomerce-layout-override-enable.archive .woocommerce-pagination li span.current,
                 body.woocomerce-layout-override-enable.archive .woocommerce-pagination li a.current,
                body.woocomerce-layout-override-enable.woocommerce-cart .woocommerce .shop_table a.remove,
                .wpc-btn, .attr-btn-primary, .reservation_form_submit.wpc-btn, .cancell_form_submit.wpc-btn, .wpc-settings-dashboard .button-primary {
                     background-color : ' . esc_attr($bg_color) . '
                    }

                .wpc-food-menu-item .wpc-food-inner-content .wpc-menu-currency,
                .wpc-food-menu-item .wpc-food-inner-content .wpc-post-title a:hover,
                .wpc_cart_block .woocommerce-mini-cart li a,
              
                body.woocomerce-layout-override-enable.archive .products .product .price,
                body.woocomerce-layout-override-enable.single-product .products .product .price,
                body.woocomerce-layout-override-enable.single-product .products .product .woocommerce-loop-product__title:hover,
                body.woocomerce-layout-override-enable .products .product .woocommerce-loop-product__title:hover,
                body.woocomerce-layout-override-enable.woocommerce-cart .woocommerce .shop_table tbody td.product-name a:hover,
                .woocomerce-layout-override-enable.woocommerce-checkout .woocommerce table.shop_table.woocommerce-checkout-review-order-table tfoot tr.order-total th,
                 .woocomerce-layout-override-enable.woocommerce-checkout .woocommerce table.shop_table.woocommerce-checkout-review-order-table tfoot tr.order-total td,
                .wpc-food-tab-wrapper .wpc-nav li a.wpc-active{
                    color : ' . esc_attr($bg_color) . '
                }
                .wpc-food-tab-wrapper .wpc-nav li a.wpc-active{
                    border-bottom-color : ' . esc_attr($bg_color) . '
                }
                body.woocomerce-layout-override-enable.single-product div.product .woocommerce-tabs ul li.active{
                    border-right-color : ' . esc_attr($bg_color) . '
                }
                .wpc-food-tab-wrapper .wpc-nav li a:after{
                    border-color:' . esc_attr($bg_color) . ' transparent transparent transparent;
                }
                    
                ';
            // icon cross
            $wpc_custom_css .= '.wpc_cart_block .woocommerce-mini-cart li .remove.remove_from_cart_button { background-color : ' . esc_attr($bg_color) . '}';
        } else {
            $wpc_custom_css .= '.wpc_background_color { background-color : #d5d5d5 }';
            //button
            $wpc_custom_css .= '.wpc_cart_block .wpc_background_color a.button.wc-forward { background-color : ' . esc_attr('#5D78FF') . '}';
        }

        // cart icon color
        if (isset($settings['wpc_secondary_color'])) {
            $color = $settings['wpc_secondary_color'] ? $settings['wpc_secondary_color'] : "";

            //button hover
            $wpc_custom_css .= '
                .wpc_cart_block .wpc_background_color a.button.wc-forward:hover,
                .wpc-btn:hover, .wpc-btn:focus, .attr-btn-primary:hover, .attr-btn-primary:focus, 
                .reservation_form_submit.wpc-btn:hover, .reservation_form_submit.wpc-btn:focus, 
                .cancell_form_submit.wpc-btn:hover, .cancell_form_submit.wpc-btn:focus, 
                .wpc-settings-dashboard .button-primary:hover,
                 .wpc-settings-dashboard .button-primary:focus,
                 body.woocomerce-layout-override-enable.woocommerce button.button.alt:hover,
                 body.woocomerce-layout-override-enable.woocommerce-cart .woocommerce .shop_table a.remove:hover,
                 body.woocomerce-layout-override-enable.woocommerce-cart .woocommerce .button:hover,
                 .wpc-reservation-form .wpc_reservation_user_info .wpc_log_message,
                 body.woocomerce-layout-override-enable.woocommerce #respond input#submit:hover,
                 body.woocomerce-layout-override-enable .products .product span.onsale,
                 body.woocomerce-layout-override-enable.single-product .products .product span.onsale,
                 body.woocomerce-layout-override-enable .woocommerce button.button.alt:hover,
                #wpc_location_modal .wpc-close {
                     background-color : ' . esc_attr($color) . '
                    }
                ';
            // icon cross hover
            $wpc_custom_css .= '.wpc_cart_block .woocommerce-mini-cart li .remove.remove_from_cart_button { background-color : ' . esc_attr($color) . '}';
            // count
            $wpc_custom_css .= '
                .cart-items-count,
                .woocomerce-layout-override-enable.woocommerce div.product p.price,
                .woocomerce-layout-override-enable.woocommerce div.product span.price
                { 
                    color : ' . esc_attr($color) .
                '}';
        } else {
            $wpc_custom_css .= 'a.wpc_cart_icon i { color : #fff}';
            //button hover
            $wpc_custom_css .= '.wpc_cart_block .wpc_background_color a.button.wc-forward:hover { background-color : ' . esc_attr('#5D78FF') . '}';
            // icon cross hover
            $wpc_custom_css .= '.wpc_cart_block .woocommerce-mini-cart li .remove.remove_from_cart_button:hover { background-color : ' . esc_attr('#5D78FF') . '}';
            // count 
            $wpc_custom_css .= '.cart-items-count { color : ' . esc_attr('#fff') . '}';
        }

        // add inline css
        wp_register_style('wpc-cart-css', false);
        wp_enqueue_style('wpc-cart-css');
        wp_add_inline_style('wpc-cart-css', $wpc_custom_css);
    }

}
