<?php
namespace WpCafe\Core\Base;

defined( "ABSPATH" ) || exit;

use WpCafe\Traits\Wpc_Singleton;

class Wpc_Settings_Field {

    use Wpc_Singleton;

    private $key_settings_option;

    /**
     * set key option function
     */
    public function __construct() {
        $this->key_settings_option = 'wpcafe_reservation_settings_options';
    }
    /**
     * Get all settings
     */
    public function get_settings_option( $key = null, $default = null ) {
        if ( $key != null ) {
            $this->key_settings_option = $key;
        }
        
        return get_option( $this->key_settings_option );
    }

    public function set_option( $key, $default = null ) {
    }

    /**
     * Convert time in 24
     *
     */
    public function convert_time_24( $time ){
        $time_24 = date('H:i', strtotime($time)  );

        return $time_24;
    }

    /**
     * Compare start time and end time 
     *
     */
    public function compare_time( $start_arr , $end_arr ){
        $time_checking_error = false;
        if ( ( is_array( $start_arr ) && $start_arr[0] !== "" ) && ( is_array($end_arr) && $end_arr[0] !== ""  ) ) {
            for ($i=0; $i < count( $start_arr ); $i++) { 
                $start_time = $this->convert_time_24( $start_arr[$i] );
                $end_time   = $this->convert_time_24( $end_arr[$i] );
                if ( $start_time >= $end_time ) {
                    $time_checking_error = true;
                }
            }
        }

        return $time_checking_error;
    }
    /**
     * Check validation of settings
     *
     */
    public function check_validation( $request ){
        // weekly schedule time checking
        $weekly_time_error = $this->compare_time( $request['wpc_weekly_schedule_start_time'] ,$request['wpc_weekly_schedule_end_time'] );
        // exce schedule time checking
        $exception_time_error = $this->compare_time( $request['wpc_exception_start_time'] ,$request['wpc_exception_end_time'] );
        
        $data = apply_filters("wpcafe/settings/validation",$request);

        if ( $data == false ) {
            return;
        }
        
       switch ($request) {
           case $request['wpc_min_guest_no'] >= $request['wpc_max_guest_no']:
                add_settings_error( "validation_error", 701 , esc_html__( "Minimum guest no. can't be grater than or equal maximum guest no." , "wpcafe"), "error" );
                 return false;
            break;

            case ( ! ( $request['wpc_min_guest_no'] <= $request['wpc_default_gest_no'] ) || ! ( $request['wpc_default_gest_no'] <= $request['wpc_max_guest_no'] ) ) :
                add_settings_error( "validation_error", 701 , esc_html__( "Default guest no. must be in between minimum and  maximum guest no." , "wpcafe"), "error" );
                 return false;
            break;

            case  ( ( ( isset($request['wpc_all_day_start_time']) && isset($request['wpc_all_day_end_time']) && $request['wpc_all_day_start_time']!== "" && $request['wpc_all_day_end_time']!== "") && 
            $this->convert_time_24( $request['wpc_all_day_start_time'] ) >= $this->convert_time_24( $request['wpc_all_day_end_time']) ) || $exception_time_error == true || $weekly_time_error == true ) :
                add_settings_error( "validation_error", 701 , esc_html__( "Schedule start time can't be grater than or equal end time" , "wpcafe"), "error" );
                 return false;
            break;

           default:
                return true;
            break;
       }
    }
    /**
     * Submit action of settings
     */
    public function form_handler() {
        if ( isset( $_POST['wpcafe_settings_key_options_action'] ) ) {
            $request = filter_input_array( INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS );
            if ( !check_admin_referer( 'wpcafe-settings-page', 'wpcafe-settings-page' ) ) {
                return;
            }

            $data = $this->check_validation( $request );
            
            if ($data == false) {
                return false;
            }

            return \WpCafe\Core\Action\Wpc_Action::instance()->wpc_store( -1, $request );
        }
    }

}
