"use strict";

// get weekly schedule 
const wpc_weekly_schedule_time = (weekly_schedule_arr, selected_day, wpc_weekly_schedule_start_time, wpc_weekly_schedule_end_time) => {
    // default response
    var response = {
        success: false,
        wpc_start_time: '',
        wpc_end_time: ''
    };
    var day = jQuery.map(weekly_schedule_arr, function (value, index) {
        var key = objectKeyName(value);
        return key;
    });
    if (jQuery.inArray(selected_day, day) !== -1) {
        for (let index = 0; index < weekly_schedule_arr.length; index++) {
            const element = weekly_schedule_arr[index];
            var key = objectKeyName(element);
            for (let i = 0; i < key.length; i++) {
                const element = key[i];
                if (selected_day == element) {
                    response.success = true;
                    response.wpc_start_time = wpc_weekly_schedule_start_time[index];
                    response.wpc_end_time = wpc_weekly_schedule_end_time[index];
                }
            }
        }
    }
    return response;
}

(function ($) {

    // get location saved data 
    var local_storage_value = localStorage.getItem('wpc_location');
    $(document).ready(function () {

        var error_message       = $('.wpc_error_message');
        var cancell_log_message = $('.wpc_cancell_log_message');
        var log_message         = $('.wpc_log_message');

        // select location
        $("#wpc_location_name option[value='" + local_storage_value + "']").attr("selected", true);
        //   custom tabs
        $('.wpc-food-tab-wrapper').on('click', '.wpc-tab-a', function (event) {
            event.preventDefault();
            $(this).parents(".wpc-food-tab-wrapper").find(".wpc-tab").removeClass('tab-active');
            $(this).parents(".wpc-food-tab-wrapper").find(".wpc-tab[data-id='" + $(this).attr('data-id') + "']").addClass("tab-active");
            $(this).parents(".wpc-food-tab-wrapper").find(".wpc-tab-a").removeClass('wpc-active');
            $(this).parent().find(".wpc-tab-a").addClass('wpc-active');
        });

        // single page ajax
        if ( typeof wc_cart_fragments_params !== "undefined") {
            var $warp_fragment_refresh = {
                url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_refreshed_fragments'),
                type: 'POST',
                success: function(data) {
                    if (data && data.fragments) {
                        $.each(data.fragments, function(key, value) {
                            $(key).replaceWith(value);
                        });

                        $(document.body).trigger('wc_fragments_refreshed');
                    }
                }
            };
        }
        // add to cart . refresh cart

        $('body').on('submit', '.entry-summary form.cart', function (evt) {
            evt.preventDefault();
            var $this = $(this);
            $this.find('.button').removeClass('added').addClass('loading');
            var product_url = window.location,
                form = $(this); var form_data;
            var simple_pro_id = $('.single_add_to_cart_button').val();
            if ( typeof simple_pro_id !== 'undefined' && simple_pro_id !=='') {
                form_data =   form.serialize()  + '&'
                    + encodeURI('add-to-cart')
                    + '='
                    + encodeURI(simple_pro_id)
            }
            else{
                form_data =   form.serialize();
            }
            $.post(product_url, form_data + '&_wp_http_referer=' + product_url, function(result) {
                $(document.body).trigger('wc_fragment_refresh');

                var cart_dropdown = $('.widget_shopping_cart', result)

                // update dropdown cart
                $('.widget_shopping_cart').replaceWith(cart_dropdown);

                // update fragments
                if ( typeof $warp_fragment_refresh !== "undefined") {
                    $.ajax($warp_fragment_refresh);
                }
                $this.find('.button').removeClass('loading').addClass('added');

                $("body").trigger('added_to_cart');
            });
        });

        // declare class 
        var from_time = $('#wpc-from-time');
        var to_time   = $('#wpc-to-time');
        // get data from enqueue
        var wpc_booking_form_data;

        var wpc_date_format = "";
        var wpc_start_time = "";
        var wpc_end_time = "";
        var wpc_all_day_start_time = "";
        var wpc_all_day_end_time = "";

        if (typeof wpc_form_client_data !== "undefined") {
            var wpc_form_data = JSON.parse(wpc_form_client_data);
            wpc_booking_form_data = wpc_form_data.settings;
        }

        // set location in local storage and cancell modal
        $(".wpc_modal").on('click', '.wpc-select-location', function () {
            var wpc_location = $('.wpc-location option:selected').val();

            var local_storage_value = localStorage.getItem('wpc_location');
            if (local_storage_value === null) {
                localStorage.setItem('wpc_location', wpc_location);
            } else {
                localStorage.removeItem('wpc_location');
                localStorage.setItem('wpc_location', wpc_location);
            }
            $(".wpc_modal").fadeOut();
            $('body').removeClass('wpc_location_popup');

        });

        var wpc_time_format; var wpc_date_format;
        // time format
        if (typeof wpc_booking_form_data === "undefined") {
            wpc_time_format = 'H:i';
            wpc_date_format = 'yyyy-mm-dd'
        }
        
        else {
            if (typeof wpc_booking_form_data.wpc_time_format == "undefined" || wpc_booking_form_data.wpc_time_format == "24" || wpc_booking_form_data.wpc_time_format == "") {
                wpc_time_format = 'H:i';
            } else {
                wpc_time_format = 'h:i A';
            }
            // date format
            if (wpc_booking_form_data.wpc_date_format != "") {
                wpc_date_format = wpc_booking_form_data.wpc_date_format;
            } else {
                wpc_date_format = 'yyyy-mm-dd'
            }
        }
            
        // check multi slot , weekly and all day schedule
        
        const wpc_weekly_daily_schedule = ( selected_day ) => {
            if ( typeof wpc_all_day_start_time == 'undefined' || typeof wpc_all_day_end_time == 'undefined' ) {
                return 'clear_date'
            }
            // check multislot weekly and all day schedule
            if( typeof wpc_booking_form_data.reser_multi_schedule !== 'undefined' && 
            wpc_booking_form_data.reser_multi_schedule == "on" ){
                if ( $.isArray(wpc_booking_form_data.multi_start_time) && $.isArray(wpc_booking_form_data.multi_end_time) && wpc_booking_form_data.multi_start_time.length !== 0 && wpc_booking_form_data.multi_end_time.length !== 0  ) {
                    // generate time list based on multislot start and end time which will be excluded from the timepicker time list for creating disableTimeRange array
                    let multislotData = multislotTimePicker( wpc_booking_form_data.multi_start_time, wpc_booking_form_data.multi_end_time , wpc_booking_form_data.wpc_time_format );
                    wpc_booking_form_data.multi_time_excludes = multislotData['multi_time_excludes'];
                    wpc_start_time = multislotData['wpc_start_time'];
                    wpc_end_time = multislotData['wpc_end_time'];

                    $('#wpc-booking-date').removeClass("wpc_booking_error");
                    button_disable();
                }
            }
            //multislot end
            else{
                // time range for all day
                if (wpc_booking_form_data.wpc_all_day_start_time != "" && wpc_booking_form_data.wpc_all_day_end_time != "") {

                    wpc_all_day_start_time = wpc_booking_form_data.wpc_all_day_start_time;
                    wpc_all_day_end_time = wpc_booking_form_data.wpc_all_day_end_time;
                    if (wpc_booking_form_data.wpc_time_format == '24') {
                        wpc_start_time = convertTime12to24(wpc_all_day_start_time);
                        wpc_end_time = convertTime12to24(wpc_all_day_end_time);
                    } else {
                        wpc_start_time = wpc_all_day_start_time;
                        wpc_end_time = wpc_all_day_end_time;
                    }
                    $('#wpc-booking-date').removeClass("wpc_booking_error");
                    button_disable();
                }
                else {
                    var weekly_schedule_arr = wpc_booking_form_data.wpc_weekly_schedule;
                    var weekly_start_time = wpc_booking_form_data.wpc_weekly_schedule_start_time;
                    var weekly_end_time = wpc_booking_form_data.wpc_weekly_schedule_end_time;
                    var response = wpc_weekly_schedule_time(weekly_schedule_arr, selected_day, weekly_start_time, weekly_end_time);
                    if (response.success == true) {
                        $("#wpc-from-time").prop('disabled', false);
                        $("#wpc-to-time").prop('disabled', false);
                        if (wpc_booking_form_data.wpc_time_format == '24') {
                            wpc_start_time = convertTime12to24(response.wpc_start_time);
                            wpc_end_time = convertTime12to24(response.wpc_end_time);
                        } else {
                            wpc_start_time = response.wpc_start_time;
                            wpc_end_time = response.wpc_end_time;
                        }
                        $('#wpc-booking-date').removeClass("wpc_booking_error");
                        button_disable();
                    } else {
                        return "clear_date";
                    }
                }
            }

        }

        if (typeof wpc_date_format === 'undefined') {
            wpc_date_format = 'yyyy-mm-dd';
        }

        // check late booking
        const wpc_check_late_booking = (selected_time, last_booking_time, min) => {
            var time_diff_latebooked = time_diff_for_before_after_equal(selected_time, last_booking_time);
            error_message.html("");
            if (time_diff_latebooked == 'late') {
                from_time.val(' ');
                error_message.css("display", "block");
                error_message.html("You can boook before  " + min + " minutes of closing time .");
            } else {
                error_message.css("display", "none");
                from_time.removeClass("wpc_booking_error");
                button_disable();
            }
        }

        //  from time  
        from_time.timepicker({
            timeFormat: wpc_time_format,
            dynamic: true,
            step: 30, // 30 minutes
        });

        from_time.on('changeTime',function(){
            if ($(this).val() !== null) {
                // the input field
                var selected_time = $(this).val();
                if (typeof wpc_booking_form_data !== "undefined") {
                    var wpc_late_bookings = wpc_booking_form_data.wpc_late_bookings;
                    // late bookings
                    if (wpc_time_format != 'H:i' && typeof wpc_end_time !== 'undefined') {
                        wpc_end_time = convertTime12to24(wpc_end_time);
                        selected_time = convertTime12to24(selected_time);
                    }
                    if (typeof wpc_late_bookings !== 'undefinded' && wpc_late_bookings == '15') {
                        var last_booking_time = time_diff(wpc_end_time, "00:14");
                        if (selected_time !== '' && selected_time !== ',undefined') {
                            wpc_check_late_booking(selected_time, last_booking_time, 15);
                        }
                    } else if (typeof wpc_late_bookings !== 'undefinded' && wpc_late_bookings == '30') {

                        var last_booking_time = time_diff(wpc_end_time, "00:29");
                        if (selected_time !== '' && selected_time !== ',undefined') {
                            wpc_check_late_booking(selected_time, last_booking_time, 30);
                            return;
                        }
                    } else if (wpc_late_bookings != 'undefinded' && wpc_late_bookings == '45') {
                        var last_booking_time = time_diff(wpc_end_time, "00:44");
                        if (selected_time !== '' && selected_time !== ',undefined') {
                            wpc_check_late_booking(selected_time, last_booking_time, 45);
                        }
                    } else {
                        from_time.removeClass("wpc_booking_error");
                        button_disable();
                    }
                }
                else {
                    from_time.removeClass("wpc_booking_error");
                }
            }
        })
        
        //  To
        to_time.timepicker({
            timeFormat: wpc_time_format,
            dynamic: true,
        });

        to_time.on('changeTime',function(){
            if ($(this).val() !== null) {
                to_time.removeClass("wpc_booking_error");
                button_disable();
            }  
        })

        if (typeof wpc_booking_form_data !== "undefined") {
            var wpc_early_bookings = wpc_booking_form_data.wpc_early_bookings;
            var wpc_one_day = wpc_booking_form_data.wpc_one_day;
            var wpc_one_week = wpc_booking_form_data.wpc_one_week;
            var wpc_one_month = wpc_booking_form_data.wpc_one_month;
            var wpc_one_day = wpc_booking_form_data.wpc_one_day;
            var wpc_max_day = '';

            // early bookings
            if (typeof wpc_early_bookings !== 'undefinded' && wpc_early_bookings == '1day') {
                wpc_max_day = new Date(wpc_one_day);
            } else if (typeof wpc_early_bookings !== 'undefinded' && wpc_early_bookings == '1week') {
                wpc_max_day = new Date(wpc_one_week);
            } else if (typeof wpc_early_bookings !== 'undefinded' && wpc_early_bookings == '1month') {
                wpc_max_day = new Date(wpc_one_month);
            } else {
                wpc_max_day = false;
            }
        }

        var wpc_pro_form_data = $(".wpc-calender-view").html()
        var inline_value = true;
        if (typeof wpc_pro_form_data !== 'undefined' && wpc_pro_form_data == 'no') {
            inline_value = false;
        }
        var reserve_status = $(".wpc-reservation-form").data('reservation_status');

        // Change from and to time based on date .
        if ($('#wpc-booking-date').length > 0) {
            document.getElementById('wpc-booking-date').flatpickr({
                dateFormat: wpc_date_format,
                minDate: "today",
                maxDate: wpc_max_day,
                position: "below",
                inline: inline_value,
                onChange: function (selectedDates, dateStr, instance) {
                    if (typeof wpc_booking_form_data !== "undefined") {
                        var wpc_new_selected_date = wpc_flatpicker_date_change(selectedDates, "Y-m-d");
                        if ( wpc_booking_form_data.wpc_today ==  wpc_new_selected_date  && reserve_status.status == "closed") {
                                alert(reserve_status.message);
                            return;
                        }
                        var response;
                        var exception_date = wpc_booking_form_data.wpc_exception_date;
                        if (typeof exception_date === "undefined") {
                            var wpc_new_selected_date = wpc_flatpicker_date_change(selectedDates, "D");
                            response = wpc_weekly_daily_schedule(wpc_new_selected_date);
                        } else {
                            if (exception_date.length > 0 && exception_date[0] !== '') {
                                if ($.inArray(wpc_new_selected_date, exception_date) !== -1) {
                                    var index = exception_date.indexOf(wpc_new_selected_date);
                                    wpc_start_time = wpc_booking_form_data.wpc_exception_start_time[index];
                                    wpc_end_time = wpc_booking_form_data.wpc_exception_end_time[index];
                                    $('#wpc-booking-date').removeClass("wpc_booking_error");
                                    button_disable();
                                } else {
                                    var wpc_new_selected_date = wpc_flatpicker_date_change(selectedDates, "D");
                                    response = wpc_weekly_daily_schedule(wpc_new_selected_date);
                                }
                            } else {
                                var wpc_new_selected_date = wpc_flatpicker_date_change(selectedDates, "D");
                                response = wpc_weekly_daily_schedule(wpc_new_selected_date);
                            }
                        }

                        if ( response == "clear_date") {
                            $("#wpc-booking-date").val("");
                            $('#wpc-booking-date').addClass("wpc_booking_error");
                            alert("No schedule set from admin.");
                            $("#wpc-from-time").prop('disabled', true);
                            $("#wpc-to-time").prop('disabled', true);
                        } else {

                            $("#wpc-from-time").prop('disabled', false);
                            $("#wpc-to-time").prop('disabled', false);

                            if (wpc_time_format == "h:mm p") {
                                wpc_start_time = convertTime12to24(wpc_start_time);
                                wpc_end_time = convertTime12to24(wpc_end_time);
                            }

                            from_time.timepicker('option', 'minTime', wpc_start_time);
                            from_time.timepicker('option', 'maxTime', wpc_end_time);
                            // Disable time for multi slot
                            from_time.timepicker('option', 'disableTimeRanges', wpc_booking_form_data.multi_time_excludes );

                            to_time.timepicker('option', 'minTime', wpc_start_time);
                            to_time.timepicker('option', 'maxTime', wpc_end_time);
                            // Disable time for multi slot
                            to_time.timepicker('option', 'disableTimeRanges', wpc_booking_form_data.multi_time_excludes );
                        }
                    }
                    else {
                        $('#wpc-booking-date').removeClass("wpc_booking_error");
                    }
                }
            });
        }

        // reservation form validation
        function button_disable() {
            var length = $(".wpc_booking_error").length;
            var reservation_form_submit = $('.reservation_form_submit');
            if ( length == 0 ) {
                reservation_form_submit.prop('disabled', false).removeClass('wpc_reservation_form_disabled');
            } else {
                reservation_form_submit.prop('disabled', true).addClass('wpc_reservation_form_disabled');
            }
        }
        
        var check_selected_val = $("#wpc-party option:selected").val();

        if (check_selected_val == '') {
            $("#wpc-party").addClass('wpc_booking_error');
        }

        var booking_field = ["input[name='wpc_name']", "input[name='wpc_email']"];

        $("input").not(':button').each(function () {
            if ( $(this).attr('name') == 'wpc_phone' && $(this).prop('required') ) {
                $(this).addClass("wpc_booking_error");
                booking_field.push( "input[name='wpc_phone']" );
            }
            if ( $(this).attr('name') == 'wpc_from_time' && $(this).prop('required') ) {
                $(this).addClass("wpc_booking_error");
                booking_field.push( "input[name='wpc_from_time']" );
            }
            if ( $(this).attr('name') == 'wpc_to_time' && $(this).prop('required') ) {
                $(this).addClass("wpc_booking_error");
                booking_field.push( "input[name='wpc_to_time']" );
            }
            if ($(this).attr('name') == 'wpc_booking_date' ||
                $(this).attr('name') == 'wpc_name' ||
                $(this).attr('name') == 'wpc_email'
            ) {
                $(this).addClass("wpc_booking_error");
            }
            if ($(this).attr('name') == 'wpc_reservation_invoice' || $(this).attr('name') == 'wpc_cancell_email') {
                $(this).addClass("wpc_cancell_error");
            }
        });

        $.each(booking_field, function (index, value) {
            $(".wpc_reservation_table").on("keyup", value, function () {
                if ($(this).val().length == 0) {
                    $(this).addClass("wpc_booking_error");

                } else {
                    $(this).removeClass("wpc_booking_error");
                }
                button_disable();
            });
        });

        $(".wpc_reservation_table").on("change", "#wpc-party", function () {
            if ($(this).val() == "") {
                $(this).addClass("wpc_booking_error");
            }
            else {
                $(this).removeClass("wpc_booking_error");
            }
            button_disable();
        });

        var booking_length = $(".wpc_booking_error").length;
        if (booking_length > 0) {
            $('.reservation_form_submit').prop('disabled', true);
            $('.reservation_form_submit').addClass('wpc_reservation_form_disabled');
        }
        var cancel_button = $('.cancell_form_submit');

        // reservation cancell form validation
        function cancell_button_disable() {
            // var cancel_button = $('.cancell_form_submit');
            var length = $(".wpc_cancell_error").length;
            if (length == 0) {
                cancel_button.prop('disabled', false);
                cancel_button.removeClass('wpc_cancell_form_submit_disabled');

            } else {
                cancel_button.prop('disabled', true);
                cancel_button.addClass('wpc_cancell_form_submit_disabled');
            }
        }
        
        var cancell_length = $(".wpc_cancell_error").length;
        if (cancell_length > 0) {
            cancel_button.prop('disabled', true);
            cancel_button.addClass('wpc_cancell_form_submit_disabled');

        }
        var cancell_form_field = ["input[name='wpc_reservation_invoice']", "input[name='wpc_cancell_email']"];

        $.each(cancell_form_field, function (index, value) {
            $(".wpc_reservation_cancel_form").on("keyup", value, function () {
                if ($(this).val().length === 0) {
                    $(this).addClass("wpc_cancell_error");
                } else {
                    $(this).removeClass("wpc_cancell_error");
                }
                cancell_button_disable();
            });
        })

        // pop up structure 

        function food_menu_modal(modal_class, body_class) {
            if (document.querySelector("." + modal_class) !== null) {
                $("." + modal_class).fadeIn();
                $('body').addClass(body_class);
            }
        }

        function food_menu_modal_close(modal_class, body_class, from_icon = true, e = null, conent_id) {
            if (from_icon == true) {
                $("." + modal_class).fadeOut();
                $('body').removeClass(body_class);
            } else {
                var container = $("#" + conent_id);
                if (!container.is(e.target) && container.has(e.target).length === 0) {
                    $("." + modal_class).fadeOut();
                    $('body').removeClass(body_class);
                }
            }
        }

        // food location popup

        food_menu_modal('wpc_modal', 'wpc_location_popup');

        $('.wpc_modal').on('click', '.wpc-close', function () {
            food_menu_modal_close('wpc_modal', 'wpc_location_popup');
        });

        $('.wpc_modal').on('mouseup', function (e) {
            food_menu_modal_close('wpc_modal', 'wpc_location_popup', false, e, 'wpc_location_modal');
        });

        // reservation from show /hide
        $('.wpc_reservation_table').on('click', '#wpc_cancel_request', function () {
            $('.wpc-reservation-form .wpc_reservation_table').slideUp();
            $('.wpc-reservation-form .wpc_reservation_cancel_form').slideDown();
        });
        $('.wpc_reservation_cancel_form').on('click', '#wpc_book_table', function () {
            $('.wpc-reservation-form .wpc_reservation_cancel_form').slideUp();
            $('.wpc-reservation-form .wpc_reservation_table').slideDown();
        });
        var wpc_cart_block = $('.wpc_cart_block');
        // cart icon open
        wpc_cart_block.on('click', '.wpc_cart_icon', function (event) {
            event.preventDefault();
            wpc_cart_block.toggleClass('cart_icon_active');
        });

        wpc_cart_block.on('mouseup', function (e) {
            if (!wpc_cart_block.is(e.target) && wpc_cart_block.has(e.target).length === 0) {
                wpc_cart_block.removeClass('cart_icon_active');
            }
        });

        if (typeof wpc_form_data !== 'undefined') {
            // reservation form submit
            var wpc_ajax_url = wpc_form_data.wpc_ajax_url;
            var wpc_reservation_form_nonce = wpc_form_data.wpc_reservation_form_nonce;
            $(".reservation_form_submit").on('click', function (e) {
                e.preventDefault(); var wpc_diff_data = "";
                var wpc_reservation_first = $(".reservation_form_first_step").val();
                if (typeof wpc_reservation_first !== 'undefined' && wpc_reservation_first == 'reservation_form_first_step') {
                    var wpc_name = $("#wpc-name").val();
                    var wpc_email = $("#wpc-email").val();
                    var wpc_phone = $("#wpc-phone").val();
                    var wpc_booking_date = $("#wpc-booking-date").val();
                    var wpc_from_time = $("#wpc-from-time").val();
                    var wpc_to_time = $("#wpc-to-time").val();
                    var wpc_guest_count = $("#wpc-party option:selected").val();
                    var wpc_message = $("#wpc-message").val();

                    if (wpc_booking_form_data.wpc_time_format == '12') {
                        wpc_from_time = convertTime12to24(wpc_from_time);
                        wpc_to_time = convertTime12to24(wpc_to_time);
                        wpc_diff_data = time_diff_for_before_after_equal(wpc_from_time, wpc_to_time);
                    } else {
                        wpc_diff_data = time_diff_for_before_after_equal(wpc_from_time, wpc_to_time);
                    }

                    if (wpc_diff_data == 'late' || wpc_diff_data == 'equal') {
                        log_message.fadeOut('slow');
                        log_message.html('');
                        error_message.fadeIn('slow');
                        error_message.html("Booking end time must be after start time.");
                    } else {
                        error_message.html('');
                        // booking from for check
                        $(".wpc_reservation_form_two").fadeIn("slow");
                        $(".wpc_reservation_form_one").fadeOut("slow");

                        $(".wpc_check_name").html(wpc_name);
                        $(".wpc_check_email").html(wpc_email);
                        $(".wpc_check_phone").html(wpc_phone);
                        $(".wpc_check_guest").html(wpc_guest_count);
                        $(".wpc_check_start_time").html(wpc_from_time);
                        $(".wpc_check_end_time").html(wpc_to_time);
                        $(".wpc_check_booking_date").html(wpc_booking_date);
                        $(".wpc_check_message").html(wpc_message);
                    }
                }
            });
            $(".cancell_form_submit,.confirm_booking_btn").on('click', function (e) {
                e.preventDefault();

                var wpc_invoice = $(".wpc-invoice").val();
                var wpc_email = $(".wpc_cancell_email").val();
                if (typeof wpc_invoice !== "undefined" && (wpc_invoice !== '' && wpc_email !== '')) {

                    var wpc_phone = $(".wpc_cancell_phone").val();
                    var wpc_message = $(".wpc_cancell_message").val();
                    var data = {
                        action: 'wpc_check_for_submission',
                        _wpcnonce: wpc_reservation_form_nonce,
                        wpc_cancell_email: wpc_email,
                        wpc_cancell_phone: wpc_phone,
                        wpc_reservation_invoice: wpc_invoice,
                        wpc_message: wpc_message,
                        wpc_action: 'wpc_cancellation',
                    }
                }
                else {
                    var reservation_form_second_step = $(this).data('id');
                    if (typeof reservation_form_second_step !== 'undefined' && reservation_form_second_step == 'reservation_form_second_step') {
                        var wpc_name = $(".wpc_check_name").text();
                        var wpc_email = $(".wpc_check_email").text();
                        var wpc_phone = $(".wpc_check_phone").text();
                        var wpc_guest_count = $(".wpc_check_guest").text();
                        var wpc_from_time = $(".wpc_check_start_time").text();
                        var wpc_to_time = $(".wpc_check_end_time").text();
                        var wpc_booking_date = $(".wpc_check_booking_date").text();
                        var wpc_message = $(".wpc_check_message").text();
                        var reserv_extra = typeof reservation_extra_field ==="function" ? reservation_extra_field() : [] ;
                        var data = {
                            action: 'wpc_check_for_submission',
                            _wpcnonce: wpc_reservation_form_nonce,
                            wpc_name: wpc_name,
                            wpc_email: wpc_email,
                            wpc_phone: wpc_phone,
                            wpc_booking_date: wpc_booking_date,
                            wpc_from_time: wpc_from_time,
                            wpc_to_time: wpc_to_time,
                            wpc_guest_count: wpc_guest_count,
                            wpc_message: wpc_message,
                            reserv_extra: reserv_extra,
                            wpc_action: 'wpc_reservation',
                        }
                    }
                }
                $.ajax({
                    url: wpc_ajax_url,
                    method: 'post',
                    data: data,
                    success: function (response) {
                        if (response.data.data.form_type == 'wpc_reservation' &&
                            ($.isArray(response.data.message) && response.data.message.length > 0)) {
                            error_message.css('display', 'none');
                            error_message.html('');
                            log_message.css('display', 'block');
                            log_message.html(response.data.message[0]);
                            $("#wpc-name").val("");
                            $("#wpc-email").val("");
                            $("#wpc-phone").val("");
                            $("#wpc-booking-date").val("");
                            $("#wpc-from-time").val("");
                            $("#wpc-to-time").val("");
                            $("#wpc-party option:selected").removeAttr("selected");
                            $("#wpc-message").val("");
                            $(".confirm_booking_btn").css('display', 'none');
                            $(".confirm_booking_btn").addClass('confirm_booking_btn_disabled');
                            $(".edit_booking_btn").fadeOut('slow');
                        }
                        else if (response.data.data.form_type == 'wpc_reservation_field_missing' &&
                            ($.isArray(response.data.message) && response.data.message.length > 0)) {
                                error_message.css('display', 'block');
                                error_message.html(response.data.message[0]);
                        }
                        else if (response.data.data.form_type == 'wpc_reservation_cancell' &&
                            ($.isArray(response.data.message) && response.data.message.length > 0)) {
                                error_message.css('display', 'none');
                                error_message.html('');
                                cancell_log_message.css('display', 'block');
                                cancell_log_message.html(response.data.message[0]);
                                $(".wpc_cancell_email").val("");
                                $(".wpc_cancell_phone").val("");
                                $(".wpc_cancell_message").val("");
                                $(".wpc-invoice").val("");
                            if (response.data.status_code === 200) {
                                $(".cancell_form_submit").fadeOut('slow');
                            }

                        }
                        else if (response.data.data.form_type == 'wpc_reservation_cancell_field_missing' &&
                            ($.isArray(response.data.message) && response.data.message.length > 0)) {
                                error_message.css('display', 'block');
                                error_message.html(response.data.message[0]);
                                cancell_log_message.css('display', 'none');
                        }
                    }
                });
            });
        }

        // back to edit form
        $(".edit_booking_btn").on('click', function (e) {
            e.preventDefault();
            // booking from for check
            $(".wpc_reservation_form_two").fadeOut('slow');
            $(".wpc_reservation_form_one").fadeIn('slow');
        });
    });
})(jQuery);