(function ($, elementor) {
    "use strict";

    var wpc = {

        init: function () {
            var widgets = {
                'wpc-menu-tab.default': wpc.wpc_menu_tab,
            };
            $.each(widgets, function (widget, callback) {
                elementor.hooks.addAction('frontend/element_ready/' + widget, callback);
            });
        },

        wpc_menu_tab: function ($scope) {
            var $container = $scope.find('.wpc-food-tab-wrapper');
            if ($container.length > 0) {
                $('.wpc-tab-a').on('click', function (event) {
                    event.preventDefault();
                    $(this).parent().parent().parent().find(".wpc-tab").removeClass('tab-active');
                    $(".wpc-tab[data-id='" + $(this).attr('data-id') + "']").addClass("tab-active");
                    $(".wpc-tab-a").removeClass('wpc-active');
                    $(this).parent().find(".wpc-tab-a").addClass('wpc-active');
                });
            }
        },
    };
    $(window).on('elementor/frontend/init', wpc.init);
}(jQuery, window.elementorFrontend));