<?php

namespace WpCafe_Pro\Core\Widgets;

defined("ABSPATH") || exit;

use WC_Product;
use WpCafe_Pro\Utils\Utilities as Pro_Utilities;
use WpCafe\Utils\Wpc_Utilities as Wpc_Utilities;
use WpCafe\Core\Base\Wpc_Settings_Field as Settings;
use WP_Post;
use WpCafe_Pro\Traits\Singleton;

/**
 * create post type class
 */
class Hook
{
    use \WpCafe_Pro\Traits\Singleton;

    private $settings_obj = null;
    public $wpc_message   = '';
    public $wpc_cart_css  = '';

    /**
     * call hooks
     */

    public function init()
    {
        $this->settings_obj = Settings::instance()->get_settings_option();
        // add shortcode
        add_shortcode('wpc_pro_food_menu_tab', [$this, 'food_menu_tab']);
        add_shortcode('wpc_pro_food_menu_list', [$this, 'food_menu_list']);
        add_shortcode('wpc_pro_business_hour', [$this, 'business_hour']);
        add_shortcode('wpc_pro_menu_category_list', [$this, 'food_menu_category_list']);
        add_shortcode('wpc_pro_menu_location_list', [$this, 'food_menu_location_list']);
        add_shortcode('wpc_pro_menu_slider', [$this, 'food_menu_slider']);
        add_shortcode('wpc_pro_menu_tab_with_slider', [$this, 'food_menu_tab_with_slider']);
        add_shortcode('wpc_pro_food_menu_loadmore', [$this, 'food_menu_loadmore']);

        // add filter to reservation template
        add_filter('wpcafe/action/reservation_template', [$this, 'reservations_template'], 10, 1);
        add_filter('wpcafe/action/extra_field', [$this, 'reservations_submit_extra_field'], 10, 2);
        add_filter('wpcafe/meta/extra_field_label', [$this, 'reservations_report_extra_field'], 10, 1);

        // place shortcode to a page
        add_filter('the_content', [$this, 'place_shortcode']);

        // Set the price with WooCommerce compatibility 
        if (class_exists('WooCommerce')) {
            // add body classes
            add_filter('body_class', [$this, 'wpc_body_classes']);

            // search like
            add_filter('posts_where', [$this, 'title_like_posts_where'], 10, 2);

            add_filter('woocommerce_get_item_data', [$this, 'display_cart_item_custom_meta_data'], 10, 2);
            add_action('woocommerce_single_product_summary', [$this, 'meta_product'], 15);

            // change in single page
            add_filter('woocommerce_get_price_html', [$this, 'change_simple_product_price_html'], 10, 2);

            // change in cart price
            add_filter('woocommerce_cart_item_price', [$this, 'product_discount_price_cart'], 10, 3);

            // sub totoall 
            add_action('woocommerce_before_calculate_totals', [$this, 'woocommerce_calculate_subtotal'], 10, 1);

            // money off from total
            add_filter('woocommerce_calculated_total', [$this, 'money_off'], 10, 2);
            add_action('woocommerce_cart_total', [$this, 'add_text_cart_totals']);

            // add discount label in order total  thank you
            add_action('woocommerce_checkout_update_order_meta', [$this, 'change_total_on_thankyou'], 10, 4);

            // show standard off in thank you 
            add_action('woocommerce_order_details_after_order_table', [$this, 'standard_off_thank_you_page'], 10, 1);

            // show order time details in thank you 
            add_action('woocommerce_order_details_before_order_table', [$this, 'order_times_thank_you_page'], 10, 1);

            // show standard off in admin order details page 
            add_action('woocommerce_admin_order_totals_after_total', [$this, 'standard_off_admin_order_details'], 10, 1);

            if (version_compare(WC()->version, '3.0', '<')) {
                add_action('woocommerce_add_order_item_meta', [$this, 'order_item_add_discount'], 1, 2);
            } else {
                add_action('woocommerce_new_order_item', [$this, 'order_item_add_discount'], 1, 2);
            }
            // add order time manage feature in checkout page 
            add_action('woocommerce_checkout_before_customer_details', [$this, 'order_time_manage']);
            add_action('woocommerce_checkout_create_order', [$this, 'update_order_time_update_meta'], 10, 2);

            add_action("woocommerce_widget_shopping_cart_before_buttons", [$this, "handle_mini_cart_buttons_before"]);

            // variation product 
            add_action('variation/product_title', 'woocommerce_template_single_title', 5);
            add_action('variation/product_thumbnails', 'woocommerce_show_product_images', 20);
            add_action('variation/popup_content', 'woocommerce_template_single_rating', 10);
            add_action('variation/popup_content', 'woocommerce_template_single_price', 15);
            add_action('variation/popup_content', 'woocommerce_show_product_sale_flash', 10);
            add_action('variation/popup_content', 'woocommerce_template_single_excerpt', 20);
            add_action('variation/popup_content', 'woocommerce_template_single_add_to_cart', 25);

            if (isset($this->settings_obj['wpc_pro_woocommerce_variation_layout']) && $this->settings_obj['wpc_pro_woocommerce_variation_layout'] == 'on') {
                add_filter('woocommerce_dropdown_variation_attribute_options_html', [$this, 'variation_radio_buttons'], 20, 2);
                add_filter('woocommerce_dropdown_variation_attribute_options_args', [$this, 'variation_select_add_class'], 2);
                add_filter('woocommerce_locate_template', [$this, 'wpcafe_variable_template'], 1, 3);
            }
            // variation button 
            add_filter('wpcafe/shortcode/variation', [$this, 'variation_option_content'], 10, 3);
        }
        // add image control in food location
        add_action('wpcafe_location_add_form_fields', [$this, 'location_taxonomy_add_new_meta_field'], 10, 1);
        add_action('wpcafe_location_edit_form_fields', [$this, 'location_taxonomy_edit_meta_field'], 10, 1);
        add_action('edited_wpcafe_location', [$this, 'taxonomy_save_meta_field'], 10, 1);
        add_action('create_wpcafe_location', [$this, 'taxonomy_save_meta_field'], 10, 1);

        //Displaying Additional Columns
        add_filter('manage_edit-wpcafe_location_columns', [$this, 'wpc_custom_fields_list_title']);
        add_action('manage_wpcafe_location_custom_column', [$this, 'wpc_custom_fields_list_diplay'], 10, 3);

        // elementor widget live search 
        add_filter( 'elementor/control/search_control', [ $this , 'widget_search_control' ],10, 1 );
        add_filter( 'elementor/control/search_data', [ $this , 'widget_search_data' ], 10, 3 );
    }

    /**
     * Search function
     *
     */
    public function title_like_posts_where($where, $wp_query){
        global $wpdb;
        if ($post_title_like = $wp_query->get('post_title_like')) {
            $where .= ' AND ' . $wpdb->posts . '.post_title LIKE \'%' . esc_sql($wpdb->esc_like($post_title_like)) . '%\'';
        }
        return $where;
    }

    /**
     * Variation template
     */
    public function wpcafe_variable_template($template, $template_name, $template_path){
        if ($template_name == "single-product/add-to-cart/variable.php") {
            return WPC_PRO_CORE . "template/woocommerce/single-product/add-to-cart/variable.php";
        }
        return $template;
    }

    /**
     * add class in variation function
     */
    public function variation_select_add_class($args){
        $args['class'] = 'wpc_variation_poppup';
        return $args;
    }

    /**
     * Variation product template
     */
    public function variation_popup_template($product_id){
        // Set the main wp query for the product.
        wp('p=' . $product_id . '&post_type=product');
        while (have_posts()) :
            the_post();
        ?>
            <div id="product-<?php echo intval($product_id) ?>" <?php post_class('product wpc-row') ?>>

                <div class="wpc-col-lg-6 variation_product_image">
                    <?php
                    do_action('variation/product_thumbnails');
                    ?>
                </div>
                <div class="wpc-col-lg-6">
                    <div class="wpc-single-content summary entry-summary">
                        <?php do_action('variation/product_title') ?>

                        <?php
                        do_action('variation/popup_content');
                        ?>
                    </div>
                </div>
            </div>
        <?php
        endwhile; // end of the loop.
    }

    /**
     * Variation radio function
     */
    public function variation_radio_buttons($html, $args){

        $args = wp_parse_args(apply_filters('woocommerce_dropdown_variation_attribute_options_args', $args), array(
            'options'          => false,
            'attribute'        => false,
            'product'          => false,
            'selected'         => false,
            'name'             => '',
            'id'               => '',
            'class'            => '',
            'show_option_none' => esc_html__('Choose an option', 'wpcafe-pro'),
        ));

        if (false === $args['selected'] && $args['attribute'] && $args['product'] instanceof WC_Product) {
            $selected_key     = 'attribute_' . sanitize_title($args['attribute']);
            $args['selected'] = isset($_REQUEST[$selected_key]) ? wc_clean(wp_unslash($_REQUEST[$selected_key])) : $args['product']->get_variation_default_attribute($args['attribute']);
        }

        $options               = $args['options'];
        $product               = $args['product'];
        $attribute             = $args['attribute'];
        $name                  = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title($attribute);
        $id                    = $args['id'] ? $args['id'] : sanitize_title($attribute);
        $class                 = $args['class'];
        $show_option_none      = (bool)$args['show_option_none'];
        $show_option_none_text = $args['show_option_none'] ? $args['show_option_none'] : esc_html__('Choose an option', 'wpcafe-pro');

        if (empty($options) && !empty($product) && !empty($attribute)) {
            $attributes = $product->get_variation_attributes();
            $options    = $attributes[$attribute];
        }

        $radios = '<div class="wpc-variation">';
        $radios .= '<label class="wpc-variation-title">' . esc_html(wc_attribute_label($attribute)) . '<span class="dashicons dashicons-minus toggle-icon-trigger"></span></label>';
        $radios .= '<div class="wpc-variation-body variation-radios">';
        if (!empty($options)) {
            if ($product && taxonomy_exists($attribute)) {
                $terms = wc_get_product_terms($product->get_id(), $attribute, array(
                    'fields' => 'all',
                ));

                foreach ($terms as $term) {
                    if (in_array($term->slug, $options, true)) {
                        $radios .= '<label for="' . esc_attr($term->slug) . '"><input type="radio" name="' . esc_attr($name) . '" value="' . esc_attr($term->slug) . '" ' . checked(sanitize_title($args['selected']), $term->slug, false) . '><span>' . esc_html(apply_filters('woocommerce_variation_option_name', $term->name)) . '</span></label>';
                    }
                }
            } else {
                foreach ($options as $option) {
                    $checked    = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], sanitize_title($option), false) : checked($args['selected'], $option, false);
                    $radios    .= '<label for="' . sanitize_title($option) . '"><input type="radio" name="' . esc_attr($name) . '" value="' . esc_attr($option) . '" id="' . sanitize_title($option) . '" ' . $checked . '><span>' . esc_html(apply_filters('woocommerce_variation_option_name', $option)) . '</span></label>';
                }
            }
        }
        $radios .= '</div></div>';

        return $html . $radios;
    }

    /**
     * Check discount for a product function
     *
     * @param [type] $product_id
     */
    public function check_discount_of_product($product_id, $flag = null){
        $settings = $this->settings_obj;
        $wpc_pro_discount_message = '';
        $tag_message = '';
        $data = [];
        $wpc_pro_discount_product = isset($settings['wpc_pro_include_menu']) ? $settings['wpc_pro_include_menu'] : [];
        $wpc_pro_discount_cat = isset($settings['wpc_pro_include_cat']) ? $settings['wpc_pro_include_cat'] : [];
        $wpc_pro_percentage   = isset($settings['wpc_pro_discount_percentage'])  ? sanitize_text_field($settings['wpc_pro_discount_percentage']) : null;

        if (in_array($product_id, $wpc_pro_discount_product)) {
            if ($wpc_pro_percentage !== '0' && !empty($wpc_pro_percentage)) {
                $wpc_pro_discount_message .=   esc_html__("Discount " . $wpc_pro_percentage, 'wpcafe-pro') . "%";
                $tag_message .= esc_html__($wpc_pro_percentage, 'wpcafe-pro') . "%";
            }
        } else {
            // get cat id 
            $wpc_pro_terms = get_the_terms($product_id, 'product_cat');
            if (is_array($wpc_pro_terms)) {
                foreach ($wpc_pro_terms as $term) {
                    if (in_array($term->term_id, $wpc_pro_discount_cat)) {
                        if ($wpc_pro_percentage !== '0' && !empty($wpc_pro_percentage)) {
                            $wpc_pro_discount_message .=  esc_html("Discount " . $wpc_pro_percentage . "%");
                            $tag_message .= esc_html__($wpc_pro_percentage . "% off", 'wpcafe-pro');
                        }
                    }
                }
            }
        }
        if (empty($flag)) {
            $data['message'] = $wpc_pro_discount_message;
            if ($data['message'] !== '') {
                $data['percentage'] = $wpc_pro_percentage;
            } else {
                $data['percentage'] = '';
            }
        } else {
            $data['percentage_offer'] = $tag_message; // tag name
        }
        return $data;
    }

    /**
     * Show tag function
     *
     * @param [type] $id
     * @return void
     */
    public function tag($id, $stock_status){
        ?>
        <div class="wpc-pro-tag">
            <?php
            echo \WpCafe\Utils\Wpc_Utilities::wpc_tag($id, $stock_status);
            // show discount 
            if ($stock_status == true) {
                $data = $this->check_discount_of_product($id, 'wpc_pro_tag');
                if (count($data) > 0 && $data['percentage_offer'] != '') {
            ?>
                    <ul class="wpc-menu-tag wpc-discount-offer">
                        <li><?php echo esc_html($data['percentage_offer']); ?></li>
                    </ul>
            <?php
                }
            }
            ?>
        </div>
        <?php
    }
    /**
     * Convert food preparing and delivery time for individual product
     */
    public function food_time_in_convert($time){
        $time = explode(':', $time);
        $main_time = '';
        if (is_array($time)) {
            if (isset($time[0]) && $time[0] !== '' && $time[0] !== '00') {
                $main_time .= $time[0] . " " . "hr";
            }
            if (isset($time[1]) && $time[1] !== '' && $time[1] !== '00') {
                $main_time .= $time[1] . " " . "min";
            }
        }
        return $main_time;
    }

    /**
     * Food preparing and delivery function
     *
     * @param [type] $id
     * @return void
     */
    public function food_time($id){
        // food preparing and delivary time
        $wpc_pro_preparing_time = get_post_meta($id, 'wpc_pro_preparing_time', true);
        $wpc_pro_preparing_time = $this->food_time_in_convert($wpc_pro_preparing_time);
        $wpc_pro_delivery_time = get_post_meta($id, 'wpc_pro_delivery_time', true);
        $wpc_pro_delivery_time = $this->food_time_in_convert($wpc_pro_delivery_time);

        if ($wpc_pro_preparing_time !== '' || $wpc_pro_delivery_time !== '') {
        ?>
            <ul class="wpc_pro_food_time">
                <?php if ($wpc_pro_preparing_time !== '') { ?>
                    <li class="wpc_pro_food_preparing_time">
                        <span class="wpc_label_meta">
                            <?php echo esc_html__(' Preparing time : ', 'wpcafe-pro'); ?>
                        </span>
                        <span class="wpc_preparing_time">
                            <?php echo Wpc_Utilities::wpc_numeric($wpc_pro_preparing_time); ?>
                        </span>
                    </li>
                <?php }
                if ($wpc_pro_delivery_time !== '') { ?>
                    <li class="wpc_pro_food_delivery_time">
                        <span class="wpc_label_meta">
                            <?php echo esc_html__(' Delivery time : ', 'wpcafe-pro'); ?>
                        </span>
                        <span class="wpc_preparing_time">
                            <?php echo Wpc_Utilities::wpc_numeric($wpc_pro_delivery_time); ?>
                        </span>
                    </li>
                <?php } ?>
            </ul>
        <?php
        }
    }

    /**
     * Food menu tab shortcode
     *
     * @param [type] $atts
     * @param [type] $content
     * @return void
     */
    public function food_menu_tab($atts){
        if (!class_exists('Woocommerce')) {
            return;
        }
        
        ob_start();

        $settings = $this->settings_obj;
        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }
        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories'   => '',
                'style'                 => 'style-3',
                'no_of_product'         => 5,
                'show_thumbnail'        => "yes",
                'wpc_cart_button'       => 'yes',
                'title_link_show'       => 'yes',
                'wpc_menu_col'          => '6',
                'wpc_show_desc'         => 'yes',
                'wpc_desc_limit'        => '15',
                'live_search'           => 'yes',
                'wpc_delivery_time_show'=> 'yes',
                'show_item_status'      => 'yes',
                'wpc_btn_text'          => 'yes',
                'customize_btn'         => '',
                'wpc_menu_order'        => 'DESC',
            ], $atts ));
            
        $style = (isset($style) && $style != '') ? $style : 'style-3';
        $widget_id = md5(md5(microtime()));
        $wpc_cat_arr      = explode(',', $wpc_food_categories);

        if ($live_search == 'yes') {
            // live search 
            $template_path = WPC_PRO_DIR . "/widgets/food-menu-tab/style/{$style}.php";
            $widget_arr=array(
				'show_thumbnail' 		=> $show_thumbnail,
                'title_link_show' 		=> $title_link_show,
                'wpc_menu_order' 		=> $wpc_menu_order,
				'show_item_status' 		=> $show_item_status,
				'wpc_delivery_time_show'=> $wpc_delivery_time_show,
				'wpc_show_desc'			=> $wpc_show_desc,
				'wpc_desc_limit'		=> $wpc_desc_limit,
				'wpc_btn_text'			=> $wpc_btn_text,
				'customize_btn'			=> $customize_btn,
				'widget_id'				=> $widget_id,
				'wpc_menu_col'			=> $wpc_menu_col,
			);
            echo Singleton::live_search_markup($no_of_product, $wpc_cat_arr, $wpc_cart_button,'tab_template', $template_path , $widget_arr );
        }

        $wpc_cat_sort_arr = [];
        $i                = 0;
        if (is_array($wpc_cat_arr)) {
            foreach ($wpc_cat_arr as $value) {
                $i++;

                if ($wpc_cat = get_term_by('id', $value, 'product_cat')) {
                    $wpc_get_menu_order = get_term_meta($wpc_cat->term_id, 'wpc_menu_order_priority', true);
                    if ($wpc_get_menu_order == '') {
                        $wpc_cat_sort_arr[$i] = $value;
                    } else {
                        $wpc_cat_sort_arr[$wpc_get_menu_order] = $value;
                    }
                }
            }
        }
        ksort($wpc_cat_sort_arr);
        ?>
        <div class="wpc-food-tab-wrapper wpc-food-menu-wrapper wpc-nav-shortcode main_wrapper_<?php echo esc_html($widget_id)?>">
            <ul class="wpc-nav">
                <?php
                foreach ($wpc_cat_sort_arr as $key => $value) {
                    if ($wpc_cat = get_term_by('id', $value, 'product_cat')) {
                        $active_class = (($key == array_keys($wpc_cat_sort_arr)[0]) ? 'wpc-active' : ' ');
                ?>
                        <li>
                            <a href="#" data-id="tab_<?php echo intval($key); ?>" data-cat_id="<?php echo intval($value) ?>" class="wpc-tab-a <?php echo esc_attr($active_class); ?>" data-toggle="tab" aria-expanded="true">
                                <span><?php echo esc_attr_e($wpc_cat->name, 'wpcafe-pro'); ?></span>
                            </a>
                        </li>
                <?php
                    }
                }
                ?>
            </ul>
            <div class='wpc-tab-content  wpc-widget-wrapper'>
                <?php
                foreach ($wpc_cat_sort_arr as $current_key => $value) {
                    $active_class = (($current_key == array_keys($wpc_cat_sort_arr)[0]) ? 'tab-active' : ' ');
                ?>
                    <div class='wpc-tab <?php echo esc_attr($active_class); ?>' data-cat_id="<?php echo intval($value) ?>" data-id='tab_<?php echo intval($current_key); ?>'>
                        <div class="tab_template_<?php echo intval($value); ?>"></div>
                        <div class="template_data_<?php echo intval($value); ?>">
                            <?php
                            $products = Wpc_Utilities::product_query("product", $no_of_product, [$value], "DESC");
                            include WPC_PRO_DIR . "/widgets/food-menu-tab/style/{$style}.php";

                            ?>
                        </div>
                    </div>
                <?php
                }
                ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }


    /**
     * Food menu slider
     *
     * @param [type] $atts
     * @param [type] $content
     * @return void
     */
    public function food_menu_slider($atts){
        if (!class_exists('Woocommerce')) {
            return;
        }

        ob_start();

        $settings = $this->settings_obj;
        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }
        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories' => '',
                'style' => 'style-3',
                'wpc_menu_count' => 5,
                'wpc_slider_count' => 3,
                'show_thumbnail' => "yes",
                'wpc_menu_order' => "DESC",
                'wpc_cart_button' => 'yes',
                'title_link_show' => 'yes',
                'wpc_show_desc' => 'yes',
                'wpc_desc_limit' => '15',
                'wpc_delivery_time_show' => 'yes',
                'wpc_slider_nav_show' => 'yes',
                'wpc_slider_dot_show' => 'yes',
                'show_item_status' => 'yes',
                'wpc_btn_text' => '',
                'customize_btn' => '',
            ],
            $atts
        ));
        $style = (isset($style) && $style != '') ? $style : 'style-1';
        $widget_id = md5(md5(microtime()));
        $wpc_cat_arr      = explode(',', $wpc_food_categories);



        $products = Wpc_Utilities::product_query("product", $wpc_menu_count, $wpc_cat_arr, $wpc_menu_order);

        ?>
        <div class="wpc-menu-slider-shortcode">
            <?php include WPC_PRO_DIR . "/widgets/food-menu-slider/style/{$style}.php"; ?>
        </div>

        <?php
        return ob_get_clean();
    }


    /**
     * Food menu slider
     *
     * @param [type] $atts
     * @param [type] $content
     * @return void
     */
    public function food_menu_loadmore($atts){
        if (!class_exists('Woocommerce')) {
            return;
        }

        ob_start();

        $settings = $this->settings_obj;
        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }
        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories' => '',
                'style' => 'style-1',
                'wpc_menu_count' => 5,
                'show_thumbnail' => "yes",
                'wpc_menu_order' => "DESC",
                'wpc_cart_button' => 'yes',
                'title_link_show' => 'yes',
                'wpc_show_desc' => 'yes',
                'wpc_desc_limit' => '15',
                'wpc_delivery_time_show' => 'yes',
                'show_item_status' => 'yes',
                'wpc_btn_text' => '',
                'customize_btn' => '',
            ],
            $atts
        ));
        $widget_id = md5(md5(microtime()));
        $wpc_cat_arr      = explode(',', $wpc_food_categories);
        $products 		= Wpc_Utilities::product_query( "product", $wpc_menu_count , $wpc_cat_arr , $wpc_menu_order );
		$total_products = count ( Wpc_Utilities::product_query( "product", $wpc_menu_count , $wpc_cat_arr , $wpc_menu_order , null , true ) );

        $widget_data = [
			'show_item_status'           => $show_item_status,
			'show_thumbnail'             => $show_thumbnail,
			'wpc_cart_button_show'       => $wpc_cart_button,
			'title_link_show'            => $title_link_show,
			'wpc_btn_text'               => $wpc_btn_text,
			'customize_btn'              => $customize_btn,
			'wpc_desc_limit'             => $wpc_desc_limit,
			'wpc_show_desc'              => $wpc_show_desc,
			'order'                      => $wpc_menu_order,
			'wpc_menu_count'             => $wpc_menu_count,
			'cat_id'                     => $wpc_cat_arr,
			'total_post'                 => $total_products,
			'widget_id'					 =>	$widget_id
        ];
        $ajax_json_data 			= json_encode( $widget_data );

        $style = (isset($style) && $style != '') ? $style : 'style-1';

		if (is_array( $products ) && count( $products )>0 ) {
			include WPC_PRO_DIR . "/widgets/food-menu-loadmore/style/{$style}.php";
		}

		if( $total_products > $wpc_menu_count): ?>
		<div class="loadmore-btn-wrap">
			<div class="loadmore wpc-btn" data-json_grid_meta="<?php echo esc_attr($ajax_json_data); ?>" data-paged="<?php echo esc_attr(isset($paged) ? $paged : 2); ?>">
				<?php echo esc_html__('Load More...', 'wpcafe-pro'); ?>
			</div>
		</div>
		<?php endif; 

        return ob_get_clean();
    }

    /**
     * Food menu tab with slider
     *
     * @param [type] $atts
     * @param [type] $content
     * @return void
     */
    public function food_menu_tab_with_slider($atts){
        if (!class_exists('Woocommerce')) {
            return;
        }

        ob_start();

        $settings = $this->settings_obj;
        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }
        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories' => '',
                'style' => 'style-3',
                'no_of_product' => 5,
                'wpc_slider_count' => 3,
                'show_thumbnail' => "yes",
                'wpc_cart_button' => 'yes',
                'title_link_show' => 'yes',
                'wpc_menu_col' => '6',
                'wpc_show_desc' => 'yes',
                'wpc_desc_limit' => '15',
                'wpc_delivery_time_show' => 'yes',
                'wpc_slider_nav_show' => 'yes',
                'wpc_slider_dot_show' => 'yes',
                'show_item_status' => 'yes',
                'wpc_btn_text' => 'yes',
                'customize_btn' => '',
            ],
            $atts
        ));
        $style = (isset($style) && $style != '') ? $style : 'style-1';
        $widget_id = md5(md5(microtime()));
        $wpc_cat_arr      = explode(',', $wpc_food_categories);

        $wpc_cat_sort_arr = [];
        $i                = 0;
        if (is_array($wpc_cat_arr)) {
            foreach ($wpc_cat_arr as $value) {
                $i++;

                if ($wpc_cat = get_term_by('id', $value, 'product_cat')) {
                    $wpc_get_menu_order = get_term_meta($wpc_cat->term_id, 'wpc_menu_order_priority', true);
                    if ($wpc_get_menu_order == '') {
                        $wpc_cat_sort_arr[$i] = $value;
                    } else {
                        $wpc_cat_sort_arr[$wpc_get_menu_order] = $value;
                    }
                }
            }
        }
        ksort($wpc_cat_sort_arr);
        ?>
        <div class="wpc-menu-tab-slider-shortcode">
            <div class="wpc-food-tab-wrapper wpc-food-menu-wrapper wpc-nav-shortcode">
                <ul class="wpc-nav">
                    <?php
                    foreach ($wpc_cat_sort_arr as $key => $value) {
                        if ($wpc_cat = get_term_by('id', $value, 'product_cat')) {
                            $active_class = (($key == array_keys($wpc_cat_sort_arr)[0]) ? 'wpc-active' : ' ');
                    ?>
                            <li>
                                <a href="#" data-id="tab_<?php echo intval($key); ?>" data-cat_id="<?php echo intval($value) ?>" class="wpc-tab-a <?php echo esc_attr($active_class); ?>" data-toggle="tab" aria-expanded="true">
                                    <span><?php echo esc_attr_e($wpc_cat->name, 'wpcafe-pro'); ?></span>
                                </a>
                            </li>
                    <?php
                        }
                    }
                    ?>
                </ul>
                <div class='wpc-tab-content  wpc-widget-wrapper'>
                    <?php
                    foreach ($wpc_cat_sort_arr as $current_key => $value) {
                        $active_class = (($current_key == array_keys($wpc_cat_sort_arr)[0]) ? 'tab-active' : ' ');
                    ?>
                        <div class='wpc-tab <?php echo esc_attr($active_class); ?>' data-cat_id="<?php echo intval($value) ?>" data-id='tab_<?php echo intval($current_key); ?>'>
                            <div class="tab_template_<?php echo intval($value); ?>"></div>
                            <div class="template_data_<?php echo intval($value); ?>">
                                <?php
                                $products = Wpc_Utilities::product_query("product", $no_of_product, [$value], "DESC");
                                include WPC_PRO_DIR . "/widgets/menu-tab-with-slider/style/{$style}.php";

                                ?>
                            </div>
                        </div>
                    <?php
                    }
                    ?>
                </div>


            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    /**
     * Food menu list block
     *
     * @param Type $var
     */
    public function food_menu_list($atts){

        if (!class_exists('Woocommerce')) { return; }

        $settings = $this->settings_obj;
        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        ob_start();
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }
        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'style' => 'style-1',
                'wpc_food_categories' => '',
                'show_thumbnail' => 'yes',
                'no_of_product' => 5,
                'live_search' => 'yes',
                'show_item_status' => 'yes',
                'title_link_show' => 'yes',
                'wpc_cart_button' => 'yes',
                'wpc_delivery_time_show' => 'yes',
                'wpc_show_desc' => 'yes',
                'customize_btn' => '',
                'wpc_btn_text' => '',
                'wpc_desc_limit' => '10',
                'wpc_menu_order' => 'DESC',
                'wpc_menu_col' => '4'
            ],$atts));
            $wpc_cat_arr   = explode(',', $wpc_food_categories);
            if ($live_search == 'yes') {
                $template_path = WPC_PRO_DIR . "/widgets/menus/style/{$style}.php";
                $widget_id = md5(md5(microtime()));
                // live search 
                $widget_arr=array(
                    'show_thumbnail' 		=> $show_thumbnail,
                    'title_link_show' 		=> $title_link_show,
                    'wpc_menu_order' 		=> $wpc_menu_order,
                    'show_item_status' 		=> $show_item_status,
                    'wpc_delivery_time_show'=> $wpc_delivery_time_show,
                    'wpc_show_desc'			=> $wpc_show_desc,
                    'wpc_desc_limit'		=> $wpc_desc_limit,
                    'wpc_btn_text'			=> $wpc_btn_text,
                    'customize_btn'			=> $customize_btn,
                    'widget_id'				=> $widget_id,
                    'wpc_menu_col'			=> $wpc_menu_col,
                );
                echo Singleton::live_search_markup($no_of_product, $wpc_cat_arr, $wpc_cart_button,'list_template', $template_path , $widget_arr );
            }
            ?>
        <div class="main_wrapper_<?php echo esc_html($widget_id)?>">
            <div class="list_template_<?php echo esc_html( $widget_id ) ;?> wpc-nav-shortcode">
                <?php
                if (is_array($wpc_cat_arr) && count($wpc_cat_arr) > 0) {
                    $products = Wpc_Utilities::product_query("product", $no_of_product, $wpc_cat_arr, $wpc_menu_order);
                    include WPC_PRO_DIR . "/widgets/menus/style/{$style}.php";
                }
                ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    /**
     * Food menu category list
     *
     * @param Type $var
     */
    public function food_menu_category_list($atts){
        if (!class_exists('Woocommerce')) { return; }
        ob_start();
        // shortcode option
        $atts = extract(shortcode_atts(
            ['style' => 'style1', 'wpc_food_categories' => '', 'category_limit' => 5, 'show_count' => "yes", 'grid_column' => 4],
            $atts
        ));

        // category sorting from backend
        $categories_id   = explode(',', $wpc_food_categories);
        $taxonomy    = 'product_cat';
        if (is_array($categories_id) && !empty($categories_id[0])) {
            $cats = $categories_id;
        } else {
            $args_cat = array(
                'taxonomy'     => $taxonomy,
                'number' => $category_limit,
                'hide_empty' => false,
            );
            $cats = get_categories($args_cat);
        }

        switch ($style) {
            case 'style1': ?>
                <div class="wpc-menu-category-wrap wpc-category-list-style1">
                    <?php
                    include WPC_PRO_DIR . "/widgets/category-list/style/style-1.php";
                    ?>
                </div>
            <?php
                break;
            case 'style2': ?>
                <div class="wpc-menu-category-wrap wpc-category-list-style2">
                    <?php
                    include WPC_PRO_DIR . "/widgets/category-list/style/style-1.php";
                    ?>
                </div>
            <?php
                break;
            case 'style3': ?>
                <div class="wpc-menu-category-wrap wpc-category-list-style3">
                    <?php
                    include WPC_PRO_DIR . "/widgets/category-list/style/style-1.php";
                    ?>
                </div>
            <?php
                break;
            case 'style4': ?>
                <div class="wpc-menu-category-wrap wpc-category-list-style4">
                    <?php
                    include WPC_PRO_DIR . "/widgets/category-list/style/style-2.php";
                    ?>
                </div>
            <?php
                break;
            default:
                include WPC_PRO_DIR . "/widgets/category-list/style/style-1.php";
        }
        return ob_get_clean();
    }

    /**
     * Food menu location list
     *
     * @param Type $var
     */
    public function food_menu_location_list($atts){
        if (!class_exists('Woocommerce')) { return; }
        ob_start();
        // shortcode option
        $atts = extract(shortcode_atts(
            ['style' => 'style1', 'location_ids' => '', 'location_limit' => 5, 'show_count' => "yes", 'grid_column' => 4],
            $atts
        ));

        // category sorting from backend
        $categories_id   = explode(',', $location_ids);
        $taxonomy    = 'wpcafe_location';
        if (is_array($categories_id) && !empty($categories_id[0])) {
            $cats = $categories_id;
        } else {
            $args_cat = array(
                'taxonomy'     => $taxonomy,
                'number' => $location_limit,
                'hide_empty' => false,
            );
            $cats = get_categories($args_cat);
        }

        switch ($style) {
            case 'style1': ?>
                <div class="wpc-menu-location-wrap wpc-location-list-style1">
                    <?php
                    include WPC_PRO_DIR . "/widgets/menu-location-list/style/style-1.php";
                    ?>
                </div>
            <?php
                break;
            case 'style2': ?>
                <div class="wpc-menu-location-wrap wpc-location-list-style2">
                    <?php
                    include WPC_PRO_DIR . "/widgets/menu-location-list/style/style-1.php";
                    ?>
                </div>
            <?php
                break;
            case 'style3': ?>
                <div class="wpc-menu-location-wrap wpc-location-list-style3">
                    <?php
                    include WPC_PRO_DIR . "/widgets/menu-location-list/style/style-1.php";
                    ?>
                </div>
            <?php
                break;
            case 'style4': ?>
                <div class="wpc-menu-location-wrap wpc-location-list-style4">
                    <?php
                    include WPC_PRO_DIR . "/widgets/menu-location-list/style/style-2.php";
                    ?>
                </div>
            <?php
                break;
            default:
                include WPC_PRO_DIR . "/widgets/menu-location-list/style/style-1.php";
        }
        return ob_get_clean();
    }

    /**
     * Show business hour in markup 
     */
    public  function business_hour_markup($alldays, $day_name, $start_time, $end_time){
        if ($alldays) {
            ?>
            <li>
                <?php
                echo esc_html($day_name, 'wpcafe-pro') . '   ' . $start_time . '---' . $end_time;
                ?>
            </li>
            <?php
        } else {
            echo esc_html__('Our opening time ' . $start_time . ' and closing time 
                ' . $end_time . ' ', 'wpcafe-pro');
        }
    }

    /**
     * Show business hour function
     */
    public function business_hour($atts){
        ob_start();
        extract(shortcode_atts(['all_days_schedule' => 'yes'], $atts));
        $settings = $this->settings_obj;
        if (is_array($settings)) {
            if (isset($settings['business_hour_label']) &&  $settings['business_hour_label'] !== '') {
            ?>
                <h3><?php echo esc_html__($settings['business_hour_label'], 'wpcafe-pro') ?></h3>
            <?php
            } else {
            ?>
                <h3><?php echo esc_html__('Our business hour', 'wpcafe-pro') ?></h3>
            <?php
            }
            if (
                isset($settings['wpc_weekly_schedule']) && isset($settings['wpc_weekly_schedule_start_time']) && sanitize_text_field($settings['wpc_weekly_schedule_start_time'] !== '')
                && isset($settings['wpc_weekly_schedule_end_time']) && sanitize_text_field($settings['wpc_weekly_schedule_end_time'] !== '')
            ) {
            ?>
                <ul class="wpc_pro_business_hour">
                    <?php
                    if ($all_days_schedule == 'yes') {
                        if (count($settings['wpc_weekly_schedule']) > 0) {
                            for ($i = 0; $i < count($settings['wpc_weekly_schedule']); $i++) {
                                foreach ($settings['wpc_weekly_schedule'][$i] as $key => $value) {
                                    $this->business_hour_markup(true, $key, $settings['wpc_weekly_schedule_start_time'][$i], $settings['wpc_weekly_schedule_end_time'][$i]);
                                }
                            }
                        }
                    } else {
                        $today = date('D');
                        if (count($settings['wpc_weekly_schedule']) > 0) {
                            for ($i = 0; $i < count($settings['wpc_weekly_schedule']); $i++) {
                                foreach ($settings['wpc_weekly_schedule'][$i] as $key => $value) {
                                    if ($today == $key) {
                                        $this->business_hour_markup(true, $key, $settings['wpc_weekly_schedule_start_time'][$i], $settings['wpc_weekly_schedule_end_time'][$i]);
                                    }
                                }
                            }
                        }
                    }
                    ?>
                </ul>
                <?php
            } else if (
                isset($settings['wpc_all_day_start_time']) && sanitize_text_field($settings['wpc_all_day_start_time'] !== '')
                && isset($settings['wpc_all_day_end_time']) && sanitize_text_field($settings['wpc_all_day_end_time'] !== '')
            ) {
                if ($all_days_schedule == 'yes') {
                    $all_days = ['Satarday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'];
                ?>
                    <ul class="wpc_pro_business_hour">
                        <?php
                        foreach ($all_days as $key => $value) {
                            $this->business_hour_markup(true, $value, $settings['wpc_all_day_start_time'], $settings['wpc_all_day_end_time']);
                        }
                        ?>
                    </ul>
                <?php
                } else {
                ?>
                    <div class="wpc_pro_business_hour">
                        <?php
                        $today = date('D');
                        $this->business_hour_markup(false, $today, $settings['wpc_all_day_start_time'], $settings['wpc_all_day_end_time']);
                        ?>
                    </div>
                <?php
                }
            } else {
                ?>
                <div class="wpc_pro_business_hour">
                    <?php
                    echo esc_html__('Schedule not set', 'wpcafe-pro');
                    ?>
                </div>
        <?php
            }
        }
        return ob_get_clean();
    }

    /**
     * Display discount data in  cart item meta data (in cart)
     */
    public function display_cart_item_custom_meta_data($item_data, $cart_item){
        $wpc_pro_check_discount = $this->check_discount_of_product($cart_item['product_id']);
        ?>
        <div class='wpc_pro_discount_price'><?php echo esc_html($wpc_pro_check_discount['message'], 'wpcafe-pro'); ?></div>
        <?php

        return $item_data;
    }

    /**
     * Displaying the value on single product pages
     *
     * @param [type] $product_id
     */
    public function meta_product(){
        global $product;
        $wpc_pro_check_discount = $this->check_discount_of_product($product->get_id());
        ?>
        <div><?php echo esc_html($wpc_pro_check_discount['message'], 'wpcafe-pro'); ?></div>
        <?php
    }

    /**
     * Change price in single page function and from backend product price
     *
     */
    public function change_simple_product_price_html($price_html, $product){
        $wpc_pro_data = $this->discount_price($product->get_id(), 'wpc_pro_single_page');
        if (
            is_product() && !empty($wpc_pro_data['main_price']) && !empty($wpc_pro_data['price_afer_discount'])
            && $wpc_pro_data['main_price'] !== '' && $wpc_pro_data['price_afer_discount'] !== ''
        ) { ?>
            <div class='wpc-price-wrap'>
                <del class='wpc-main-price'><?php echo get_woocommerce_currency_symbol() . esc_html($wpc_pro_data['main_price']); ?></del>
                <span class='wpc-discount-price'><?php echo get_woocommerce_currency_symbol() . esc_html($wpc_pro_data['price_afer_discount']) ?></span>
            </div>
        
        <?php } else {

            return $price_html;
        }
    }

    /**
     * Return discount price function
     *
     * @param [type] $product_id
     */
    public function discount_price($product_id, $data, $product_price = null){
        $wpc_pro_check_discount = $this->check_discount_of_product($product_id);
        // if discount found
        if (is_array($wpc_pro_check_discount) && $wpc_pro_check_discount['percentage'] !== '') {
            if (empty($product_price)) {
                $product = wc_get_product($product_id);
                // Get current price 
                $main_price = is_numeric($product->get_price()) ? $product->get_price() : floatval($product->get_price());
            } else {
                $main_price = (float) $product_price;
            }
            $percentage = $wpc_pro_check_discount['percentage'];
            $price_after_discount  = ($percentage / 100) * $main_price;
            $new_price = $main_price - $price_after_discount;
            if ($data == 'wpc_pro_cart' || $data == 'wpc_pro_cart_sub_total') {
                // Set the new price
                return $new_price;
            } else {
                $data = [];
                $data['main_price'] = $main_price;
                $data['price_afer_discount'] = $new_price;
                return $data;
            }
        }
    }

    /**
     * Change price in cart function
     *
     * @param [type] $price
     * @param [type] $cart_item
     * @param [type] $cart_item_key
     */
    public function product_discount_price_cart($price, $cart_item, $cart_item_key){
        $product = wc_get_product($cart_item['product_id']);
        $main_price = "";
        $price_for_discount = "";
        if ($product->get_type() == "variable") {
            $main_price = $price;
            $price_for_discount = $cart_item['data']->get_price();
        } else {
            $main_price = get_woocommerce_currency_symbol() . $product->get_price();
            $price_for_discount = $product->get_price();
        }
        $get_discount_price = $this->discount_price($cart_item['product_id'], 'wpc_pro_cart', $price_for_discount);
        if (empty($get_discount_price) === false) { ?>
            <div class='wpc_pro_main_price'><?php echo esc_html__("Main price ", 'wpcafe-pro') . $main_price; ?></div>
            <?php
            $price = $get_discount_price;
        }

        return $price;
    }

    /**
     * Filter subtotal function
     *
     * @param [type] $cart
     */
    public function woocommerce_calculate_subtotal($cart_object){
        if (is_admin() && !defined('DOING_AJAX'))
            return;
        if (did_action('woocommerce_before_calculate_totals') >= 2)
            return;
        foreach ($cart_object->get_cart() as $cart_item) {
            // Price calculation 
            $get_discount_price = $this->discount_price($cart_item['product_id'], 'wpc_pro_cart_sub_total');
            if (!empty($get_discount_price)) {
                // Set the price with WooCommerce compatibility 
                if (version_compare(WC()->version, '3.0', '<')) {
                    $cart_item['data']->price =  (float) $get_discount_price; // Before WC 3.0
                } else {
                    $cart_item['data']->set_price((float) $get_discount_price); // WC 3.0+
                }
            }
        }
    }

    /**
     * Check money off function
     *
     * @return void
     */
    public function money_off_data(){
        $settings = $this->settings_obj;
        $wpc_pro_order_standarad_off_amount = isset($settings['wpc_pro_order_standarad_off_amount']) ? $settings['wpc_pro_order_standarad_off_amount'] : '';
        $wpc_pro_discount_standarad_off     = isset($settings['wpc_pro_discount_standarad_off']) ? $settings['wpc_pro_discount_standarad_off'] : '';
        $data = [];
        $data['wpc_pro_order_standarad_off_amount'] = $wpc_pro_order_standarad_off_amount;
        $data['wpc_pro_discount_standarad_off']     = $wpc_pro_discount_standarad_off;

        return $data;
    }

    /**
     * Total with standarad money off function
     *
     * @param [type] $cart
     * @return void
     */
    public function money_off($total, $cart){
        $wpc_pro_money_off = $this->money_off_data();
        // check if money off not null
        if ($wpc_pro_money_off['wpc_pro_order_standarad_off_amount'] !== '' && $wpc_pro_money_off['wpc_pro_discount_standarad_off'] !== '') {
            return $total - $wpc_pro_money_off['wpc_pro_discount_standarad_off'];
        } else {
            return $total;
        }
    }

    /**
     * Change cart total text  function
     *
     * @param [type] $price
     * @return void
     */
    public function add_text_cart_totals($price){
        $wpc_pro_money_off = $this->money_off_data();
        // check if money off not null
        if ($wpc_pro_money_off['wpc_pro_order_standarad_off_amount'] !== '' && $wpc_pro_money_off['wpc_pro_discount_standarad_off'] !== '') {
            if ($wpc_pro_money_off['wpc_pro_discount_standarad_off'] !== '0') {
                $wpc_pro_money_off_message = "After money off " . $wpc_pro_money_off['wpc_pro_discount_standarad_off'];
            ?>
                <div><?php echo esc_html($wpc_pro_money_off_message, 'wpcafe-pro'); ?></div>
            <?php } ?>
            <div><?php echo Wpc_Utilities::wpc_kses($price); ?></div>
        <?php
        } else {
            return $price;
        }
    }

    /**
     * Add discount on thank you and admin order
     *
     * @param [type] $item_id
     * @param [type] $values
     * @return void
     */
    public function order_item_add_discount($item_id, $values) {
        $wpc_pro_data = $this->discount_price($values['product_id'], 'thank_you_order_details');
        if (
            $wpc_pro_data['main_price'] !== '' && $wpc_pro_data['price_afer_discount'] !== ''
            && !empty($wpc_pro_data['main_price']) && !empty($wpc_pro_data['price_afer_discount'])
        ) {
            wc_add_order_item_meta($item_id, esc_html__('Main price', 'wpcafe-pro'), $wpc_pro_data['main_price']);
            wc_add_order_item_meta($item_id, esc_html__('Price after discount', 'wpcafe-pro'), $wpc_pro_data['price_afer_discount']);
        }
    }

    /**
     * Standard discount save from checkout Total function
     *
     * @return void
     */
    public function change_total_on_thankyou($order_id){
        $wpc_pro_money_off = $this->money_off_data();
        // check if money off not null
        if (
            $wpc_pro_money_off['wpc_pro_order_standarad_off_amount'] !== '' && $wpc_pro_money_off['wpc_pro_discount_standarad_off'] !== ''
            &&  !empty($wpc_pro_money_off['wpc_pro_order_standarad_off_amount']) &&  !empty($wpc_pro_money_off['wpc_pro_discount_standarad_off'])
            && $wpc_pro_money_off['wpc_pro_discount_standarad_off'] !== '0'
        ) {
            $wpc_pro_money_off_message = "After money off " . $wpc_pro_money_off['wpc_pro_discount_standarad_off'];
            update_post_meta($order_id, 'wpc_pro_money_off', $wpc_pro_money_off_message);
        }
    }

    public function standard_message($id){
        $wpc_pro_money_off = get_post_meta($id, 'wpc_pro_money_off', true);
        ?>
        <div class="wpc_pro_standard_off"><?php echo esc_html($wpc_pro_money_off, 'wpcafe-pro'); ?></div>
        <?php
    }

    /**
     * Show standard off in thank you page
     *
     * @param [type] $order
     * @return void
     */
    public function standard_off_thank_you_page($order) {
        $wpc_pro_order_id = $order->get_data()['id'];
        $this->standard_message($wpc_pro_order_id);
    }

    /**
     * Show standard off in admin order page
     *
     * @param [type] $order_id
     * @return void
     */
    public function standard_off_admin_order_details($order_id){
        $this->standard_message($order_id);
    }

    /**
     * Order, pickup, delivery time manager function
     *
     * @return void
     */
    public function order_time_manage(){
        $wpc_pro_settings = $this->settings_obj;
        if (Pro_Utilities::data_validation_check($wpc_pro_settings['wpc_pro_allow_order_for'])) {

            $checkout = WC()->checkout;

            // allow label
            if (isset($wpc_pro_settings['wpc_pro_allow_delivery_type_label']) && $wpc_pro_settings['wpc_pro_allow_delivery_type_label'] == 'on') {
                $wpc_pro_order_time_array['label'] = esc_html__('Delivary type', 'wpcafe-pro');
            }
            if (Pro_Utilities::data_validation_check($wpc_pro_settings['wpc_pro_allow_order_for'])) {
                $wpc_pro_hidden_field = '';
                if ($wpc_pro_settings['wpc_pro_allow_order_for'] == 'Delivery') {
                    $wpc_pro_hidden_field .= '<input type="hidden" name="wpc_pro_order_time" value="Delivery"/>';
                    echo Wpc_Utilities::wpc_kses($wpc_pro_hidden_field);
                } elseif ($wpc_pro_settings['wpc_pro_allow_order_for'] == 'Pickup') {
                    $wpc_pro_hidden_field .= '<input type="hidden" name="wpc_pro_order_time" value="Pickup"/>';
                    echo Wpc_Utilities::wpc_kses($wpc_pro_hidden_field);
                } elseif ($wpc_pro_settings['wpc_pro_allow_order_for'] == 'Both') {
                    $wpc_pro_options = ['Pickup' => esc_html__('Pickup','wpcafe-pro'), 'Delivery' => esc_html__('Delivery','wpcafe-pro')];
                    // radio
                    $wpc_pro_order_time_array = [
                        'type'        => 'radio',
                        'class'       => ['wpc_pro_order_time form-row-wide'],
                        'options'     => $wpc_pro_options,
                        'required'    => true,
                    ];
                    woocommerce_form_field('wpc_pro_order_time', $wpc_pro_order_time_array, $checkout->get_value('wpc_pro_order_time'));
                }
        ?>
            <div class="wpc_pro_order_time_settings">
                <?php
                $wpc_time_pickup_id =  Pro_Utilities::data_validation_check($wpc_pro_settings['wpc_pro_allow_order_for'])
                    && $wpc_pro_settings['wpc_pro_allow_order_for'] == 'Both' ? 'both_pickup' : '';
                $wpc_time_delivery_id =  Pro_Utilities::data_validation_check($wpc_pro_settings['wpc_pro_allow_order_for'])
                    && $wpc_pro_settings['wpc_pro_allow_order_for'] == 'Both' ? 'both_delivery' : '';
                if (
                    Pro_Utilities::data_validation_check($wpc_pro_settings['wpc_pro_allow_order_for'])
                    && ($wpc_pro_settings['wpc_pro_allow_order_for'] == 'Both'
                        || $wpc_pro_settings['wpc_pro_allow_order_for'] == 'Delivery')
                ) {
                ?>
                    <div class="wpc_pro_delivery" id="<?php echo esc_attr($wpc_time_delivery_id); ?>">
                        <div class="wpc_pro_date_section">
                            <?php
                            $div_class = isset($wpc_pro_settings['wpc_pro_allow_delivery_time']) ? 'form-row-first' : '';
                            woocommerce_form_field('wpc_pro_delivery_date', [
                                'label'        => 'Delivery date',
                                'type'        => 'text',
                                'class'       => ['wpc_pro_delivery_date ' . $div_class . ''],
                                'required'    => true,
                            ]);
                            ?>
                        </div>
                        <?php
                        if (
                            isset($wpc_pro_settings['wpc_pro_allow_delivery_time']) &&
                            sanitize_text_field($wpc_pro_settings['wpc_pro_allow_delivery_time']) == 'on'
                        ) {
                        ?>
                            <div class="wpc_pro_time_section">
                                <?php
                                woocommerce_form_field('wpc_pro_delivery_time', [
                                    'label'        => 'Delivery time',
                                    'type'        => 'text',
                                    'class'       => ['wpc_pro_delivery_time form-row-last'],
                                    'required'    => true,
                                ]);
                                ?>
                            </div>
                        <?php
                        }
                        if (Pro_Utilities::data_validation_check($wpc_pro_settings['wpc_pro_delivery_message'])) {
                        ?>
                            <div class="wpc_pro_delivary_message">
                                <?php
                                echo esc_html($wpc_pro_settings['wpc_pro_delivery_message'], 'wpcafe-pro');
                                ?>
                            </div>
                        <?php
                        } ?>
                    </div>
                <?php
                }

                if (
                    Pro_Utilities::data_validation_check($wpc_pro_settings['wpc_pro_allow_order_for'])
                    && ($wpc_pro_settings['wpc_pro_allow_order_for'] == 'Both'
                        || $wpc_pro_settings['wpc_pro_allow_order_for'] == 'Pickup')
                ) {
                ?>
                    <div class="wpc_pro_pickup" id="<?php echo esc_attr($wpc_time_pickup_id); ?>">
                        <div class="wpc_pro_date_section">
                            <?php
                            $div_class = isset($wpc_pro_settings['wpc_pro_allow_pickup_time']) ? 'form-row-first' : '';

                            woocommerce_form_field(
                                'wpc_pro_pickup_date',
                                [
                                    'label'        => 'Pickup date',
                                    'type'        => 'text',
                                    'class'       => ['wpc_pro_pickup_date ' . $div_class . ''],
                                    'required'    => true,
                                ]
                            );
                            ?>
                        </div>
                        <?php
                        if (
                            isset($wpc_pro_settings['wpc_pro_allow_pickup_time']) &&
                            sanitize_text_field($wpc_pro_settings['wpc_pro_allow_pickup_time']) == 'on'
                        ) {
                        ?>
                            <div class="wpc_pro_time_section">
                                <?php
                                woocommerce_form_field(
                                    'wpc_pro_pickup_time',
                                    [
                                        'label'        => 'Pickup time',
                                        'type'        => 'text',
                                        'class'       => ['wpc_pro_pickup_time form-row-last'],
                                        'required'    => true,
                                    ]
                                );
                                ?>
                            </div>
                        <?php
                        }
                        if (Pro_Utilities::data_validation_check($wpc_pro_settings['wpc_pro_pickup_message'])) {
                        ?>
                            <div class="wpc_pro_pickup_message">
                                <?php
                                echo esc_html($wpc_pro_settings['wpc_pro_pickup_message'], 'wpcafe-pro');
                                ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php
                } ?>
            </div>
        <?php
            }
        }
    }
    /**
     * Get checkout order time array in desired format
     */
    public function get_array(){
        return [
            'Delivery type' => 'wpc_pro_order_time',
            'Delivery date' => 'wpc_pro_delivery_date',
            'Delivery time' => 'wpc_pro_delivery_time',
            'Pickup date'   => 'wpc_pro_pickup_date',
            'Pickup time'   => 'wpc_pro_pickup_time'
        ];
    }

    /**
     * Update order time data
     *
     * @param [type] $order
     * @return void
     */
    public function update_order_time_update_meta($order){
        //check for validation
        $post_arr = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if (Pro_Utilities::data_validation_check_arr($post_arr)) {
            $checked_data = $this->get_array();
            $checked_data = array_values($checked_data);
            foreach ($post_arr as $key => $value) {
                if (in_array($key, $checked_data) && $key !== '') {
                    $order->update_meta_data($key, $value);
                }
            }
        }
    }

    /**
     * Show order time data in thank you page
     */
    public function order_times_thank_you_page($order){
        $wpc_pro_order_id = $order->get_data()['id'];
        $checked_data = $this->get_array();
    ?>
        <ul class="wpc-pickup-delivery">
            <?php
            foreach ($checked_data as $key => $value) {
                $wpc_pro_result = get_post_meta($wpc_pro_order_id, $value, true);
                if ($wpc_pro_result !== '') { ?>
                    <li><?php echo esc_html($key); ?>: <strong><?php echo esc_html($wpc_pro_result, 'wpcafe-pro'); ?></strong></li>
            <?php } } ?>
        </ul>
        <?php
    }

    /**
     * Place shortcode to any page function
     *
     */
    public function place_shortcode($content){
        if (!is_admin()) {
            global $post;
            if (!$post instanceof WP_Post) return $content;
            $settings = $this->settings_obj;
            if (is_array($settings)) {
                if (isset($settings['wpc_reservation_form_display_page']) && $settings['wpc_reservation_form_display_page'] !== '') {
                    if ($post->post_type == 'page' && $post->ID == $settings['wpc_reservation_form_display_page']) {
                        $shortcode = "[wpc_reservation_form wpc_image_url='']";
                        $content = $content . $shortcode;
                    }
                }
            }
        }

        return $content;
    }

    /**
     * Get reservation by single / multi slot and 
     * By time range
     */
    public function get_all_reservation( $state ,$data=[] ){
        $all_reservation = array(); $meta_data = array();
        $meta_query = 
        array(
            array(
                'key'           => 'wpc_reservation_state',
                'value'         => array( $state ),
                'compare'       => 'IN'
            ),
            array(
                'key' => 'wpc_booking_date',
                'value' => date( 'Y-m-d' ),
                'compare' => 'LIKE',
            )
        );

        // get reservation 
        if( is_array( $data ) && count( $data )> 0 && isset($data['start_time'] ) && isset( $data['end_time'] ) ){
            $meta_data = array(
                'key'       => 'wpc_to_time',
                'value'     => array( date( 'H:i:s', strtotime($data['start_time'])) , date( 'H:i:s', strtotime($data['end_time'])) ),
                'compare'   => 'BETWEEN',
            );
            array_push( $meta_query , $meta_data );
        }

        $all_reservation = get_posts(
            array(
                'post_type'   => 'wpc_reservation',
                'numberposts'       => -1,
                'post_status'       => 'publish',
                'meta_query'        => $meta_query 
            )
        );

        // count reservation
        $total_seat = 0;
        if( count( $all_reservation )>0 ){
            foreach ($all_reservation as $key => $value) {
                $total_seat_in_reserve  = get_post_meta($value->ID, 'wpc_total_guest', true);
                $total_seat += (int) $total_seat_in_reserve;
            }
        }
        
        return $total_seat;
    }

    /**
     * Reservation status based on seat capacity
     */
    public function reser_capacity_status( $settings ){
        $response = array(); $booking = "open"; 
        $current_time = date("H:i", strtotime("+6 hours"));
        $status = false; $state = "confirmed";
        if( isset( $settings['rest_reservation_off'] ) && $settings['rest_reservation_off'] !== "" ){
            $state = $settings['rest_reservation_off'];
        }

        // check for multi-slot
        if( isset( $settings['reser_multi_schedule'] ) && $settings['reser_multi_schedule'] =="on" ) { 

            $data = Wpc_Utilities::multi_schedule_time_seat( $settings );
            if ( is_array( $data ) && count( $data )>0 ) {
                $total_seat = $this->get_all_reservation( $state ,
                [ 'capacity' => $data['capacity'] ,'start_time' => $data['multi_start_schedule'] , 'end_time' => $data['multi_end_schedule'] ] );
                if( (int) $data['capacity']  == 0 ){
                    $booking                = "closed";
                    $response['message']    = esc_html__('Reservation is closed now.','wpcafe-pro');
                }
                elseif ( $total_seat  >= (int) $data['capacity'] ) {
                    $booking                = "closed";
                    $response['message']    = esc_html__('Our all seat is booked till '. $data['multi_end_schedule'] .'. Reservation is closed . Please try after '. $data['multi_end_schedule'].'','wpcafe-pro');
                } 
            }
        }
        else {
            // check for sinle slot

            if (  isset($settings['rest_max_reservation']) && $settings['rest_max_reservation'] !== "" ) :
                if (isset($settings['wpc_all_day_end_time']) && $settings['wpc_all_day_end_time'] !== "") {
                    $schedule_end_time = date("H:i", strtotime($settings['wpc_all_day_end_time']));
                    if ($current_time > $schedule_end_time) {
                        $status = true;
                    }
                } elseif (
                    isset($settings['wpc_weekly_schedule']) && is_array($settings['wpc_weekly_schedule']) &&
                    count($settings['wpc_weekly_schedule']) > 0 ) {
                    for ($i = 0; $i < count($settings['wpc_weekly_schedule']); $i++) {
                        if (isset($settings['wpc_weekly_schedule'][$i][date('D')]) && $settings['wpc_weekly_schedule'][$i][date('D')] == 'on') {
                            $schedule_end_time = date("H:i", strtotime($settings['wpc_weekly_schedule_end_time'][$i]));
                            if ($current_time > $schedule_end_time) {
                                $status = true;
                            }
                        }
                    }
                }

                $total_seat = $this->get_all_reservation( $state  );

                if ($total_seat  >= (int) $settings['rest_max_reservation'] && $status == false) {
                    $booking                = "closed";
                    $response['message']    = esc_html__('Our all seat is booked . Reservation is closed for today.Please try another day','wpcafe-pro');
                }
            endif;
        }

        $response['status'] = $booking;

        return $response;
    } 

    /** 
     * Pass reservation pro options to free
    */
    public function reservations_template($atts){
        $settings = $this->settings_obj;

        if ( is_array($atts) && isset($atts['calender_view']) ) {
        ?>
            <div class="wpc-calender-view wpc-none"><?php echo esc_html($atts['calender_view']); ?></div>
        <?php
            $column_lg = ($atts['calender_view'] == 'yes') ? 'wpc-col-lg-6' : 'wpc-col-lg-12';
            $column_md = ($atts['calender_view'] == 'yes') ? 'wpc-col-md-12' : 'wpc-col-md-6';
            $atts['column_lg'] = $column_lg;
            $atts['column_md'] = $column_md;
        } else {
            $atts = array();
            $atts['calender_view'] = 'yes';
            $atts['column_lg']     = 'wpc-col-lg-6';
            $atts['column_md']     = 'wpc-col-md-12';
        }
        $atts['reservation_extra_field']= $this->reservation_extra_field( $settings );
        $data       = Wpc_Utilities::multi_schedule_time_seat( $settings );
        $capacity   = is_array( $data ) && count( $data )>0 ? $data['capacity'] : 0;
        $atts['seat_capacity']          = $capacity;
        $atts['booking_status']         = $this->reser_capacity_status( $settings );
        $atts['show_form_field']        = isset( $settings['show_form_field'] ) ? $settings['show_form_field'] : 'on';
        $atts['required_from_field']    = isset( $settings['required_from_field'] ) ? $settings['required_from_field'] : 'on';
        $atts['from_field_label']       = isset( $settings['from_field_label'] ) && $settings['from_field_label'] !=="" ? $settings['from_field_label'] : esc_html__('From','wpcafe-pro');
        $atts['show_to_field']          = isset( $settings['show_to_field'] ) ? $settings['show_to_field'] : 'on';
        $atts['required_to_field']      = isset( $settings['required_to_field'] ) ? $settings['required_to_field'] : 'on';
        $atts['to_field_label']         = isset( $settings['to_field_label'] ) && $settings['to_field_label'] !==""  ? $settings['to_field_label'] : esc_html__('To','wpcafe-pro');
        $atts['form_booking_button']    = isset( $settings['form_booking_button'] ) && $settings['form_booking_button'] !==""  ? $settings['form_booking_button'] : esc_html__('Book a table','wpcafe-pro');
        $atts['form_cancell_button']    = isset( $settings['form_cancell_button'] ) && $settings['form_cancell_button'] !==""  ? $settings['form_cancell_button'] : esc_html__('Request Cancellation','wpcafe-pro');
        
        return $atts;
    }

    /**
     * Submit reservation extra field function
     *
     */
    public function reservations_submit_extra_field(  $pid , $post_arr ){
        $settings = $this->settings_obj;
        $reserv_extra_label     = $settings['reserv_extra_label'];
        if( ( is_array($reserv_extra_label) && count($reserv_extra_label)>0 ) 
         && ( isset( $post_arr['reserv_extra'] ) && is_array( $post_arr['reserv_extra'] ) && count( $post_arr['reserv_extra'] )>0 ) ){
            foreach ( $reserv_extra_label as $key => $value ) {
                if( $value !=="" ):
                    add_post_meta( $pid, 'reserv_extra_'.$key, $post_arr['reserv_extra'][$key] , true );
                endif;
            }
        }
    }

    /**
     * reservation extra field in reservation report function
     */
    public function reservations_report_extra_field( $args  ){
        $settings = $this->settings_obj;
        $reserv_extra_label     = $settings['reserv_extra_label'];
        if( ( is_array( $reserv_extra_label ) && count( $reserv_extra_label )>0 ) ){
            foreach ( $reserv_extra_label as $key => $value ) {
                if( $value !=="" ):
                    $args['reserv_extra_'.$key] = [
                    'label'    => esc_html__( $value, 'wpcafe-pro' ),
                    'type'     => 'text',
                    'priority' => 1,
                    'required' => false,
                    'desc'     => '',
                    'attr'     => ['class' => 'wpc-label-item'] ];
                endif;
            }
        }

        return $args;
    }

    /**
     * reservation extra field html blcok function
     */
    public function reservation_extra_field( $settings ){
        ob_start();
        if( isset($settings['reserv_extra_label']) && is_array($settings['reserv_extra_label']) && count($settings['reserv_extra_label'])>0 ){
            $reserv_extra_label     = $settings['reserv_extra_label'];
            $reserv_extra_place_ho  = $settings['reserv_extra_place_ho'];
            for ($i=0; $i < count($reserv_extra_label); $i++) {
                if( $reserv_extra_label[$i] !=='' ){
                    ?>
                    <div class='wpc-row'>
                            <div class='wpc-col-md-12'>
                                <div class='wpc-reservation-field'>
                                    <label for='reserv_extra_<?php echo intval( $i );?>' class='width_100'><?php esc_html_e( $reserv_extra_label[$i] ) ?> 
                                    <input type='text' name='reserv_extra[]' id='reserv_extra_<?php echo intval( $i );?>' class='wpc-form-control' value='' 
                                    placeholder='<?php esc_html_e( $reserv_extra_place_ho[$i] ) ?>'/>
                                </div>
                            </div>
                        </div>
                    <?php
                } 
                
            }
        }

        return ob_get_clean();
    }

    /**
     * Add delivery / pickup in  Minicart 
     */
    public function handle_mini_cart_buttons_before(){
        $settings = $this->settings_obj;
        $minicart_input_field = "";
        if (isset($settings['wpc_pro_allow_order_for']) && Pro_Utilities::data_validation_check($settings['wpc_pro_allow_order_for'])) {
            $delivery_text = esc_html__("Delivery", "wpcafe-pro");
            $pickup_text = esc_html__("Pickup", "wpcafe-pro");
            if (Pro_Utilities::data_validation_check($settings['wpc_pro_allow_order_for'])) {
                if ($settings['wpc_pro_allow_order_for'] == 'Delivery') {
                    $minicart_input_field .= '<input type="radio" name="wpc_pro_order_time" id="wpc_pro_order_time_delivary" class="wpc-minicart-condition-input" value="Delivery"/> <label for="wpc_pro_order_time_delivary">' . $delivery_text . '</label>';
                } elseif ($settings['wpc_pro_allow_order_for'] == 'Pickup') {
                    $minicart_input_field .= '<input type="radio" name="wpc_pro_order_time" class="wpc-minicart-condition-input" id="wpc_pro_order_time_pickup" value="Pickup"/> <label for="wpc_pro_order_time_pickup">' . $pickup_text . '</label>';
                } elseif ($settings['wpc_pro_allow_order_for'] == 'Both') {
                    $minicart_input_field .= '<input type="radio" name="wpc_pro_order_time" class="wpc-minicart-condition-input" id="wpc_pro_order_time_delivary" value="Delivery"/> <label for="wpc_pro_order_time_delivary">' . $delivery_text . '</label>';
                    $minicart_input_field .= '<input type="radio" name="wpc_pro_order_time" class="wpc-minicart-condition-input" id="wpc_pro_order_time_pickup" value="Pickup"/> <label for="wpc_pro_order_time_pickup">' . $pickup_text . '</label>';
                }
            }
        }
        $minicart_input_field .= '<input type="hidden" name="is_order_time_selected" id="wpc-minicart-condition-value-holder" value=""/>';
        ?>
        <div class="minicart-condition-parent">
            <?php
            echo Wpc_Utilities::wpc_kses($minicart_input_field);
            ?>
        </div>
    <?php
    }

    /**
     * Variation content html
     */
    public function variation_option_content($product, $customize_btn = '', $widget_id = ''){
        // variation price 
        Wpc_Utilities::get_variation_price($product) ?>
        <div class="wpc-menu-footer">
            <div class="wpc-customize-btn">
                <?php
                // show customize button
                if ($product->is_in_stock() == true && $product->get_type() == 'variable') {
                    wp_enqueue_script('wc-add-to-cart-variation');
                ?>
                    <div class="wpc-add-to-cart">
                        <a href="#product_popup<?php echo esc_attr($product->get_id() . $widget_id);  ?>" data-effect="mfp-zoom-in" class="customize_button" data-product_id=<?php echo intval(($product->get_id())) ?>>
                            <i class="wpcafe-customize"></i>
                            <?php
                            if (isset($customize_btn) && $customize_btn != '') {
                                echo esc_html($customize_btn);
                            }
                            ?>
                        </a>
                    </div>
                    <div class="product-popup-content wpc-container mfp-hide" id="product_popup<?php echo esc_attr($product->get_id() . $widget_id); ?>">
                        <div class="variation_popup_content variation_popup_content_<?php echo esc_attr($product->get_id()); ?>"></div>
                    </div>
                <?php
                }
                ?>
            </div>
        </div>
    <?php
    }

    /**
     * Category new field for set priority
     *
     */
    public function location_taxonomy_add_new_meta_field(){
    ?>
        <div class="form-field term-group">
            <label for="location_image"><?php esc_html_e('Image', 'wpcafe-pro'); ?></label>
            <input type="hidden" id="location_image" name="location_image" class="custom_media_url" value="">
            <div id="category-image-wrapper"></div>
            <p>
                <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="<?php _e('Add Image', 'wpcafe-pro'); ?>" />
                <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="<?php _e('Remove Image', 'wpcafe-pro'); ?>" />
            </p>
        </div>
    <?php
    }

    /**
     * Category edit field for set priority
     *
     */
    public function location_taxonomy_edit_meta_field($term){
    ?>
        <tr class="form-field term-group-wrap">
            <th scope="row">
                <label for="location_image"><?php _e('Image', 'wpcafe-pro'); ?></label>
            </th>
            <td>
                <?php $image_id = get_term_meta($term->term_id, 'location_image', true); ?>
                <input type="hidden" id="location_image" name="location_image" value="<?php echo esc_attr( $image_id ); ?>">
                <div id="category-image-wrapper">
                    <?php if ($image_id) { ?>
                        <?php echo wp_get_attachment_image($image_id, 'thumbnail'); ?>
                    <?php } ?>
                </div>
                <p>
                    <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="<?php _e('Add Image', 'wpcafe-pro'); ?>" />
                    <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="<?php _e('Remove Image', 'wpcafe-pro'); ?>" />
                </p>
            </td>
        </tr>
    <?php
    }

    /**
     * save field 
     *
     */
    public function taxonomy_save_meta_field($term_id){
        $category_image_id = filter_input(INPUT_POST, 'location_image');
        if (isset($category_image_id)) {
            update_term_meta($term_id, 'location_image', $category_image_id, false);
        }
    }

    /**
     * Image column added to location taxonomy admin screen.
     *
     */
    public function wpc_custom_fields_list_title($columns){
        $columns['location_image'] = esc_html__('Image', 'woocommerce');
        return $columns;
    }

    /**
     * Location column value added to product category admin screen.
     *
     * @param string $columns
     * @param string $column
     * @param int $id term ID
     */
    public function wpc_custom_fields_list_diplay($columns, $column, $id){
        // Get the image ID for the category
        $image_id = get_term_meta($id, 'location_image', true);
        echo wp_get_attachment_image($image_id);
        return $columns;
    }

    // add body class
    public function wpc_body_classes($classes){
        $settings       = $this->settings_obj;
        if (isset($settings['wpc_pro_woocommerce_override_css']) && $settings['wpc_pro_woocommerce_override_css'] == 'on') {
            $classes[] = 'woocomerce-layout-override-enable';
        }
        return $classes;
    }

    /**
     * Elementor widget search control function
     */
    public function widget_search_control( $args ){
        $data = [];
        $search_control = array(
            'name'      => 'wpc_search_show',
            'parameter' => array(
                'label'         => esc_html__('Show Search', 'wpcafe-pro'),
                'type'          => \Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__('Show', 'wpcafe-pro'),
                'label_off'     => esc_html__('Hide', 'wpcafe-pro'),
                'return_value'  => 'yes',
                'default'       => 'yes',
            )
        );
        $data['search_control'] = $search_control ;
        
        return $data;
    }

    /**
     * Liver search markup for free when pro active
     */
    public function widget_search_data( $settings , $widget_id , $template_name ){
        $wpc_search_show = $settings['wpc_search_show'];
        $wpc_menu_cat=[];$ajax_template = 'list_template';
        if( $template_name == 'wpc-food-menu-tab' ){
            $ajax_template      = 'tab_template';
            $food_menu_tabs     = $settings["food_menu_tabs"];
            $style      	    = $settings["food_tab_menu_style"];
            foreach ($food_menu_tabs as $key => $value) {
                if (isset( $value['post_cats'][0] )) {
                    array_push( $wpc_menu_cat , $value['post_cats'][0]);
                }
            }
        }else {
            $style      	 = $settings["food_menu_style"];
            $wpc_menu_cat    = $settings["wpc_menu_cat"];
            $ajax_template   = 'list_template';
        }
		if ( $wpc_search_show == 'yes' ) {
			// live search 
            $template_path = WPC_DIR . "/widgets/{$template_name}/style/{$style}.php";
            
			$widget_arr=array(
				'show_thumbnail' 		=> $settings['show_thumbnail'],
				'wpc_menu_order' 		=> $settings['wpc_menu_order'],
				'show_item_status' 		=> $settings['show_item_status'],
				'wpc_menu_count' 		=> $settings['wpc_menu_count'],
				'wpc_show_desc'			=> $settings['wpc_show_desc'],
				'wpc_desc_limit'		=> $settings['wpc_desc_limit'],
                'title_link_show'	    => $settings['addtocart_link_show'],
                'wpc_cart_button'       => $settings["wpc_cart_button_show"],
				'widget_id'				=> $widget_id,
            );

			echo Singleton::live_search_markup( $settings['wpc_menu_count'] , $wpc_menu_cat , $settings["wpc_cart_button_show"] , $ajax_template , $template_path , $widget_arr, 'center' );
        }
    }

}
