<?php

namespace WpCafe_Pro\Core\Template;

defined("ABSPATH") || exit;

use WpCafe\Utils\Wpc_Utilities;

class Keyoptions {

    use \WpCafe_Pro\Traits\Singleton;

    /**
     * Call all hooks
     */
    public function init() {

        // add filter to add more menu settings
        add_filter('wpcafe/key_options/menu_settings', [$this, 'pro_menu_settings']);

        // add filter to check validation of settings field
        add_filter('wpcafe/settings/validation', [$this, 'settings_validation']);

        // add filter to add more hook settings
        add_filter('wpcafe/key_options/hook_settings', [$this, 'hook_settings']);

        // add filter to frontend notification settings
        add_filter('wpcafe/action/cancell_notification', [$this, 'admin_reserve_submit_notification'], 10, 3);

        // add filter to add more  settings tab item, content
        add_filter('wpcafe/key_options/settings_tab_item', [$this, 'settings_tab_item']);

        // add shortcode to page
        add_filter('wpcafe/key_options/tab_content', [$this, 'settings_tab_content'], 10, 2);

        //add filter for notification pro feature
        add_filter('wpcafe/metabox/notification', [$this, 'notifications'], 10, 3);
    }

    /**
     * pro  settings optons 
     */
    public function pro_menu_settings($wpc_pro_menu_settings) {
        $all_data=[];
        ob_start();
        $wpc_pro_woocommerce_variation_layout = isset($wpc_pro_menu_settings['wpc_pro_woocommerce_variation_layout']) ? 'checked' : '';
        $wpc_pro_woocommerce_override_css = isset($wpc_pro_menu_settings['wpc_pro_woocommerce_override_css']) ? 'checked' : '';
        ?>
        <div class="wpc-label-item">
             <div class="wpc-label">
                 <label for="wpc_pro_woocommerce_variation_layout"><?php esc_html_e('Product Variation List Layout Override ', "wpcafe-pro" ); ?></label>
                 <div class="wpc-desc"> <?php esc_html_e("You can change override woocomerce product variation layout in popup and single page", "wpcafe-pro" ); ?></div>
             </div>
             <div class="wpc-meta">
                 <input id='wpc_pro_woocommerce_variation_layout' type="checkbox" <?php echo esc_attr($wpc_pro_woocommerce_variation_layout); ?> class="wpcafe-admin-control-input " name="wpc_pro_woocommerce_variation_layout" />
                 <label for="wpc_pro_woocommerce_variation_layout" class="wpcafe_switch_button_label"></label>
             </div>
        </div>
        <div class="wpc-label-item">
             <div class="wpc-label">
                 <label for="wpc_pro_woocommerce_override_css"><?php esc_html_e('Override WooCommerce default layout? ', "wpcafe-pro" ); ?></label>
                 <div class="wpc-desc"> <?php esc_html_e("You can override woocomerce default layout (Product Details,Cart, Checkout and Thank you page)", "wpcafe-pro" ); ?></div>
             </div>
             <div class="wpc-meta">
                 <input id='wpc_pro_woocommerce_override_css' type="checkbox" <?php echo esc_attr($wpc_pro_woocommerce_override_css); ?> class="wpcafe-admin-control-input " name="wpc_pro_woocommerce_override_css" />
                 <label for="wpc_pro_woocommerce_override_css" class="wpcafe_switch_button_label"></label>
             </div>
        </div>

        <h3 class='wpc-tab-title'><?php echo esc_html__("Discount Options", "wpcafe-pro" ); ?></h3>
        <div class='wpc-label-item'>
            <div class='wpc-label'>

                <label for='wpc_pro_discount_in_menu' class='wpc-settings-label'>
                    <?php echo esc_html__('Discount', "wpcafe-pro" ) ?>
                </label>
                <p class='wpc-desc'><?php echo  esc_html__('Set discount on menu', "wpcafe-pro" ) ?></p>
            </div>
            <div class='wpc-meta'>
                <?php
                $wpc_pro_order_amount_percent           = isset($wpc_pro_menu_settings['wpc_pro_discount_percentage']) ? intval($wpc_pro_menu_settings['wpc_pro_discount_percentage']) : '';
                $wpc_pro_order_standarad_off_amount     = isset($wpc_pro_menu_settings['wpc_pro_order_standarad_off_amount']) ? intval($wpc_pro_menu_settings['wpc_pro_order_standarad_off_amount']) : '';
                $wpc_pro_discount_standarad_off         = isset($wpc_pro_menu_settings['wpc_pro_discount_standarad_off']) ? intval($wpc_pro_menu_settings['wpc_pro_discount_standarad_off']) : '';
                $wpc_pro_discount_standarad_off_message = isset($wpc_pro_menu_settings['wpc_pro_discount_standarad_off_message']) ? esc_html($wpc_pro_menu_settings['wpc_pro_discount_standarad_off_message']) : '';
                $wpc_pro_include_cat                    = isset($wpc_pro_menu_settings['wpc_pro_include_cat']) ? $wpc_pro_menu_settings['wpc_pro_include_cat'] : [];
                ?>
                <div class='wpc_pro_discount_heading'>
                    <h5 class='wpc_pb_two'><?php echo esc_html__('Percentage discount', "wpcafe-pro" ) ?></h5>
                    <p class="wpc-desc"><?php echo esc_html__('Percentage discount will be appllied on simple product from include menus and include categories', "wpcafe-pro" ) ?> </p>
                </div>
                <div class='wpc_pro_discount_main_block wpc-mb-30'>
                    <div class='wpc_pro_discount_block'>
                        <span><?php echo esc_html__('Discount:', "wpcafe-pro" ) ?> </span>
                        <span><input type='text' name='wpc_pro_discount_percentage' class='wpc_pro_discount_percentage wpc-settings-input attr-form-control' value="<?php echo intval($wpc_pro_order_amount_percent); ?>" /></span>
                        <span><?php echo esc_html__('percent', "wpcafe-pro" ) ?></span>
                    </div>
                </div>

                <!-- Money off -->
             
                <div class='wpc_pro_discount_main_block'>
                    <h5 class="wpc_pb_two"><?php echo esc_html__('Standard Discount [money off]:', "wpcafe-pro" ) ?></h5>
                    <p class="wpc-desc"><?php echo esc_html__('Standard discount be appllied on total purchase . It will apply on all menu and categories', "wpcafe-pro" ) ?></p>
                    <div class='wpc_pro_discount_block'>
                        <span><?php echo esc_html__('If order total >=:', "wpcafe-pro" ) ?></span>
                        <span><input type='text' name='wpc_pro_order_standarad_off_amount' class='wpc_pro_order_standarad_off_amount wpc-settings-input attr-form-control' value="<?php echo intval($wpc_pro_order_standarad_off_amount); ?>" /></span>
                        <span><?php echo esc_html__('get:', "wpcafe-pro" ) ?></span>
                        <span><input type='text' name='wpc_pro_discount_standarad_off' class='wpc_pro_discount_standarad_off wpc-settings-input attr-form-control' value="<?php echo intval($wpc_pro_discount_standarad_off); ?>" /></span>
                        <span><?php echo esc_html__('off', "wpcafe-pro" ) ?></span>
                    </div>
                    <div>
                        <label><?php echo esc_html('Standarad money off message', "wpcafe-pro" ) ?></label>
                        <input type='text' name='wpc_pro_discount_standarad_off_message' class="wpc-settings-input" value="<?php echo esc_html($wpc_pro_discount_standarad_off_message); ?>" />
                    </div>
                </div>
            </div>
        </div>
        <?php
        if (class_exists('Woocommerce')) {
            ?>
            <div class='wpc-label-item'>
                <div class='wpc-label'>
                    <label for='wpc_pro_include_menu' class='wpc-settings-label'>
                        <?php echo esc_html__('Include menus', "wpcafe-pro" ) ?>
                    </label>
                    <p class='wpc-desc'><?php echo  esc_html__('Include following menu items when calculating discounts:', "wpcafe-pro" ) ?></p>
                </div>
                <div class="wpc-meta">
                    <?php
                    $menu_id  = isset($wpc_pro_menu_settings['wpc_pro_include_menu']) ? $wpc_pro_menu_settings['wpc_pro_include_menu'] : [];
                    $args = array(
                        'post_type'   => 'product',
                        'hide_empty'  => 0,
                    );
                    $products = wc_get_products($args);
                    ?>
                    <select multiple="multiple" class="wpc_pro_multi_product wpc-settings-input" id="wpc_pro_include_menu" name="wpc_pro_include_menu[]">
                        <?php
                        if (is_array($products)) {
                            foreach ($products as $product) {
                                if ($product->is_type('simple')) {
                                    $selected = in_array($product->get_id(), $menu_id) ? "selected " : '';
                                    ?>
                                    <option <?php echo esc_html($selected); ?> value='<?php echo intval($product->get_id()); ?>'><?php echo esc_html($product->get_name());  ?></option>
                                    <?php
                                }
                            }
                        }
                        ?>
                    </select>
                </div>
            </div>
            <?php
        }
        ?>
        <div class='wpc-label-item'>
            <div class='wpc-label'>
                <label for='wpc_pro_include_cat' class='wpc-settings-label'>
                    <?php echo esc_html__('Include categories', "wpcafe-pro" ) ?>
                </label>
                <p class='wpc-desc'><?php echo  esc_html__('Include all menu items belonging to following categories when calculating discounts:', "wpcafe-pro" ) ?></p>
            </div>
            <div class="wpc-meta">
                <?php
                $args = array(
                    'hide_empty'  => 0,
                    'taxonomy'    => 'product_cat',
                    'hierarchical' => 1,
                );
                $categories = get_categories($args);
                ?>
                <select multiple="multiple" class="wpc_pro_multi_cat wpc-settings-input" id="wpc_pro_include_cat" name="wpc_pro_include_cat[]">
                    <?php
                    if (is_array($categories)) {
                        foreach ($categories as $key => $category) {
                            $selected = in_array($category->term_id, $wpc_pro_include_cat) ? "selected" : '';
                            ?>
                            <option <?php echo esc_html($selected); ?> value="<?php echo esc_attr($category->term_id); ?>"><?php echo esc_html($category->cat_name); ?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
        </div>
        <?php
        $all_data['menu_settings'] = ob_get_clean();
        $all_data['reservation_form_settings']  = $this->reservation_form_settings( $wpc_pro_menu_settings );
        $all_data['notification_settings']      = $this->notification_settings( $wpc_pro_menu_settings );
        $all_data['key_options']                = $this->key_options_settings( $wpc_pro_menu_settings );
        $all_data['reservation_schedule']       = $this->schedule_settings( $wpc_pro_menu_settings );

        return $all_data;
    }

    /**
     * Multi slot schedule settings
     */
    public function schedule_settings( $settings ){
        ob_start();
        $reser_multi_schedule  =  isset($settings['reser_multi_schedule'] ) && $settings['reser_multi_schedule'] == 'on'  ? 'checked' : '';
        ?>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="reser_multi_schedule"><?php esc_html_e('Reservation multi-slot schedule', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Select single slot or multi slot shcedule in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input id='reser_multi_schedule' type="checkbox" <?php echo esc_attr( $reser_multi_schedule ); ?> class="wpcafe-admin-control-input"
                name="reser_multi_schedule"/>
                <label for="reser_multi_schedule" class="wpcafe_switch_button_label"></label>
            </div>
        </div>
        <div class="wpc-label-item multi_schedule_block <?php  echo ( $reser_multi_schedule !== 'checked' ) ? esc_html('hide_field') : '' ?>">
            <div class="wpc-label">
                <label for="schedule_slot"><?php esc_html_e('Schedule slot', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('All schedule slots will be applied in each days except exceptional days.
                 If you change single slot/ multi slot . You need to change Maximum party size from "Key options" ', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <div class="multi_schedule">
                    <h5 class="wpc_pb_two"><?php esc_html_e('Reservation multi-slot schedule for each days', 'wpcafe-pro' ); ?></h5>
                    <?php
                    $schedule_name          =  isset($settings['schedule_name'] ) ? $settings['schedule_name'] : [];
                    $multi_start_time       = isset($settings['multi_start_time']) ? $settings['multi_start_time'] : [];
                    $multi_end_time         = isset($settings['multi_end_time']) ? $settings['multi_end_time'] : [];
                    $seat_capacity          = isset($settings['seat_capacity']) ? $settings['seat_capacity'] : [];

                    if (is_array( $multi_start_time ) && count($multi_start_time) > 0 ) {
                        for ($index = 0; $index < count($multi_start_time); $index++) {
                            ?>
                                <div class="wpc-schedule-field multi_schedule_wrap mb-2">
                                    <input type="text" name="multi_start_time[]" value="<?php echo esc_html($multi_start_time[$index]); ?>" id="<?php echo intval($index); ?>" class="multi_start_time  multi_start_time_<?php echo intval($index) ?> ml-2 mr-1 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("Start time", "wpcafe-pro");?>" />
                                    <input type="text" name="multi_end_time[]" value="<?php echo esc_html($multi_end_time[$index]); ?>" id="<?php echo intval($index); ?>"  class="multi_end_time  multi_end_time_<?php echo intval($index) ?> ml-2 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("End time", "wpcafe-pro");?>" />
                                    <input type="text" name="schedule_name[]" value="<?php echo esc_html($schedule_name[$index]); ?>" class="schedule_name_<?php echo intval($index) ?> ml-2 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("Schedule name", "wpcafe-pro");?>" />
                                    <input type="text" name="seat_capacity[]" value="<?php echo esc_html($seat_capacity[$index]); ?>" class="seat_capacity_<?php echo intval($index) ?> ml-2 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("Seat capacity", "wpcafe-pro");?>" />
                                    <div class="wpc_multi_clear" id="<?php echo intval($index) ?>"><?php esc_html_e('clear','wpcafe-pro'  )?></div>
                                    <?php if ($index != 0) { ?>
                                    <span class="dashicons wpc-btn dashicons dashicons-no-alt remove_reserve_multi_field pl-1"></span>
                                <?php } ?>
                                </div>
                            <?php
                        }
                    } else { ?>
                        <div class="wpc-schedule-field multi_schedule_wrap mb-2">
                            <input type="text" name="multi_start_time[]" id="0" class="multi_start_time  multi_start_time_0 ?> ml-2 mr-1 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("Start time", "wpcafe-pro");?>" />
                            <input type="text" name="multi_end_time[]" id="0" class="multi_end_time  multi_end_time_0 ?> ml-2 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("End time", "wpcafe-pro");?>" />
                            <input type="text" name="schedule_name[]" class="schedule_name_0 ?> ml-2 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("Schedule name", "wpcafe-pro");?>" />
                            <input type="text" name="seat_capacity[]" class="seat_capacity_0 ?> ml-2 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("Seat capacity", "wpcafe-pro");?>" />
                            <div class="wpc_multi_clear" id="0"><?php esc_html_e('clear','wpcafe-pro'  )?></div>
                        </div>
                <?php }  ?>
                </div>
                <!-- Add button  -->
                <div class="wpc_flex_reverse multi_block_add_section">
                    <span class="add_multi_schedule wpc-btn" data-start_time="<?php echo esc_html__('Start time', 'wpcafe-pro' ); ?>"="<?php echo esc_html__("Start time", "wpcafe-pro" ); ?>"
                     data-end_time="<?php echo esc_html__("End time", "wpcafe-pro" ); ?>"
                     data-schedule_name="<?php echo esc_html__("Schedule name", "wpcafe-pro" ); ?>"
                     data-seat_capactiy="<?php echo esc_html__("Seat capacity", "wpcafe-pro" ); ?>"
                    >
                     <i class="dashicons icon_cursor text-right dashicons-plus-alt  pl-1"></i>
                    </span>
                </div>
            </div>
        </div>
        <div class="wpc-label-item single_schedule <?php  echo ( $reser_multi_schedule === 'checked' ) ? esc_attr('hide_field') : '' ?>">
             <div class="wpc-label">
                 <label for="rest_max_reservation"><?php esc_html_e("Seat capacity", "wpcafe-pro" ); ?></label>
                 <div class="wpc-desc"> <?php esc_html_e("Total seat capacity of a restaurant", "wpcafe-pro" ); ?></div>
             </div>
             <div class="wpc-meta">
                <select id="rest_max_reservation" class="wpc-settings-input" name="rest_max_reservation">
                    <option value=""><?php echo esc_html__("Select no. of guests",  'wpcafe-pro'  )?></option>
                    <?php
                    $wpc_no_range = 101;
                    $min_geust_no = isset( $settings['rest_max_reservation'] ) && $settings['rest_max_reservation'] !== '' ? $settings['rest_max_reservation'] : 20;
                    for( $i = 1 ; $i <= $wpc_no_range ; $i++ ) { ?>
                        <option <?php selected( $min_geust_no , $i , true ); ?> value='<?php echo esc_attr($i); ?>'> <?php echo esc_html( $i ); ?> </option>
                    <?php }
                    ?>
                </select>
             </div>
        </div>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Send data to notification tab function
     */
    public function notification_settings( $settings ){
        $notify = array();
        $admin_notif_confirm_book          = ( !isset($settings['wpc_admin_notification_for_confirm_req']) || ( isset($settings['wpc_admin_notification_for_confirm_req']) && $settings['wpc_admin_notification_for_confirm_req'] =="on" ) ? 'on' : 'off');
        $user_notif_confirm_book           = ( !isset($settings['wpc_user_notification_for_confirm_req']) || ( isset($settings['wpc_user_notification_for_confirm_req']) && $settings['wpc_user_notification_for_confirm_req'] =="on" ) ? 'on' : 'off');
        $admin_notif_cancel_req            = ( !isset($settings['wpc_admin_cancel_notification']) || ( isset($settings['wpc_admin_cancel_notification']) && $settings['wpc_admin_cancel_notification'] =="on" ) ? 'on' : 'off');
        $user_notif_cancel_req             = ( !isset($settings['wpc_user_notification_for_cancel_req']) || ( isset($settings['wpc_user_notification_for_cancel_req']) && $settings['wpc_user_notification_for_cancel_req'] =="on" ) ? 'on' : 'off');
        $notify['admin_notif_confirm_book'] = $admin_notif_confirm_book;
        $notify['user_notif_confirm_book']  = $user_notif_confirm_book;
        $notify['admin_notif_cancel_req']   = $admin_notif_cancel_req;
        $notify['user_notif_cancel_req']    = $user_notif_cancel_req;

        return $notify;
    }

    /**
     * Reservation form settings
     */
     public function reservation_form_settings( $settings ){
         ob_start();

         $show_form_field       =  (! isset($settings['show_form_field'] ) || isset($settings['show_form_field'] ) && $settings['show_form_field'] == 'on' ) ? 'checked' : '';
         $required_from_field   =  (! isset($settings['required_from_field'] ) || isset($settings['required_from_field'] ) && $settings['required_from_field'] == 'on' ) ? 'checked' : '';
         $from_field_label      =  isset($settings['from_field_label'])   ? $settings['from_field_label'] : '';
         $form_booking_button   =  isset($settings['form_booking_button'])   ? $settings['form_booking_button'] : esc_html__('Book a table','wpcafe-pro');
         $form_cancell_button   =  isset($settings['form_cancell_button'])   ? $settings['form_cancell_button'] : esc_html__('Request Cancellation','wpcafe-pro');
         $show_to_field         =  (! isset($settings['show_to_field'] ) || isset($settings['show_to_field'] ) && $settings['show_to_field'] == 'on' ) ? 'checked' : '';
         $required_to_field     =  (! isset($settings['required_to_field'] ) || isset($settings['required_to_field'] ) && $settings['required_to_field'] == 'on' ) ? 'checked' : '';
         $to_field_label        =  isset($settings['to_field_label'])   ? $settings['to_field_label'] : '';

         ?>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="form_booking_button"><?php esc_html_e('Reservation booking button text', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Show reservation booking button text in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input type="text" value="<?php echo esc_html( $form_booking_button ); ?>" class="wpc-settings-input"
                name="form_booking_button" placeholder="<?php echo esc_html__( "Book a table","wpcafe-pro" ); ?>" />
            </div>
        </div> 
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="form_cancell_button"><?php esc_html_e('Reservation cancellation button text', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Show reservation cancellation button text in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input type="text" value="<?php echo esc_html( $form_cancell_button ); ?>" class="wpc-settings-input"
                name="form_cancell_button" placeholder="<?php echo esc_html__( "Request Cancellation","wpcafe-pro" ); ?>" />
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="show_form_field"><?php esc_html_e('Show From time field', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Show/hide Form time field in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input name="show_form_field" class="hide_field" type="checkbox" value="off"/>
                <input id='show_form_field' type="checkbox" <?php echo esc_attr( $show_form_field ); ?> class="wpcafe-admin-control-input"
                name="show_form_field"/>
                <label for="show_form_field" class="wpcafe_switch_button_label"></label>
            </div>
        </div> 
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="required_from_field"><?php esc_html_e('Required From time field', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Required/Optional Form time field in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input name="required_from_field" class="hide_field" type="checkbox" value="off"/>
                <input id='required_from_field' type="checkbox" <?php echo esc_attr( $required_from_field ); ?> class="wpcafe-admin-control-input"
                name="required_from_field"/>
                <label for="required_from_field" class="wpcafe_switch_button_label"></label>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="from_field_label"><?php esc_html_e('From time field label text', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Show From time field label text in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input type="text" value="<?php echo esc_html( $from_field_label ); ?>" class="wpc-settings-input"
                name="from_field_label" placeholder="<?php echo esc_html__( "From","wpcafe-pro" ); ?>" />
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="show_to_field"><?php esc_html_e('Show To time field', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Show/hide To field in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input name="show_to_field" class="hide_field" type="checkbox" value="off"/>
                <input id='show_to_field' type="checkbox" <?php echo esc_attr( $show_to_field ); ?> class="wpcafe-admin-control-input"
                name="show_to_field"/>
                <label for="show_to_field" class="wpcafe_switch_button_label"></label>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="required_to_field"><?php esc_html_e('Required To time field', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Required/Optional To time field in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input name="required_to_field" class="hide_field" type="checkbox" value="off"/>
                <input id='required_to_field' type="checkbox" <?php echo esc_attr( $required_to_field ); ?> class="wpcafe-admin-control-input"
                name="required_to_field"/>
                <label for="required_to_field" class="wpcafe_switch_button_label"></label>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="to_field_label"><?php esc_html_e('To time field label text', 'wpcafe-pro'  ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e('Show To time field label text in reservation form', 'wpcafe-pro'); ?> </div>
            </div>
            <div class="wpc-meta">
                <input type="text" value="<?php echo esc_html( $to_field_label ); ?>" class="wpc-settings-input"
                name="to_field_label" placeholder="<?php echo esc_html__( "To","wpcafe-pro" ); ?>"/>
            </div>
        </div>
        <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="reserv_extra_field" class="wpc-settings-label"><?php esc_html_e('Extra field', "wpcafe-pro" ); ?></label>
                    <p class="wpc-desc"> <?php esc_html_e("Extra field will be added in reservation form", "wpcafe-pro" ); ?> </p>
                </div>
                <div class="wpc-meta">
                    <div class="reserv_extra_main_block">
                        <?php
                        $reserv_extra_label       = isset($settings['reserv_extra_label']) ? $settings['reserv_extra_label'] : [];
                        $reserv_extra_place_ho    = isset($settings['reserv_extra_place_ho']) ? $settings['reserv_extra_place_ho'] : [];
                        if ( is_array($reserv_extra_label) && count($reserv_extra_label) > 0 && $reserv_extra_label['0'] !== '') {
                            for ($index = 0; $index < count( $reserv_extra_label ); $index++) {
                                ?>
                                <div class="wpc-schedule-field schedule_block mb-2">
                                    <input type="text" name="reserv_extra_label[]" value="<?php echo Wpc_Utilities::wpc_render($reserv_extra_label[$index]); ?>" class="reserv_extra_label mr-1 wpc-settings-input attr-form-control" id="reserv_extra_label_<?php echo intval($index) ?>" placeholder="<?php esc_html_e('Label text','wpcafe-pro');?>" />
                                    <input type="text" name="reserv_extra_place_ho[]" value="<?php echo Wpc_Utilities::wpc_render($reserv_extra_place_ho[$index]); ?>" class="reserv_extra_place_ho mr-1 wpc-settings-input attr-form-control" id="reserv_extra_place_ho_<?php echo intval($index) ?>" placeholder="<?php esc_html_e('Placeholder text','wpcafe-pro');?>" />
                                    <?php if( $index != 0 ) { ?>
                                        <span class="dashicons wpc-btn dashicons dashicons-no-alt remove_reserve_extra_field pl-1"></span>
                                    <?php } ?>
                                </div>
                            <?php
                            }
                        } else {
                            ?>
                            <div class="wpc-schedule-field schedule_block  mb-2">
                                <input type="text" name="reserv_extra_label[]" value="" class="reserv_extra_label mr-1 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e('Label text','wpcafe-pro');?>" />
                                <input type="text" name="reserv_extra_place_ho[]" value="" class="reserv_extra_place_ho mr-1 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e('Placeholder text','wpcafe-pro');?>" />
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="wpc_flex_reverse reserv_extra_section">
                        <span class="add_reserve_extra_block wpc-btn" 
                        data-label_text="<?php echo esc_html__("Label text", "wpcafe-pro");?>"
                        data-placeholder_text="<?php echo esc_html__("Placeholder text", "wpcafe-pro");?>"
                        >
                            <i class="dashicons icon_cursor text-right dashicons-plus-alt  pl-1"></i>
                        </span>
                    </div>
                </div>
            </div>
         <?php
         return ob_get_clean();
     }

    /**
     * key options settings
     *
     */
    public function key_options_settings( $settings ){
        ob_start();
        ?>
        <div class="wpc-label-item">
             <div class="wpc-label">
                 <label for="rest_reservation_off"><?php esc_html_e("Reservation close state", "wpcafe-pro" ); ?></label>
                 <div class="wpc-desc"> <?php esc_html_e("Reservation request can be closed either maximum confirmed booking or maximum pending booking request", "wpcafe-pro" ); ?></div>
             </div>
             <div class="wpc-meta">
                <?php
                $args = array('confirmed'=>esc_html__('Total confirmed','wpcafe-pro'),
                 'pending'=>esc_html__('Total pending','wpcafe-pro') );

                if (! isset( $settings['rest_reservation_off']) ) {
                    $rest_reservation_off = 'confirmed';
                }
                else{
                    $rest_reservation_off = $settings['rest_reservation_off'] =='' ? 'confirmed': $settings['rest_reservation_off'];
                }
                ?>
                <select class="wpc-settings-input" id="rest_reservation_off" name="rest_reservation_off">
                    <?php
                    foreach ($args as $key => $value) {
                        $selected = $rest_reservation_off == $key ? "selected" : '';
                    ?>
                        <option <?php echo esc_html($selected); ?> value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
                    <?php
                    }
                    ?>
                </select>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    /**
     * Add hook settings
     */
    public function hook_settings() {
        ?>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="wpc_reservation_form_pro"><?php esc_html_e('Reservation Form (Pro)', "wpcafe-pro" ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("Use this [wpc_reservation_form wpc_image_url='' calender_view = 'yes'] shortcode anywhere you want to show the reservation form", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input class="wpc-settings-input" id="wpc_reservation_form_pro" type="text" name="wpc_reservation_form" value="[wpc_reservation_form wpc_image_url='' calender_view = 'yes']" readonly />
                <button type="button" onclick="copyTextData('wpc_reservation_form_pro');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="wpc_pro_business_hour"><?php esc_html_e('Show business hour (Pro)', 'wpcafe-pro'); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_pro_business_hour all_days_schedule='no'] ", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input type="text" id="wpc_pro_business_hour" class="wpc-settings-input" value="[wpc_pro_business_hour all_days_schedule='no']" readonly />
                <button type="button" onclick="copyTextData('wpc_pro_business_hour');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>

        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="wpc_pro_menu_category_list"><?php esc_html_e('Category List Layout (Pro)', 'wpcafe-pro'); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_pro_menu_category_list style='style1' wpc_food_categories='15,16' category_limit='20' grid_column='4'] ", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input type="text" id="wpc_pro_menu_category_list" class="wpc-settings-input" value="[wpc_pro_menu_category_list style='style1' wpc_food_categories='15,16' category_limit='20' grid_column='4']" readonly />
                <button type="button" onclick="copyTextData('wpc_pro_menu_category_list');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>

        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="wpc_pro_menu_location_list"><?php esc_html_e('Location List Layout (Pro)', 'wpcafe-pro'); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_pro_menu_location_list style='style1' location_ids='15,16,17' location_limit='30', show_count='no' grid_column='4'] ", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input type="text" id="wpc_pro_menu_location_list" class="wpc-settings-input" value="[wpc_pro_menu_location_list style='style1' location_ids='' location_limit='30', show_count='no' grid_column='4']" readonly />
                <button type="button" onclick="copyTextData('wpc_pro_menu_location_list');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="food_menu_pro_shortcode_tab"><?php esc_html_e('Show Food Menu tab (Pro)', "wpcafe-pro" ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_pro_food_menu_tab style='style-3' wpc_food_categories='16,17,18' no_of_product='6' show_thumbnail ='yes' wpc_cart_button ='yes'  live_search ='yes']", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input type="text" id="food_menu_pro_shortcode_tab" class="wpc-settings-input" value="[wpc_pro_food_menu_tab style='style-3' wpc_food_categories='16,17,18' no_of_product='6' show_thumbnail ='yes' wpc_cart_button ='yes'  live_search ='yes']" readonly />
                <button type="button" onclick="copyTextData('food_menu_pro_shortcode_tab');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="food_menu_pro_shortcode_list"><?php esc_html_e('Show Food Menu list (Pro)', "wpcafe-pro" ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_pro_food_menu_list style='style-1' wpc_food_categories='16,21,18,17,20'  wpc_desc_limit='20' no_of_product='2' show_thumbnail ='yes' wpc_cart_button ='yes' live_search ='yes' ]", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input type="text" id="food_menu_pro_shortcode_list" class="wpc-settings-input" value="[wpc_pro_food_menu_list style='style-1' wpc_food_categories='16,21,18,17,20'  wpc_desc_limit='20' no_of_product='2' show_thumbnail ='yes' wpc_cart_button ='yes' live_search ='yes' ]" readonly />
                <button type="button" onclick="copyTextData('food_menu_pro_shortcode_list');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="wpc_pro_menu_slider"><?php esc_html_e('Show Food Menu Slider (Pro)', 'wpcafe-pro' ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_pro_menu_slider  style='style-1' wpc_menu_count='20' wpc_slider_count='3' wpc_food_categories='16,17,18,19,20']", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input type="text" id="wpc_pro_menu_slider" class="wpc-settings-input" value="[wpc_pro_menu_slider  style='style-1' wpc_menu_count='20' wpc_slider_count='3' wpc_food_categories='16,17,18,19,20']" readonly />
                <button type="button" onclick="copyTextData('wpc_pro_menu_slider');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="wpc_pro_menu_tab_with_slider"><?php esc_html_e('Show Menu Tab With Slider (Pro)', 'wpcafe-pro' ); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_pro_menu_tab_with_slider style='style-1' wpc_slider_count='3' wpc_food_categories='16,17,18,19,20' wpc_slider_nav_show='yes']", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input type="text" id="wpc_pro_menu_tab_with_slider" class="wpc-settings-input" value="[wpc_pro_menu_tab_with_slider style='style-1' wpc_slider_count='3' wpc_food_categories='16,17,18,19,20' wpc_slider_nav_show='yes']" readonly />
                <button type="button" onclick="copyTextData('wpc_pro_menu_tab_with_slider');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>
        <div class="wpc-label-item">
            <div class="wpc-label">
                <label for="wpc_pro_food_menu_loadmore"><?php esc_html_e('Show Menu Menu Loadmore (Pro)', 'wpcafe-pro'); ?></label>
                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_pro_food_menu_loadmore style='style-1 wpc_food_categories='16,17,18,19,20'  wpc_menu_count='2' wpc_cart_button='yes' ]", "wpcafe-pro"); ?></div>
            </div>
            <div class="wpc-meta">
                <input type="text" id="wpc_pro_food_menu_loadmore" class="wpc-settings-input" value="[wpc_pro_food_menu_loadmore style='style-1' wpc_food_categories='16,17,18,19,20'  wpc_menu_count='2' wpc_cart_button='yes' ]" readonly />
                <button type="button" onclick="copyTextData('wpc_pro_food_menu_loadmore');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
            </div>
        </div>
        <?php
    }

    /**
     * Tab content function
     */
    public function settings_tab_item($wpc_pro_tab_item) {
        $all_data=[]; 
        // Settings tab
        $result = [];
        if (is_array($wpc_pro_tab_item)) {
            // tab hook
            $wpc_pro_tab_hook = $wpc_pro_tab_item[0];
            $wpc_pro_tab_doc  = $wpc_pro_tab_item[1];
            $key = 'hooks';
            $offset = array_search($key, array_keys($wpc_pro_tab_hook));
            $result[0] = array_merge(
                array_slice($wpc_pro_tab_hook, 0, $offset),
                ['wpc_pro_order_time' => [esc_html__('Order time settings','wpcafe-pro'), esc_html__('( For food menu )','wpcafe-pro')]],
                array_slice($wpc_pro_tab_hook, $offset, null)
            );
            $pointer = array_search($key, array_keys($wpc_pro_tab_doc));
            $result[1] = array_merge(
                array_slice($wpc_pro_tab_doc, 0, $pointer),
                ['wpc_pro_order_time' => ''],
                array_slice($wpc_pro_tab_doc, $pointer, null)
            );
        }
        $all_data['settings_tab'] = $result;

        return $all_data;
    }

    /**
     * Tab content function
     */
    public function settings_tab_content($wpc_pro_menu_settings, $wpc_doc_link) {
        $week_days = ['Sat','Sun','Mon','Tue','Wed','Thu','Fri'];
        $wpc_pro_allow_order_for           = isset($wpc_pro_menu_settings['wpc_pro_allow_order_for']) ? $wpc_pro_menu_settings['wpc_pro_allow_order_for'] : '';
        $wpc_pro_allow_delivery_type_label = isset($wpc_pro_menu_settings['wpc_pro_allow_delivery_type_label']) ? 'checked' : '';
        $wpc_pro_pickup_message            = isset($wpc_pro_menu_settings['wpc_pro_pickup_message']) ? $wpc_pro_menu_settings['wpc_pro_pickup_message'] : '';
        $wpc_pro_delivery_message          = isset($wpc_pro_menu_settings['wpc_pro_delivery_message']) ? $wpc_pro_menu_settings['wpc_pro_delivery_message'] : '';
        $wpc_pro_allow_delivery_time       = isset($wpc_pro_menu_settings['wpc_pro_allow_delivery_time']) ? 'checked' : '';
        $wpc_pro_allow_pickup_time         = isset($wpc_pro_menu_settings['wpc_pro_allow_pickup_time']) ? 'checked' : '';
        $business_hour_label               = isset($wpc_pro_menu_settings['business_hour_label']) ? $wpc_pro_menu_settings['business_hour_label'] : '';
        ?>
        <div id="wpc_pro_order_time" data-id="tab_wpc_pro_order_time" class="tab-pane">
            <div class="mb-2">
                <?php echo esc_html__('visit', "wpcafe-pro" ); ?>
                <a href="<?php echo esc_url('https://support.themewinter.com/docs/plugins/docs/general-settings-2/'); ?>" target="_blank" class="doc-link"><?php echo esc_html__('Documentation', "wpcafe-pro" ); ?></a>
                <?php echo esc_html__('order time management section to maintain selling time of your restaurant.', "wpcafe-pro" ); ?>
            </div>
            <h3 class="wpc-tab-title"><?php esc_html_e('General settings', "wpcafe-pro" ); ?></h3>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="business_hour_label"><?php esc_html_e('Business hour label', "wpcafe-pro" ); ?></label>
                    <div class="wpc-desc"> <?php esc_html_e("Show business hour title.You can leave empty", "wpcafe-pro" ); ?></div>
                </div>
                <div class="wpc-meta">
                    <textarea name="business_hour_label" class="wpc-settings-input wpc-msg-box"><?php echo esc_attr($business_hour_label) ?></textarea>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pro_allow_order_for"><?php esc_html_e('Allow order for', "wpcafe-pro" ); ?></label>
                    <div class="wpc-desc"> <?php esc_html_e("You can have only delivery, only pickup or you can give option to select either of them", "wpcafe-pro" ); ?></div>
                </div>
                <div class="wpc-meta">
                    <?php
                    $args = array( 'Both'=>esc_html__('Both','wpcafe-pro') , 'Delivery'=>esc_html__('Delivery','wpcafe-pro'), 'Pickup'=>esc_html__('Pickup','wpcafe-pro'));
                    ?>
                    <select class="wpc-settings-input" id="wpc_pro_allow_order_for" name="wpc_pro_allow_order_for">
                        <?php
                        foreach ($args as $key => $value) {
                            $selected = $wpc_pro_allow_order_for == $key ? "selected" : '';
                        ?>
                            <option <?php echo esc_html($selected); ?> value="<?php echo esc_attr($value); ?>"><?php echo esc_html($value); ?></option>
                        <?php
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pro_allow_delivery_type_label"><?php esc_html_e('Show "Delivery type" label', "wpcafe-pro" ); ?></label>
                    <div class="wpc-desc"> <?php esc_html_e("you can show or hide label from checkout page", "wpcafe-pro" ); ?></div>
                </div>
                <div class="wpc-meta">
                    <input id='wpc_pro_allow_delivery_type_label' type="checkbox" <?php echo esc_attr($wpc_pro_allow_delivery_type_label); ?> class="wpcafe-admin-control-input " name="wpc_pro_allow_delivery_type_label" />
                    <label for="wpc_pro_allow_delivery_type_label" class="wpcafe_switch_button_label"></label>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pro_pickup_message"><?php esc_html_e('Pickup message', "wpcafe-pro" ); ?></label>
                    <div class="wpc-desc"> <?php esc_html_e("Show  message when pickup selected. Leave blank if no message", "wpcafe-pro" ); ?></div>
                </div>
                <div class="wpc-meta">
                    <textarea id="wpc_pro_pickup_message" class="wpc-settings-input wpc-msg-box" name="wpc_pro_pickup_message" rows="7" cols="30">
                <?php echo esc_attr($wpc_pro_pickup_message); ?>
                </textarea>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pro_delivery_message"><?php esc_html_e('Delivery message', "wpcafe-pro" ); ?></label>
                    <div class="wpc-desc"> <?php esc_html_e("Show  message when delivery selected. Leave blank if no message", "wpcafe-pro" ); ?></div>
                </div>
                <div class="wpc-meta">
                    <textarea id="wpc_pro_delivery_message" class="wpc-settings-input wpc-msg-box" name="wpc_pro_delivery_message" rows="7" cols="30">
                <?php echo esc_attr($wpc_pro_delivery_message); ?></textarea>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pro_allow_delivery_time"><?php esc_html_e('Allow delivery time', "wpcafe-pro" ); ?></label>
                    <div class="wpc-desc"> <?php esc_html_e("You can enable delivery time option", "wpcafe-pro" ); ?></div>
                </div>
                <div class="wpc-meta">
                    <input id='wpc_pro_allow_delivery_time' type="checkbox" <?php echo esc_attr($wpc_pro_allow_delivery_time); ?> class="wpcafe-admin-control-input " name="wpc_pro_allow_delivery_time" />
                    <label for="wpc_pro_allow_delivery_time" class="wpcafe_switch_button_label"></label>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pro_allow_pickup_time"><?php esc_html_e('Allow pickup time', "wpcafe-pro" ); ?></label>
                    <div class="wpc-desc"> <?php esc_html_e("You can enable pickup time option", "wpcafe-pro" ); ?></div>
                </div>
                <div class="wpc-meta">
                    <input id='wpc_pro_allow_pickup_time' type="checkbox" <?php echo esc_attr($wpc_pro_allow_pickup_time); ?> class="wpcafe-admin-control-input " name="wpc_pro_allow_pickup_time" />
                    <label for="wpc_pro_allow_pickup_time" class="wpcafe_switch_button_label"></label>
                </div>
            </div>
            <h3 class="wpc-tab-title"><?php esc_html_e('Time settings', "wpcafe-pro" ); ?></h3>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pickup_weekly_schedule" class="wpc-settings-label"><?php esc_html_e('Pickup weekly schedule', "wpcafe-pro" ); ?></label>
                    <p class="wpc-desc"> <?php esc_html_e("Set pickup weekly schedule", "wpcafe-pro" ); ?> </p>
                </div>
                <div class="wpc-meta">
                    <div class="pickup_schedule_main_block">
                        <h5 class="wpc_pb_two"><?php esc_html_e('Pickup weekly (set opening and closing schedule for each day of a week seperately)', "wpcafe-pro" ); ?></h5>
                        <?php
                        $wpc_schedule['wpc_pickup_weekly_schedule'] = isset($wpc_pro_menu_settings['wpc_pickup_weekly_schedule']) ? $wpc_pro_menu_settings['wpc_pickup_weekly_schedule'] : [];
                        $wpc_schedule['wpc_pickup_weekly_schedule_start_time'] = isset($wpc_pro_menu_settings['wpc_pickup_weekly_schedule_start_time']) ? $wpc_pro_menu_settings['wpc_pickup_weekly_schedule_start_time'] : [];
                        $wpc_schedule['wpc_pickup_weekly_schedule_end_time']   = isset($wpc_pro_menu_settings['wpc_pickup_weekly_schedule_end_time']) ? $wpc_pro_menu_settings['wpc_pickup_weekly_schedule_end_time'] : [];
                        if (is_array( $wpc_schedule['wpc_pickup_weekly_schedule'] ) && count($wpc_schedule['wpc_pickup_weekly_schedule']) > 0) {
                            for ($index = 0; $index < count($wpc_schedule['wpc_pickup_weekly_schedule']); $index++) {
                                ?>
                                <div class="pickup_schedule_block pickup_weekly_block">
                                    <div class="wpc-weekly-schedule-list">
                                    <?php foreach ($week_days as $key => $value) { ?>
                                        <input type="checkbox" name="wpc_pickup_weekly_schedule[<?php echo intval($index) ?>][<?php echo esc_html($value);?>]" 
                                        class="<?php echo esc_html(strtolower($value));?>" id="weekly_pickup_<?php echo esc_html(strtolower($value)).$index;?>"
                                        <?php echo isset( $wpc_schedule['wpc_pickup_weekly_schedule'][$index][$value] ) ? 'checked' : ''?> /><label for="weekly_pickup_<?php echo esc_html(strtolower($value)).$index;?>"><?php echo esc_html__($value, "wpcafe-pro" ); ?></label>
                                    <?php  } ?>
                                    </div>
                                    <div class="wpc-schedule-field">
                                        <input type="text" name="wpc_pickup_weekly_schedule_start_time[]" value="<?php echo esc_html($wpc_schedule['wpc_pickup_weekly_schedule_start_time'][$index]); ?>" class="wpc_pro_time_picker wpc_pickup_weekly_schedule_start_time_<?php echo intval($index) ?> ml-2 mr-1 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("Start time", "wpcafe-pro");?>" />
                                        <input type="text" name="wpc_pickup_weekly_schedule_end_time[]" value="<?php echo esc_html($wpc_schedule['wpc_pickup_weekly_schedule_end_time'][$index]); ?>" class="wpc_pro_time_picker wpc_pickup_weekly_schedule_end_time_<?php echo intval($index) ?> ml-2 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("End time", "wpcafe-pro");?>" />
                                        <div class="wpc_pickup_weekly_clear" id="<?php echo intval($index) ?>"><?php esc_html_e('clear','wpcafe-pro'  )?></div>
                                    </div>
                                    <?php if ($index != 0) { ?>
                                        <span class="dashicons wpc-btn dashicons dashicons-no-alt remove_pickup_block pl-1"></span>
                                    <?php } ?>
                                </div>
                                <?php
                            }
                        } else {
                            ?>
                            <div class="pickup_schedule_block pickup_weekly_block">
                                <div class="wpc-weekly-schedule-list">
                                    <?php foreach ($week_days as $key => $value) { ?>
                                        <input type="checkbox" name="wpc_pickup_weekly_schedule[0][<?php echo esc_html($value);?>]" 
                                        class="<?php echo esc_html(strtolower($value));?>" id="weekly_pickup_<?php echo esc_html(strtolower($value))."0";?>"
                                        /><label for="weekly_pickup_<?php echo esc_html(strtolower($value))."0";?>"><?php echo esc_html__($value, "wpcafe-pro" ); ?></label>
                                    <?php  } ?>
                                </div>
                                <div class="wpc-schedule-field">
                                    <input type="text" name="wpc_pickup_weekly_schedule_start_time[]" class="wpc_pro_time_picker wpc_pickup_weekly_schedule_start_time_0 mr-1 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("Start time", "wpcafe-pro" ); ?>" />
                                    <input type="text" name="wpc_pickup_weekly_schedule_end_time[]" class="wpc_pro_time_picker wpc_pickup_weekly_schedule_end_time_0 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__("End time", "wpcafe-pro" ); ?>" />
                                    <div class="wpc_pickup_weekly_clear" id="0"><?php esc_html_e('clear','wpcafe-pro'  )?></div>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="wpc_flex_reverse wpc-weekly-schedule-btn">
                        <span class="add_pickup_weekly_block wpc-btn" data-start_time="<?php echo esc_html__('Start time', 'wpcafe-pro' ); ?>"="<?php echo esc_html__("Start time", "wpcafe-pro" ); ?>" data-end_time="<?php echo esc_html__("End time", "wpcafe-pro" ); ?>">
                            <i class="dashicons icon_cursor text-right dashicons-plus-alt  pl-1"></i>
                        </span>
                    </div>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_delivery_schedule" class="wpc-settings-label"><?php esc_html_e('Delivery weekly schedule', "wpcafe-pro" ); ?></label>
                    <p class="wpc-desc"> <?php esc_html_e("Set delivery weekly schedule", "wpcafe-pro" ); ?> </p>
                </div>
                <div class="wpc-meta">
                    <div class="delivery_schedule_main_block">
                        <h5 class="wpc_pb_two"><?php esc_html_e('Delivery weekly (set opening and closing schedule for each day of a week seperately)', "wpcafe-pro" ); ?></h5>
                        <?php
                        $wpc_schedule['wpc_delivery_schedule'] = isset($wpc_pro_menu_settings['wpc_delivery_schedule']) ? $wpc_pro_menu_settings['wpc_delivery_schedule'] : [];
                        $wpc_schedule['wpc_delivery_weekly_schedule_start_time'] = isset($wpc_pro_menu_settings['wpc_delivery_weekly_schedule_start_time']) ? $wpc_pro_menu_settings['wpc_delivery_weekly_schedule_start_time'] : [];
                        $wpc_schedule['wpc_delivery_weekly_schedule_end_time']   = isset($wpc_pro_menu_settings['wpc_delivery_weekly_schedule_end_time']) ? $wpc_pro_menu_settings['wpc_delivery_weekly_schedule_end_time'] : [];
                        if ( is_array($wpc_schedule['wpc_delivery_schedule']) && count($wpc_schedule['wpc_delivery_schedule']) > 0) {
                            for ($index = 0; $index < count($wpc_schedule['wpc_delivery_schedule']); $index++) {
                                $schedule_sat = isset($wpc_schedule['wpc_delivery_schedule'][$index]['Sat']) ? 'checked' : '';
                                $schedule_sun = isset($wpc_schedule['wpc_delivery_schedule'][$index]['Sun']) ? 'checked' : '';
                                $schedule_mon = isset($wpc_schedule['wpc_delivery_schedule'][$index]['Mon']) ? 'checked' : '';
                                $schedule_tue = isset($wpc_schedule['wpc_delivery_schedule'][$index]['Tue']) ? 'checked' : '';
                                $schedule_wed = isset($wpc_schedule['wpc_delivery_schedule'][$index]['Wed']) ? 'checked' : '';
                                $schedule_thu = isset($wpc_schedule['wpc_delivery_schedule'][$index]['Thu']) ? 'checked' : '';
                                $schedule_fri = isset($wpc_schedule['wpc_delivery_schedule'][$index]['Fri']) ? 'checked' : '';
                                ?>
                                <div class="delivery_schedule_block delivery_weekly_block">
                                    <div class="wpc-weekly-schedule-list">
                                        <input type="checkbox" name="wpc_delivery_schedule[<?php echo intval($index) ?>][Sat]" class="sat" id="delivery_sat<?php echo esc_html($index); ?>" <?php echo Wpc_Utilities::wpc_render($schedule_sat); ?> /> <label for="delivery_sat<?php echo esc_html($index); ?>"><?php echo esc_html__('Sat', "wpcafe-pro" ); ?></label>
                                        <input type="checkbox" name="wpc_delivery_schedule[<?php echo intval($index) ?>][Sun]" class="sun" id="delivery_sun<?php echo esc_html($index); ?>" <?php echo Wpc_Utilities::wpc_render($schedule_sun); ?> /> <label for="delivery_sun<?php echo esc_html($index); ?>"><?php echo esc_html__('Sun', "wpcafe-pro" ); ?></label>
                                        <input type="checkbox" name="wpc_delivery_schedule[<?php echo intval($index) ?>][Mon]" class="mon" id="delivery_mon<?php echo esc_html($index); ?>" <?php echo Wpc_Utilities::wpc_render($schedule_mon); ?> /> <label for="delivery_mon<?php echo esc_html($index); ?>"><?php echo esc_html__('Mon', "wpcafe-pro" ); ?></label>
                                        <input type="checkbox" name="wpc_delivery_schedule[<?php echo intval($index) ?>][Tue]" class="tue" id="delivery_tue<?php echo esc_html($index); ?>" <?php echo Wpc_Utilities::wpc_render($schedule_tue); ?> /> <label for="delivery_tue<?php echo esc_html($index); ?>"><?php echo esc_html__('Tue', "wpcafe-pro" ); ?></label>
                                        <input type="checkbox" name="wpc_delivery_schedule[<?php echo intval($index) ?>][Wed]" class="wed" id="delivery_wed<?php echo esc_html($index); ?>" <?php echo Wpc_Utilities::wpc_render($schedule_wed); ?> /> <label for="delivery_wed<?php echo esc_html($index); ?>"><?php echo esc_html__('Wed', "wpcafe-pro" ); ?></label>
                                        <input type="checkbox" name="wpc_delivery_schedule[<?php echo intval($index) ?>][Thu]" class="thu" id="delivery_thu<?php echo esc_html($index); ?>" <?php echo Wpc_Utilities::wpc_render($schedule_thu); ?> /> <label for="delivery_thu<?php echo esc_html($index); ?>"><?php echo esc_html__('Thu', "wpcafe-pro" ); ?></label>
                                        <input type="checkbox" name="wpc_delivery_schedule[<?php echo intval($index) ?>][Fri]" class="fri" id="delivery_fri<?php echo esc_html($index); ?>" <?php echo Wpc_Utilities::wpc_render($schedule_fri); ?> /> <label for="delivery_fri<?php echo esc_html($index); ?>"><?php echo esc_html__('Fri', "wpcafe-pro" ); ?></label>
                                    </div>
                                    <div class="wpc-schedule-field">
                                        <input type="text" name="wpc_delivery_weekly_schedule_start_time[]" value="<?php echo Wpc_Utilities::wpc_render($wpc_schedule['wpc_delivery_weekly_schedule_start_time'][$index]); ?>" class="wpc_pro_time_picker wpc_delivery_weekly_schedule_start_time_<?php echo intval($index) ?> ml-2 mr-1 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e("Start time", "wpcafe-pro");?>" />
                                        <input type="text" name="wpc_delivery_weekly_schedule_end_time[]" value="<?php echo Wpc_Utilities::wpc_render($wpc_schedule['wpc_delivery_weekly_schedule_end_time'][$index]); ?>" class="wpc_pro_time_picker wpc_delivery_weekly_schedule_end_time_<?php echo intval($index) ?> ml-2 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e("End time", "wpcafe-pro");?>" />
                                        <div class="wpc_delivery_weekly_clear" id="<?php echo intval($index) ?>"><?php esc_html_e('clear','wpcafe-pro'  )?></div>
                                    </div>
                                    <?php if ($index != 0) { ?>
                                        <span class="dashicons wpc-btn dashicons dashicons-no-alt remove_delivery_block pl-1"></span>
                                    <?php } ?>
                                </div>
                            <?php
                            }
                        } else {
                            ?>
                            <div class="delivery_schedule_block delivery_weekly_block">
                                <div class="wpc-weekly-schedule-list">
                                    <?php  foreach ($week_days as $key => $value) { ?>
                                            <input type="checkbox" name="wpc_delivery_schedule[0][<?php echo esc_html($value);?>]" 
                                            class="<?php echo esc_html(strtolower($value));?>" id="delivery_<?php echo esc_html(strtolower($value));?>"
                                            /><label for="delivery_<?php echo esc_html(strtolower($value));?>"><?php echo esc_html__($value, "wpcafe-pro" ); ?></label>
                                    <?php  }  ?>
                                </div>
                                <div class="wpc-schedule-field">
                                    <input type="text" name="wpc_delivery_weekly_schedule_start_time[]" class="wpc_pro_time_picker wpc_delivery_weekly_schedule_start_time_0 mr-1 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__('Start time', 'wpcafe-pro' ); ?>" />
                                    <input type="text" name="wpc_delivery_weekly_schedule_end_time[]" class="wpc_pro_time_picker wpc_delivery_weekly_schedule_end_time_0 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__('End time', 'wpcafe-pro' ); ?>" />
                                    <div class="wpc_delivery_weekly_clear" id="0"><?php esc_html_e('clear','wpcafe-pro'  )?></div>
                                </div>
                            </div>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="wpc_flex_reverse wpc-weekly-schedule-btn">
                        <span class="add_delivery_weekly_block wpc-btn" data-start_time="<?php echo esc_html__("Start time", "wpcafe-pro" ); ?>" data-end_time="<?php echo esc_html__("End time", "wpcafe-pro" ); ?>">
                            <i class="dashicons icon_cursor text-right dashicons-plus-alt  pl-1"></i>
                        </span>
                    </div>
                </div>
            </div>
            <h3 class="wpc-tab-title"><?php esc_html_e('Holiday', "wpcafe-pro" ); ?></h3>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pickup_holiday" class="wpc-settings-label"><?php esc_html_e('Pickup weekly holiday', "wpcafe-pro" ); ?></label>
                    <p class="wpc-desc"> <?php esc_html_e("Set pickup weekly holiday schedule", "wpcafe-pro" ); ?> </p>
                </div>
                <div class="wpc-meta">
                    <div class="wpc-weekly-schedule-list">
                        <?php
                        $holidays =['Sun','Mon','Tue','Wed','Thu','Fri','Sat'];
                        $wpc_schedule['wpc_pickup_holiday'] = isset($wpc_pro_menu_settings['wpc_pickup_holiday']) ? $wpc_pro_menu_settings['wpc_pickup_holiday'] : [];
                        if (is_array($wpc_schedule['wpc_pickup_holiday']) && count($wpc_schedule['wpc_pickup_holiday']) > 0) {
                            $index = 0; 
                            foreach ($holidays as $key => $value) { ?>
                                <input type="checkbox" name="wpc_pickup_holiday[<?php echo intval( $key );?>]" <?php echo isset($wpc_schedule['wpc_pickup_holiday'][$key]) ? 'checked' : ''?>
                                id="wpc_pickup_holiday_<?php echo esc_html(strtolower($value));?>" /><label for="wpc_pickup_holiday_<?php echo esc_html(strtolower($value));?>"><?php echo esc_html__($value, "wpcafe-pro" ); ?></label>
                            <?php }
                        } else {
                            foreach ($holidays as $key => $value) { ?>
                                <input type="checkbox" name="wpc_pickup_holiday[<?php echo intval( $key );?>]" id="wpc_pickup_holiday_<?php echo esc_html(strtolower($value));?>" /><label for="wpc_pickup_holiday_<?php echo esc_html(strtolower($value));?>"><?php echo esc_html__($value, "wpcafe-pro" ); ?></label>
                            <?php }
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_pickup_holiday" class="wpc-settings-label"><?php esc_html_e('Pickup holiday', "wpcafe-pro" ); ?></label>
                    <p class="wpc-desc"> <?php esc_html_e("Set pickup off for specific day", "wpcafe-pro" ); ?> </p>
                </div>
                <div class="wpc-meta">
                    <div class="pickup_exception_main_block">
                        <?php
                        $wpc_exception['wpc_pickup_exception_date']       = isset($wpc_pro_menu_settings['wpc_pickup_exception_date']) ? $wpc_pro_menu_settings['wpc_pickup_exception_date'] : [];
                        if ( is_array($wpc_exception['wpc_pickup_exception_date']) && count($wpc_exception['wpc_pickup_exception_date']) > 0 && $wpc_exception['wpc_pickup_exception_date']['0'] !== '') {
                            for ($index = 0; $index < count($wpc_exception['wpc_pickup_exception_date']); $index++) {
                                ?>
                                <div class="pickup_exception_block d-flex mb-2">
                                    <input type="text" name="wpc_pickup_exception_date[]" value="<?php echo Wpc_Utilities::wpc_render($wpc_exception['wpc_pickup_exception_date'][$index]); ?>" class="wpc_pickup_exception_date mr-1 wpc-settings-input attr-form-control" id="pickup_exception_date_<?php echo Wpc_Utilities::wpc_render($index) ?>" placeholder="<?php esc_html_e('Date','wpcafe-pro');?>" />
                                </div>
                                <?php
                            }
                        } else {
                            ?>
                            <div class="pickup_exception_block d-flex mb-2">
                                <input type="text" name="wpc_pickup_exception_date[]" value="" class="wpc_pickup_exception_date mr-1 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e('Date','wpcafe-pro');?>" />
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="wpc_flex_reverse pick_add_section">
                        <span class="add_pickup_exception_block wpc-btn" data-date_text="<?php echo esc_html__("Date", "wpcafe-pro");?>">
                            <i class="dashicons icon_cursor text-right dashicons-plus-alt  pl-1"></i>
                        </span>
                    </div>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_delivery_holiday" class="wpc-settings-label"><?php esc_html_e('Delivery weekly holiday', "wpcafe-pro" ); ?></label>
                    <p class="wpc-desc"> <?php esc_html_e("Set delivery weekly holiday schedule", "wpcafe-pro" ); ?> </p>
                </div>
                <div class="wpc-meta">
                    <div class="wpc-weekly-schedule-list">
                        <?php
                        $wpc_schedule['wpc_delivery_holiday'] = isset($wpc_pro_menu_settings['wpc_delivery_holiday']) ? $wpc_pro_menu_settings['wpc_delivery_holiday'] : [];
                        if (is_array($wpc_schedule['wpc_delivery_holiday']) && count($wpc_schedule['wpc_delivery_holiday']) > 0) {
                            $index = 0;
                            foreach ($holidays as $key => $value) { ?>
                                <input type="checkbox" name="wpc_delivery_holiday[<?php echo intval( $key );?>]" <?php echo isset($wpc_schedule['wpc_delivery_holiday'][$key]) ? 'checked' : ''?>
                                id="delivery_holiday_<?php echo esc_html(strtolower($value));?>" /><label for="delivery_holiday_<?php echo esc_html(strtolower($value));?>"><?php echo esc_html__($value, "wpcafe-pro" ); ?></label>
                            <?php }
                        } else {
                            foreach ($holidays as $key => $value) { ?>
                                <input type="checkbox" name="wpc_delivery_holiday[<?php echo intval( $key );?>]" id="delivery_holiday_<?php echo esc_html(strtolower($value));?>" /><label for="delivery_holiday_<?php echo esc_html(strtolower($value));?>"><?php echo esc_html__($value, "wpcafe-pro" ); ?></label>
                            <?php }
                        } ?>
                    </div>
                </div>
            </div>
            <div class="wpc-label-item">
                <div class="wpc-label">
                    <label for="wpc_delivery_holiday" class="wpc-settings-label"><?php esc_html_e('Delivery holiday', "wpcafe-pro" ); ?></label>
                    <p class="wpc-desc"> <?php esc_html_e("Set delivery off for specific day", "wpcafe-pro" ); ?> </p>
                </div>
                <div class="wpc-meta">
                    <div class="delivery_exception_main_block">
                        <?php
                        $wpc_exception['wpc_delivery_exception_date']       = isset($wpc_pro_menu_settings['wpc_delivery_exception_date']) ? $wpc_pro_menu_settings['wpc_delivery_exception_date'] : [];
                        if (is_array($wpc_exception['wpc_delivery_exception_date']) && count($wpc_exception['wpc_delivery_exception_date']) > 0 && $wpc_exception['wpc_delivery_exception_date']['0'] !== '') {
                            for ($index = 0; $index < count($wpc_exception['wpc_delivery_exception_date']); $index++) {
                                ?>
                                <div class="delivery_exception_block d-flex mb-2">
                                    <input type="text" name="wpc_delivery_exception_date[]" value="<?php echo Wpc_Utilities::wpc_render($wpc_exception['wpc_delivery_exception_date'][$index]); ?>" class="wpc_delivery_exception_date mr-1 wpc-settings-input attr-form-control" id="pickup_delivery_date_<?php echo Wpc_Utilities::wpc_render($index) ?>" placeholder="<?php esc_html_e('Date','wpcafe-pro');?>" />
                                </div>
                                <?php
                            }
                        } else {
                            ?>
                            <div class="delivery_exception_block d-flex mb-2">
                                <input type="text" name="wpc_delivery_exception_date[]" value="" class="wpc_delivery_exception_date mr-1 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e('Date','wpcafe-pro');?>" />
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="wpc_flex_reverse delivery_add_section ">
                        <span class="add_delivery_exception_block wpc-btn" data-date_text="<?php echo esc_html__("Date", "wpcafe-pro");?>">
                            <i class="dashicons icon_cursor text-right dashicons-plus-alt  pl-1"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * Send notifictaion both for confirm and cancell function
     */
    public function notifications($settings, $reservation_state, $wpc_template) {

        if (is_array($wpc_template) && isset($wpc_template[1])) {
            if (isset($reservation_state) && $reservation_state == 'cancelled') {
                // if reservation cancelled
                $this->canelled_request($settings, $wpc_template[2], $wpc_template);
            } else {
                /**
                 * email to admin & user for confirmed / pending request
                 */
                if (!isset($settings['wpc_admin_notification_for_confirm_req'])
                 || ( isset($settings['wpc_admin_notification_for_confirm_req']) && $settings['wpc_admin_notification_for_confirm_req'] =='on' ) && 
                isset($settings['wpc_admin_email_address'])
                ) {
                    $mail_to        = $settings['wpc_admin_email_address'];
                    $mail_subject   = isset($settings['wpc_admin_booking_confirm_subject']) ? $settings['wpc_admin_booking_confirm_subject'] : "";
                    $mail_body      = isset($settings['wpc_admin_booking_confirm_email'] ) && $settings['wpc_admin_booking_confirm_email'] !=='' ? esc_html__("Reservation confirmed. Invoice no. ".$wpc_template[2] .".  ","wpcafe-pro") . $settings['wpc_admin_booking_confirm_email'] : esc_html__("Reservation confirmed. Invoice no. ".$wpc_template[2] .".  ","wpcafe-pro");
                    $mail_from      = isset($settings['sender_email_address']) && $settings['sender_email_address'] !==''  ? $settings['sender_email_address'] : $settings['wpc_admin_email_address'];
                    $mail_from_name = isset($settings['wpc_reply_to_name'])  ? $settings['wpc_reply_to_name']  : esc_html__("Admin","wpcafe-pro");
                    $wpc_email_body = str_replace($wpc_template[0], $wpc_template[1], $mail_body);

                    Wpc_Utilities::wpc_send_email($mail_to, $mail_subject, $wpc_email_body, $mail_from, $mail_from_name);
                }
                if ( !isset( $settings['wpc_user_notification_for_confirm_req'] ) ||
                    ( isset($settings['wpc_user_notification_for_confirm_req']) && $settings['wpc_user_notification_for_confirm_req'] =='on' ) ) {
                    $mail_to = $wpc_template[1][3];
                    $mail_subject   = isset($settings['wpc_confirm_email_subject']) ? $settings['wpc_confirm_email_subject'] : "";
                    $mail_body      = isset( $settings['wpc_confirm_email'] ) && $settings['wpc_confirm_email'] !=='' ? esc_html__('Your reservation is confirmed.Invoice no. '.$wpc_template[2].". ",'wpcafe-pro') . $settings['wpc_confirm_email'] : esc_html__('Your reservation is confirmed.Invoice no. '.$wpc_template[2].". ",'wpcafe-pro');
                    $mail_from      = isset($settings['sender_email_address']) && $settings['sender_email_address'] !==''  ? $settings['sender_email_address'] : $settings['wpc_admin_email_address'];
                    $mail_from_name = isset($settings['wpc_reply_to_name'])  ? $settings['wpc_reply_to_name']  : esc_html__("Admin","wpcafe-pro");
                    $wpc_email_body = str_replace($wpc_template[0], $wpc_template[1], $mail_body);

                    Wpc_Utilities::wpc_send_email($mail_to, $mail_subject, $wpc_email_body, $mail_from, $mail_from_name);
                }
            }
        }
    }

    /**
     * Cancell request mail function
     */
    public function canelled_request($settings, $invoice_no, $wpc_template ) {
        /**
         * email to admin & user for cancell request
         */
        if (!isset($settings['wpc_admin_cancel_notification']) || ( isset($settings['wpc_admin_cancel_notification']) 
        && $settings['wpc_admin_cancel_notification'] =='on' ) &&  isset( $settings['wpc_admin_email_address'] ) ) {
            $mail_to      = $settings['wpc_admin_email_address'];
            $mail_subject = isset($settings['wpc_admin_booking_cancel_subject']) ? $settings['wpc_admin_booking_cancel_subject'] : '';
            $mail_body    = esc_html__("Reservation is cancelled. Invoice No: ","wpcafe-pro"). $invoice_no .". ";
            $mail_body   .= isset($settings['wpc_admin_booking_cancel_email']) ? $settings['wpc_admin_booking_cancel_email'] : '';
            $mail_from      = isset($settings['sender_email_address']) && $settings['sender_email_address'] !==''  ? $settings['sender_email_address'] : $settings['wpc_admin_email_address'];
            $mail_from_name = isset($settings['wpc_reply_to_name'])  ? $settings['wpc_reply_to_name']  : esc_html__("Admin","wpcafe-pro");
            $wpc_email_body = str_replace($wpc_template[0], $wpc_template[1], $mail_body);
            
            Wpc_Utilities::wpc_send_email($mail_to, $mail_subject, $wpc_email_body, $mail_from, $mail_from_name);
        }
        if ( ( !isset($settings['wpc_user_notification_for_cancel_req']) || 
        (isset($settings['wpc_user_notification_for_cancel_req']) && $settings['wpc_user_notification_for_cancel_req'] == 'on') )) {
            if (is_array($wpc_template) && count($wpc_template) > 0) {
                $wpc_pro_email_info = $wpc_template[1];
                $mail_to      = $wpc_pro_email_info[3];
                $mail_subject = isset($settings['wpc_rejected_email_subject']) ? $settings['wpc_rejected_email_subject'] : '';
                $mail_body    = esc_html__("Reservation is cancelled. Invoice No: ","wpcafe-pro") . $invoice_no.". ";
                $mail_body   .= isset($settings['wpc_rejected_email'])   ? $settings['wpc_rejected_email'] : '';
                $mail_from      = isset($settings['sender_email_address']) && $settings['sender_email_address'] !==''  ? $settings['sender_email_address'] : $settings['wpc_admin_email_address'];
                $mail_from_name = isset($settings['wpc_reply_to_name'])  ? $settings['wpc_reply_to_name']  : esc_html__("Admin","wpcafe-pro");
                $wpc_email_body = str_replace($wpc_template[0], $wpc_template[1], $mail_body);

                Wpc_Utilities::wpc_send_email($mail_to, $mail_subject, $wpc_email_body, $mail_from, $mail_from_name);
            }
        }
    }

    /**
     * Frontend ajax from submission function
     */
    public function admin_reserve_submit_notification($settings, $invoice_no, $wpc_template) {
        // get post id 
        global $wpdb;
        $table = $wpdb->prefix . 'postmeta';
        $invoice_no = trim($invoice_no);
        $prepare_guery = $wpdb->prepare("SELECT post_id FROM $table where meta_key ='wpc_reservation_invoice' and meta_value like '%%%s%%' ", $invoice_no);
        $get_values = $wpdb->get_col($prepare_guery);
        if (count($get_values) > 0) {
            $pid = $get_values[0];
            $wpc_value_arr = 
            array(
                get_bloginfo('name'),
                get_option('home'),
                get_post_meta($pid, 'wpc_name', true),
                get_post_meta($pid, 'wpc_email', true),
                get_post_meta($pid, 'wpc_phone', true),
                get_post_meta($pid, 'wpc_message', true),
                get_post_meta($pid, 'wpc_total_guest', true),
                get_post_meta($pid, 'wpc_booking_date', true) . " Start time : " .
                    get_post_meta($pid, 'wpc_from_time', true) . " End time : " .
                    get_post_meta($pid, 'wpc_to_time', true),
                date('Y-m-d H:i:s')
             );
            $wpc_template = [$wpc_template, $wpc_value_arr];
            $this->canelled_request($settings, $invoice_no, $wpc_template);
        }
    }

    /**
     * Check validation 
     */
    public function settings_validation($request) {
        $validated = true;

        switch ($request) {

            case ( ( isset( $request['wpc_pickup_weekly_schedule_start_time'] ) 
                && $request['wpc_pickup_weekly_schedule_start_time'][0] !== "") 
                || (isset( $request['wpc_pickup_weekly_schedule_end_time'] ) 
                && $request['wpc_pickup_weekly_schedule_end_time'][0] !== "" ) ) :

                if( \WpCafe\Core\Base\Wpc_Settings_Field::instance()->compare_time( $request['wpc_pickup_weekly_schedule_start_time'],$request['wpc_pickup_weekly_schedule_end_time'] ) ){
                    $validated = false;
                }

            break;

            case ( ( isset( $request['wpc_delivery_weekly_schedule_start_time'] ) 
            && $request['wpc_delivery_weekly_schedule_start_time'][0] !== "" )
            || (isset( $request['wpc_delivery_weekly_schedule_end_time'] ) 
            && $request['wpc_delivery_weekly_schedule_end_time'][0] !== "" ) ) :

                if( \WpCafe\Core\Base\Wpc_Settings_Field::instance()->compare_time( $request['wpc_delivery_weekly_schedule_start_time'],$request['wpc_delivery_weekly_schedule_end_time']) ){
                    $validated = false;
                }

            break;

            default:
                 return true;
             break;
        }
        if( !$validated ){
            add_settings_error( "validation_error", 
                                701, 
                                esc_html__( "Pickup & Delivery schedule start time can't be grater than or equal end time" , "wpcafe-pro"), 
                                "error" 
                            );
        }
        return $validated;

    }

}
