<?php

namespace WpCafe_Pro\Core\Report;
use WpCafe\Core\Base\Wpc_Settings_Field as Settings;

defined( "ABSPATH" ) || exit;

use WpCafe\Utils\Wpc_Utilities;

class Reservation_Report{

    use \WpCafe_Pro\Traits\Singleton;
    
    /**
     * Class constructor.
     */
    public function init(){
        add_filter( 'page_row_actions', [$this,'modify_list_row_actions'], 10, 2 );
        add_filter('wpcafe/key_options/reservation_details',[$this,'reservation_details']);
        add_action( 'manage_posts_extra_tablenav', [$this,'reservation_export_block']);
        // reservation report
        add_action( 'init', [$this, 'csv_export_reservation_report'] );
    }

    /**
     * Get reservation post function
     */
    public function get_reservation(){
        $reservation_report = get_posts(
            array(
                'post_type'         => 'wpc_reservation',
                'numberposts'       => -1,
                'post_status'       => 'publish')
        );

        return $reservation_report;
    }

    /**
     * Export reservation extra field data function
     */
    public function reservation_extra_field_data(){
        $data = [];$extra_field_name = [];
        $header_field = ["Invoice","Name", "Email", "Phone", "Seats", "Date", "Status"];
        $settings =     Settings::instance()->get_settings_option();
        $reserv_extra_label     = $settings['reserv_extra_label'];
        if( ( is_array( $reserv_extra_label ) && count( $reserv_extra_label )>0 ) ){
            foreach ( $reserv_extra_label as $key => $value ) {
                if( $value !=='' ){
                    array_push( $extra_field_name , 'reserv_extra_'.$key );
                    array_push( $header_field , $value );
                }
            }
        }

        $data['header_field']       = $header_field;
        $data['extra_field_name']   = $extra_field_name;

        return $data;
    }

    /**
     * Export attendee function
     */
    public function csv_export_reservation_report() {

        // Check if we are in WP-Admin
        if ( !is_admin() ) {return false;}
        if(isset($_GET['reserv_export_pro'])) :
        // get extra field data
        $result_data = $this->reservation_extra_field_data();

        // get reservation
        $reservation_report = $this->get_reservation();

        if( is_array( $reservation_report ) && count( $reservation_report )>0 ) :
            $generated_date = date( 'd-m-Y His' ); //Date will be part of file name.
            header( "Content-type: text/csv" );
            header( "Content-Disposition: attachment; filename=\"reservation_report_" . $generated_date . ".csv\";" );

            // create a file pointer connected to the output stream
            $output = fopen( 'php://output', 'w' ) or die( "Can\'t open php://output" );

            // output the column headings
            fputcsv( $output, $result_data['header_field'] );
            foreach ( $reservation_report as $key => $value ) {
                $invoice        = get_post_meta($value->ID, 'wpc_reservation_invoice', true);
                $name           = get_post_meta($value->ID, 'wpc_name', true);
                $email          = get_post_meta($value->ID, 'wpc_email', true);
                $phone          = get_post_meta($value->ID, 'wpc_phone', true);
                $seats          = get_post_meta($value->ID, 'wpc_total_guest', true);
                $date           = get_post_meta($value->ID, 'wpc_booking_date', true);
                $status         = get_post_meta($value->ID, 'wpc_reservation_state', true);
                $reserve_value  = [$invoice , $name, $email, $phone, $seats, $date, $status ]; 
                if( is_array( $result_data['extra_field_name'] ) && count( $result_data['extra_field_name'] )>0 ){
                    for ($i=0; $i < count( $result_data['extra_field_name'] ) ; $i++) { 
                        $extra_data = get_post_meta( $value->ID , $result_data['extra_field_name'][$i] , true);
                        array_push( $reserve_value , $extra_data );
                    }
                }
                fputcsv( $output, $reserve_value );
            }

            // Close output file stream
            fclose( $output );
            die();
        else:
        endif;
        endif;
    }

    /**
     * Reservation export section
     */
    public function reservation_export_block() {
        global $typenow , $pagenow ;
        if ( $typenow == 'wpc_reservation' &&  $pagenow == "edit.php"  ):
            $reservation_count = count( $this->get_reservation() );
            if ($reservation_count > 0) {
        ?>
        <form>
            <button type="submit" name="reserv_export_pro" class="button button-primary">
                <?php echo esc_html__('Export to CSV', 'wpcafe-pro'); ?>
            </button>
        </form>
        <?php
            }
        endif;
    }

    /**
     * Add details action and remove views actions
     *
     * @param $actions
     * @param $post
     * @return void
     */
    public function modify_list_row_actions( $actions , $post ) {
        // Check for your post type.
        if ( $post->post_type == "wpc_reservation" ) {
            unset($actions['view']);

            // Build  URL.
            $url = admin_url( 'admin.php?page=cafe_menu&post_id=' . $post->ID );
            $trash = $actions['trash'];
            // // You can check if the current user has some custom rights.
            if ( current_user_can( 'manage_options', $post->ID ) ) {
            // Include a nonce in this link
            $details_link = wp_nonce_url( add_query_arg( array( 'action' => 'reservation_details' ), $url ), 'wpc_pro_reservation_details' );
            // Add the new details quick link.
            $actions = array_merge( $actions , array(
                'reservation_details' => sprintf( '<a href="%1$s">%2$s</a>',
                    esc_url( $details_link ), 
                    'Details'
                ) 
            ) );
            // Re-insert thrash link preserved from the default $actions.
            $actions['trash']=$trash;
            }
        }
        return $actions;
    }

    public function reservation_details() {
        if ( is_admin()  && isset($_GET['action']) && sanitize_text_field($_GET['action']) == 'reservation_details') {
            if (! wp_verify_nonce( $_REQUEST['_wpnonce'], 'wpc_pro_reservation_details' ) ) {
                return false;
            }else{
                $id = Wpc_Utilities::wpc_numeric($_GET['post_id']);
                $name = get_post_meta($id,'wpc_name',true);
                ?>
                <div class="wrap">
                    <button class="button-primary" onclick="wpc_pro_pirnt_content_area('print_reservation_details');"><?php echo esc_html__( 'Print' , 'wpcafe-pro' );?></button>
                    <div id="print_reservation_details">
                        <h3><?php echo esc_html__('Details of ', 'wpcafe-pro' ) . sanitize_text_field($name); ?></h3>
                        <table>
                            <tbody>
                                <tr>
                                    <td><strong><?php echo esc_html__('Name:', 'wpcafe-pro' );?></strong></td><td><?php echo sanitize_text_field($name);?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo esc_html__('Email:', 'wpcafe-pro' );?></strong></td><td><?php echo Wpc_Utilities::wpc_render( get_post_meta($id,'wpc_email',true) ) ;?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo esc_html__('Phone:', 'wpcafe-pro' );?></strong></td><td><?php echo Wpc_Utilities::wpc_render( get_post_meta($id,'wpc_phone',true) );?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo esc_html__('Message:', 'wpcafe-pro' );?></strong></td><td><?php echo Wpc_Utilities::wpc_render( get_post_meta($id,'wpc_message',true) );?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo esc_html__('Reservation date:', 'wpcafe-pro');?></strong></td><td><?php echo Wpc_Utilities::wpc_render( get_post_meta($id,'wpc_booking_date',true) );?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo esc_html__('Booking start time:', 'wpcafe-pro');?></strong></td><td><?php echo Wpc_Utilities::wpc_render( get_post_meta($id,'wpc_from_time',true) );?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo esc_html__('Booking end time:', 'wpcafe-pro');?></strong></td><td><?php echo Wpc_Utilities::wpc_render( get_post_meta($id,'wpc_to_time',true) );?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo esc_html__('No of geusts:', 'wpcafe-pro');?></strong></td><td><?php echo Wpc_Utilities::wpc_render( get_post_meta($id,'wpc_total_guest',true) );?></td>
                                </tr>
                                <tr>
                                    <td><strong><?php echo esc_html__('Booking status', 'wpcafe-pro');?></strong></td><td><?php echo Wpc_Utilities::wpc_render( get_post_meta($id,'wpc_reservation_state',true) );?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php
            }
        }
    }
}