<?php
namespace WpCafe_Pro;

defined( "ABSPATH" ) || exit;

/**
 * Load all admin class
 */
class Core {
    use \WpCafe_Pro\Traits\Singleton;

    /**
     *  Call admin function
     */
    public function admin_action_init() {
        // reservation details
        $this->register_all_reports();

        // settings
        \WpCafe_Pro\Core\Template\Keyoptions::instance()->init();

        /**
         * Register metaboxes for product preparing and delivery time
         */
        $Foodmenu_Metabox = \WpCafe_Pro\Core\Metaboxes\Foodmenu_Meta::instance();
        add_action( 'add_meta_boxes', [$Foodmenu_Metabox, 'register_meta_boxes'] );
        add_action( 'save_post', [$Foodmenu_Metabox, 'save_meta_box_data'] );

        if ( is_array( $Foodmenu_Metabox ) ) {
            add_filter( 'wp_insert_post_data', [$Foodmenu_Metabox, 'save_foodmenu_title'], 500, 2 );
        }

    }

    /**
     * Register report
     *
     * @return void
     */
    public function register_all_reports() {
        //register reservation report dashboard
        \WpCafe_Pro\Core\Report\Reservation_Report::instance()->init();
    }

}
