function wpc_widgets_popup($, $scope) {
    var currentButton   = $scope.find(".customize_button");
    var content_class   = $scope.find(".variation_popup_content");
    var prepend_to      = $scope.find(".wpc-widget-wrapper");

    // attach magnific popup to customize button
    currentButton.magnificPopup({
        type: 'inline',
        closeOnContentClick: false,
        midClick: true,
        prependTo: prepend_to,
        mainClass: 'mfp-fade'
    });
    currentButton.on('click', function (e) {
        e.preventDefault();
        var data = {
                    action: 'variaion_product_popup_content',
                    product_id: $(this).data("product_id"),
                    _wpcnonce: wpc_obj.variaion_popup_nonce,
                    wpc_action: 'variaion_popup',
                };
        
        content_class.empty();

        $.ajax({
            url: wpc_obj.ajax_url,
            type: 'POST',
            data: data,
            dataType: 'html',
            success: function (response) {
                var content_data = JSON.parse(response);
                var parsed_data = JSON.parse(content_data.data.data);
                content_class.html( parsed_data );

                // Variation Form
                var form_variation = content_class.find('.variations_form');
                form_variation.each(function () {
                    $(this).wc_variation_form();
                });

                form_variation.trigger('check_variations');
                form_variation.trigger('reset_image');

                if (typeof $.fn.wc_product_gallery !== 'undefined') {
                    content_class.find('.woocommerce-product-gallery').each(function () {
                        $(this).wc_product_gallery();
                    });
                }
            }
        });
    });
}
function get_widget_id( $scope ) {
    var data_section    = $scope.find('.data_section');
    widget_arr          = data_section.data('widget_arr');
    widget_id = '';
    if ( typeof widget_arr !== 'undefined' && typeof widget_arr.widget_id !== 'undefined'  ) {
            var widget_id       = '_'+widget_arr.widget_id;
    }
    return widget_id;
}
// live search
function get_data_element( $scope ) {
    var data_obj = {}; 
    var total_product = -1 ; var cat_arr=[]; var cart_button='yes'; var template_name=""; 
    var data_section    = $scope.find('.data_section');
    total_product       = data_section.data('total_product');
    cat_arr             = data_section.data('cat_arr');
    cart_button         = data_section.data('cart_button');
    template_name       = data_section.data('template_name');
    template_path       = data_section.data('template_path');
    widget_arr          = data_section.data('widget_arr');
    var widget_id       = get_widget_id( $scope );
    var search_data     = $scope.find('.live_food_menu'+widget_id).val();
    data_obj['search_data']     = search_data;
    data_obj['total_product']   = total_product;
    data_obj['cat_arr']         = cat_arr;
    data_obj['cart_button']     = cart_button;
    data_obj['template_name']   = template_name;
    data_obj['template_path']   = template_path;
    data_obj['widget_arr']      = widget_arr;
    
    return data_obj;
}

function widget_live_search( $, $scope , search_data , widget_id , data_obj , tab = false , list_cat_id ) {
    if ( search_data !='' ) { 
        var tab_wrapper     = ".wpc-food-tab-wrapper";    
        var live_food_menu  = $('.live_food_menu_'+widget_id);   
        if ( tab && $scope.find(tab_wrapper).length>0 ) {
            $scope.find(tab_wrapper).find(".wpc-tab").removeClass('tab-active');
            $scope.find(tab_wrapper).find(".wpc-tab-a").removeClass('wpc-active');
            $scope.find(tab_wrapper).find(".wpc-tab-a[data-cat_id='" + list_cat_id + "']").addClass("wpc-active");
            $scope.find(tab_wrapper).find(".wpc-tab[data-cat_id='" + list_cat_id + "']").addClass("tab-active"); 
        }
        live_food_menu.val('');
        live_food_menu.val( search_data );
        $('.search_result_'+widget_id).html(' ');
        live_ajax_call( $ , search_data , data_obj.total_product , data_obj.cat_arr ,data_obj.cart_button ,  data_obj.template_name, data_obj.template_path, data_obj.widget_arr , true )
    }
}

function food_menu_search_fire( $, $scope ) {
    // live search
    var data_obj        = get_data_element( $scope );
    var widget_id       = get_widget_id( $scope );

    $(".live_food_menu"+widget_id).bind('paste keyup',function(e){
        e.preventDefault();
        live_ajax_call( $ , $(this).val() , data_obj.total_product , data_obj.cat_arr ,data_obj.cart_button , data_obj.template_name, data_obj.template_path, data_obj.widget_arr , false )
    });

    // list choice
    $(".search_result"+widget_id).on('click','ul.get_result li',function(e){
        e.preventDefault();
        widget_live_search( $, $scope , $(this).text() , widget_id , data_obj , true , $(this).data('cat_id') );
    })
}

function food_tab_action( $ , cat_id ) {
    var tab_wrapper = $(".wpc-food-tab-wrapper");       
    if (tab_wrapper.length>0) {
        tab_wrapper.find(".wpc-tab").removeClass('tab-active');
        tab_wrapper.find(".wpc-tab-a").removeClass('wpc-active');
        tab_wrapper.find(".wpc-tab-a[data-cat_id='" + cat_id + "']").addClass("wpc-active");
        tab_wrapper.find(".wpc-tab[data-cat_id='" + cat_id + "']").addClass("tab-active"); 
    }
}

function live_ajax_call( $ , search_value , total_product , cat_arr , cart_button , template_name , template_path = '', widget_arr = false , list_click = false ) {
    var wpc_cat = null
    if (cat_arr.length !== 0) {
        wpc_cat = cat_arr;
    }

    var data = {
        'action'            : 'live_search_ajax',
        'search_value'      : search_value,
        'total_product'     : total_product,
        'cat_arr'           : wpc_cat,
        'wpc_cart_button'   : cart_button,
        'template_name'     : template_name,
        'template_path'     : template_path,
        'widget_arr'        : widget_arr,
        'list_click'        : list_click,
        'security_nonce'    : wpc_obj.live_search_nonce,
    };

    $.ajax({
        url: wpc_obj.ajax_url,
        method: 'POST',
        data: data,
        success: function (response) {
            if ( response.success  ) {
                var widget_id = ''; 
                if (widget_arr) {
                    widget_id =  widget_arr['widget_id']
                }
                var search_result=$(".search_result_"+widget_id);
                search_result.html(" ")
                if ( list_click == false ) {
                    search_result.html( response.data.data.search_html )
                }
                if ( response.data.data.template_name ) {
                    var template_name   = "."+response.data.data.template_name;
                    var cat_id          = response.data.data.cat_id;
                    var popup_html      = ""; var template_id = "";
    
                    if (template_name == ".list_template" ) {
                        template_id = '_'+widget_id; 
                    }else{
                        template_id = '_'+cat_id;
                        var template_data = $(".template_data_"+cat_id);
                         // hide default tab html if exist
                        if ( template_data ){
                            template_data.fadeOut();
                            food_tab_action( $ , cat_id );
                        }
                    }
                    $( template_name+template_id ).html(" ")
                    $( template_name+template_id ).html( response.data.data.content ) 
    
                    popup_html = $(".main_wrapper_"+widget_id)
    
                    $('.wpc-nav-shortcode').each(function () {
                        wpc_widgets_popup($, popup_html );
                    }); 
                }
            }
        }
    })
}