<?php

/**
 *  @package wpcafe
 */

/**
 * Plugin Name:        WP Cafe
 * Plugin URI:         https://product.themewinter.com/wpcafe
 * Description:        WordPress Restaurant solution plugin to launch Restaurant Websites.
 * Version:            1.2.1
 * Author:             Themewinter
 * Author URI:         http://themewinter.com/
 * License:            GPL-2.0+
 * License URI:        http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:        wpcafe
 * Domain Path:       /languages
 */

defined( 'ABSPATH' ) || exit;

define( 'WPC_FILE', __FILE__ );
define( 'WPC_BASENAME', plugin_basename( WPC_FILE ) );

require_once plugin_dir_path( __FILE__ ) . '/plugin.php';
require_once plugin_dir_path( __FILE__ ) . '/utils/notice/notice.php';
require_once plugin_dir_path( __FILE__ ) . '/utils/banner/init.php';

// init notice class
\Oxaim\Libs\Notice::init();

// load plugin
add_action( 'plugins_loaded', function () {

    do_action( 'wpcafe/before_load' );

    // action plugin instance class
    \WpCafe\Plugin::instance()->init();

    do_action( 'wpcafe/after_load' );

}, 999 );
