<?php

use \WpCafe\Utils\Wpc_Utilities;

$col = ($show_thumbnail == 'yes') ? 'wpc-col-md-8' : 'wpc-col-md-12';
$class = ($title_link_show=='yes')? '' : 'wpc-no-link';

foreach ($products as $product) { 
    $permalink = ( $title_link_show == 'yes' ) ?  get_permalink($product->get_id()) : '#';
    ?>
    <div class="wpc-food-menu-item wpc-row">
        <!-- thumbnail -->
        <?php 
        if ( $show_thumbnail == 'yes' ) {

            if ($product->get_image()) { 
                ?>
                <div class="wpc-col-md-3">
                    <div class="wpc-food-menu-thumb">
                        <a href="<?php echo esc_url(get_permalink($product->get_id())); ?>" class="<?php echo esc_attr( $class ); ?>">
                            <?php echo Wpc_Utilities::wpc_kses( $product->get_image() ) ?>
                        </a>
                    </div>
                </div>
                <?php 
            } 
        }
        ?>
        <div class="wpc-col-md-9">
            <div class="wpc-food-inner-content">
                <!-- display tag -->
                <div class="wpc-menu-tag-wrap">
                    <?php
                        Wpc_Utilities::wpc_tag( $product->get_id() , $product->is_in_stock() );
                        $price = '';
                        if (wc_get_price_including_tax($product)) {
                            $price      = wc_get_price_including_tax($product);
                        } else {
                            $price = wc_get_price_excluding_tax($product);
                        }
                        ?>
                        <?php 
                        if ($show_item_status == 'yes' && $product->get_price_suffix() != '') { 
                            ?>
                            <ul class="wpc-menu-tag">
                                <li>
                                    <?php 
                                    if (wc_get_price_including_tax($product)) {
                                        // get percentage tax
                                        echo Wpc_Utilities::wpc_kses($product->get_price_suffix());
                                    } 
                                    ?>
                                </li>
                            </ul>
                            <?php 
                        } 
                    ?>
                </div>
                <h3 class="wpc-post-title">
                    <a href="<?php echo esc_url( $permalink ); ?>" class="<?php echo esc_attr( $class); ?>"><?php echo esc_html($product->get_name());  ?> </a>
                    <?php 
                    if( $product->get_type() !== 'variable' ) {
                        ?>
                        <span class="wpc-menu-currency"><?php echo Wpc_Utilities::wpc_render( get_woocommerce_currency_symbol() ); ?> <span class="wpc-menu-price"><?php echo esc_html($price); ?></span></span>
                        <?php 
                    } else { 
                        // variation price 
                        $variation_price = $product->get_variation_prices( true ); // true for getting tax price 
                        $var_price = '';
                        if( is_array( $variation_price ) && isset( $variation_price['price'] ) ){
                            $var_price = get_woocommerce_currency_symbol() . array_shift($variation_price['price']) ."-". get_woocommerce_currency_symbol() . array_pop($variation_price['price']);
                        }

                        ?>
                        <span class="wpc-menu-currency"><span class="wpc-menu-price"><?php echo esc_html($var_price); ?></span></span>
                        <?php 
                    } 
                    ?>
                </h3>
                <?php
                    if( $wpc_show_desc == 'yes' ){
                        echo  Wpc_Utilities::wpcafe_trim_words( get_the_excerpt($product->get_id() ), $wpc_desc_limit);
                    }
                    // cart button
                    echo  Wpc_Utilities::product_add_to_cart( $product, $wpc_cart_button, '', '', $widget_id );
                ?>
            </div>
        </div>
    </div>
    <?php 
}