<?php
namespace WpCafe;

defined( 'ABSPATH' ) || exit;

use WpCafe\Autoloader;
use WpCafe\Utils\Wpc_Utilities;

/**
 * Autoload all classes
 */
require_once plugin_dir_path( __FILE__ ) . '/autoloader.php';

final class Plugin{
    
    const version = '1.2.1';

    private static $instance;
    /**
     * Register action
     */
    private function __construct() {
        // load autoload method
        Autoloader::run();
    }

    public function init(){
        // activation and deactivation hook
        register_activation_hook( __FILE__, [$this, 'wpc_active'] );
        register_deactivation_hook( __FILE__, [$this, 'wpc_deactive'] );
        //enqueue file
        \WpCafe\Core\Enqueue\Wpc_Enqueue::instance()->init();
        // define constant
        $this->wpc_define_constants();
        // fire in every plugin load action
        $this->wpc_init_plugin();  
        
        //banner
        add_action('admin_head', function() {

            \Wpmet\Libs\Banner\Init::instance()
            ->set_text_domain('wp-cafe')
            // ->set_filter(ltrim($filter_string, ','))
            ->set_api_url('https://api.wpmet.com/public/jhanda/index.php')
            ->set_plugin_screens('toplevel_page_cafe_menu')
            ->set_plugin_screens('edit-wpc_reservation')
            ->call();

        });
    }

    /**
     * do stuff on active
     *
     * @return void
     */
    public function wpc_active() {
        $installed = get_option( 'wpc_cafe_installed' );

        if ( !$installed ) {
            update_option( 'wpc_cafe_installed', time() );
        }

        update_option( 'wpc_cafe_version', WPC_VERSION );
    }

    /**
     * do stuff on deactive
     *
     * @return void
     */
    public function wpc_deactive() {
        flush_rewrite_rules();
    }

    /**
     * Define all constance
     *
     * @return void
     */
    public function wpc_define_constants() {
        define( 'WPC_VERSION', self::version );
        define( 'WPC_PATH', plugin_dir_url( __FILE__ ) );
        define( 'WPC_DIR', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
        define( 'WPC_ASSETS', WPC_PATH . 'assets/' );
    }
    public static function instance()
    {
        if (!self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    /**
     * Load all class
     *
     * @return void
     */
    public function wpc_init_plugin() {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';

        if ( !is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
            add_action( 'admin_notices', [$this, 'wpc_admin_notice_woocommerce_not_active'] );
        }
        if ( !file_exists( WP_PLUGIN_DIR . '/wpcafe-pro/wpcafe-pro.php' ) ) {
            // add_action( 'admin_notices', [$this, 'admin_notice_wpcafe_pro_not_active'] );
            add_action( "admin_menu", [$this, "add_submenu_for_go_pro"], 11 );
        }

        //Plugins action page links
        add_filter( 'plugin_action_links_' . plugin_basename( WPC_FILE ), [$this, 'plugin_action_links'] );
        //Plugin Row Meta
        add_filter('plugin_row_meta', array($this, 'plugin_row_meta'), 10, 2);

        // call ajax submit
        if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
            \WpCafe\Core\Action\Wpc_Ajax_Action::instance()->init();
        }
        
        // load text domain 
        load_plugin_textdomain( 'wpcafe' );

        //make admin menu open if any custom post type is selected
        add_action( 'parent_file', [$this, 'wpc_keep_cpt_menu_open'] );

        //register all custom post type
        \WpCafe\Core\Post_type\Cpt::instance()->init();

        // register elementor
        \WpCafe\Widgets\Manifest::instance()->init();

        // resgiter widgets and shortcode
        $this->register_widgets();

        if ( is_admin() ){
            \WpCafe\Core::instance()->init();
        }
        
        //fire-up all woocommerce related hooks
        if( file_exists( WPC_DIR . '/core/woocommerce/hooks.php' )){
            include_once WPC_DIR . '/core/woocommerce/hooks.php';
        }
    }

    /**
     * Load on plugin
     *
     * @return void
     */
    public function wpc_admin_notice_woocommerce_not_active() {

        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }

        if ( file_exists( WP_PLUGIN_DIR . '/woocommerce/woocommerce.php' ) ) {
            $btn['label'] = esc_html__( 'Activate WooCommerce', 'wpcafe' );
            $btn['url']   = wp_nonce_url( 'plugins.php?action=activate&plugin=woocommerce/woocommerce.php&plugin_status=all&paged=1', 'activate-plugin_woocommerce/woocommerce.php' );
        } else {
            $btn['label'] = esc_html__( 'Install WooCommerce', 'wpcafe' );
            $btn['url']   = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=woocommerce' ), 'install-plugin_woocommerce' );
        }

        Wpc_Utilities::push(
            [
                'id'          => 'unsupported-woocommerce-version',
                'type'        => 'error',
                'dismissible' => true,
                'btn'         => $btn,
                'message'     => sprintf( esc_html__( 'WpCafe requires WooCommerce , which is currently NOT RUNNING.', 'wpcafe' ) ),
            ]
        );
    }

    

    public function admin_notice_wpcafe_pro_not_active() {
        $btn['label'] = esc_html__( 'Buy Pro', 'wpcafe' );
        $btn['url']   = 'https://themewinter.com/wp-cafe/';

        Wpc_Utilities::push(
            [
                'id'          => 'wpcafe-pro-notice',
                'type'        => 'error',
                'dismissible' => true,
                'btn'         => $btn,
                'message'     => sprintf( esc_html__( 'Unlock more features with the pro version', 'wpcafe' ) ),
            ]
        );
    }

    

    /**
     * Add admin submenu page for go-pro
     *
     * @return void
     */
    public function add_submenu_for_go_pro() {
        //add submenu page for go-pro
        add_submenu_page(
            'cafe_menu',
            __( 'Get Pro', 'wpcafe' ),
            __( '<span class="dashicons dashicons-star-filled wpc-icon-get-pro"></span> Get Pro', 'wpcafe' ),
            'edit_posts',
            'edit.php?page=wpc-get-pro',
            [$this, 'wpc_get_pro']
        );

    }

    /**
     * render go-pro markup
     *
     * @return void
     */
    public function wpc_get_pro() {
        //redirect to pro plugin
        $pro_url = add_query_arg( 'wpc-dashboard', '1', 'https://themewinter.com/wp-cafe/' );
        wp_redirect( $pro_url );
        exit();
    }

    public function plugin_action_links( $actions ) {
        if ( !file_exists( WP_PLUGIN_DIR . '/wpcafe-pro/wpcafe-pro.php' ) ) {
            $actions['wpc_pro_link'] = '<a href="https://themewinter.com/wp-cafe/" target="_blank"><span class="wpc-text-get-pro">' . __( 'Get Pro', 'wpcafe' ) . '</span></a>';
        }

        $actions['wpc_documentation'] = '<a href="https://support.themewinter.com/docs/plugins/docs-category/wp-cafe/" target="_blank">' . __( 'Documentation', 'wpcafe' ) . '</a>';
        return $actions;
    }
    

	public function plugin_row_meta($plugin_meta, $plugin_file){

        if( $plugin_file == WPC_BASENAME ){
            $plugin_meta[] = sprintf( '<a href="%s" target="_blank">%s</a>',
                esc_url( 'http://support.themewinter.com/support-center/' ),
                __( '<strong class="wpc-text-get-pro">Get Support</strong>', 'wpcafe' )
            );
            
        }

		return $plugin_meta;
	}

    /**
     * Register shortcode function
     *
     * @return void
     */
    public function register_widgets() {
        \WpCafe\Core\Widgets\Hook::instance()->init();
    }

    /**
     * Keep open menu function
     *
     */
    public function wpc_keep_cpt_menu_open( $parent_file ) {
        global $current_screen;
        $post_type = $current_screen->post_type;

        if ( $post_type == 'wpc_reservation' ) {
            wp_enqueue_script( 'wpc-active-custom-post-type', WPC_ASSETS . 'js/wpc-admin-menu.js', ['jquery'], self::version, false );
            $parent_file = 'cafe_menu';
        }

        return $parent_file;
    }

}