<?php
// party size loop

use WpCafe\Utils\Wpc_Utilities;

$wpc_min_guest_no    = isset($settings['wpc_min_guest_no']) ? $settings['wpc_min_guest_no'] : 1;
$wpc_max_guest_no    = isset($settings['wpc_max_guest_no']) ? $settings['wpc_max_guest_no'] : $seat_capacity;
$wpc_default_gest_no = isset($settings['wpc_default_gest_no']) ? $settings['wpc_default_gest_no'] : '';
$phone_required      = isset($settings['wpc_require_phone']) ? "required" : "";
$cancellation_option = '';

if ( isset($settings['wpc_allow_cancellation']) && $settings['wpc_allow_cancellation'] == 'off' ) {
    $cancellation_option .= "hide-cancel-text";
}


$wpc_image_url = WPC_ASSETS . 'images/wpc_reservation_image.jpeg';
if (is_array($atts) && isset($atts['wpc_image_url']) && $atts['wpc_image_url'] !== '') {
    $wpc_image_url = $atts['wpc_image_url'];
}
$reservation_arr = array(
    'wpc_check_name'        => 'Name :',
    'wpc_check_email'       => 'Email :',
    'wpc_check_phone'       => 'Phone :',
    'wpc_check_guest'       => 'Guest :',
    'wpc_check_start_time'  => 'Time :',
    'wpc_check_booking_date'=> 'Date :',
)
?>
<div class='wpc-reservation-form <?php echo esc_attr($cancellation_option) ?>' 
data-reservation_status='<?php echo json_encode( $booking_status ) ?>'>
    <div class='wpc_cancell_log_message'></div>
    <div class='wpc_error_message'></div>
    <div class='wpc_reservation_form_two' style='display:none;'>
        <div class='wpc_reservation_form_two'>
            <form method='post' class=' wpc_reservation_table'>
                <div class='wpc-reservation-form'>
                    <div class='wpc-row'>
                        <?php if ($view === "yes") { ?>
                            <div class='wpc-col-lg-6'>
                                <div class='wpc-reservation-field '>
                                    <img src='<?php echo esc_url($wpc_image_url) ?>' alt='wpc_reservation_image' />
                                </div>
                            </div>
                        <?php } ?>
                        <div class='<?php echo esc_attr($column_lg); ?>'>
                            <div class='wpc_reservation_form wpc_reservation_user_info'>
                                <ul>
                                    <?php foreach( $reservation_arr as $key => $value) : ?>
                                        <li> 
                                            <span class='wpc-user-field-info'><?php echo esc_html__( $value , 'wpcafe'); ?></span>
                                            <?php if ( $key == 'wpc_check_start_time' ) { ?>
                                            <span class='<?php echo esc_html($key) ?>'></span>  <?php echo ( $show_to_field == 'on' ) ?  "- <span class='wpc_check_end_time'></span>" : "" ?>
                                            <?php } else{ ?>
                                                    <span class='<?php echo esc_html($key) ?>'></span>
                                            <?php } ?>
                                        </li>
                                    <?php endforeach;?>
                                </ul>
                                <div class='wpc_log_message'></div>

                                <button class='confirm_booking_btn wpc-btn' data-id='reservation_form_second_step'><?php echo esc_html__('Confirm Booking', 'wpcafe'); ?></button>
                                <button class='edit_booking_btn wpc-btn' data-id='edit_booking_btn'><?php echo esc_html__('Edit Booking', 'wpcafe'); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <form method='post' class='wpc_reservation_table'>
        <input type='hidden' name='wpc_action' value='wpc_reservation' />
        <div class='wpc_reservation_form_one'>
            <div class='wpc-row'>
                <?php if ($view === "yes") { ?>
                    <div class='wpc-col-lg-6'>
                        <div class='wpc-reservation-field date'>
                            <input type='text' name='wpc_booking_date' class='wpc-form-control' id='wpc-booking-date' value='' required aria-required='true' />
                        </div>
                    </div>
                <?php } ?>
                <div class='<?php echo esc_attr($column_lg); ?>'>
                    <div class='wpc_reservation_form'>
                        <div class='wpc-row'>
                            <div class='wpc-col-md-6'>
                                <div class='wpc-reservation-field name'>
                                    <label for='wpc-name'><?php echo esc_html__('Name', 'wpcafe'); ?><small class='wpc_required'>*</small></label>
                                    <input type='text' name='wpc_name' id='wpc-name' class='wpc-form-control' value='' required aria-required='true'>
                                </div>
                            </div>
                            <div class='wpc-col-md-6'>
                                <div class='wpc-reservation-field email'>
                                    <label for='wpc-email'><?php echo esc_html__('Email', 'wpcafe'); ?><small class='wpc_required'>*</small></label>
                                    <input type='email' name='wpc_email' class='wpc-form-control' id='wpc-email' value='' required aria-required='true'>
                                </div>
                            </div>
                        </div>
                        <div class='wpc-row'>
                            <div class='<?php echo esc_attr($column_md) ?>'>
                                <div class='wpc-reservation-field phone'>
                                    <label for='wpc-phone'><?php echo esc_html__('Phone', 'wpcafe');
                                        echo ( $phone_required == "required" ) ? "<small class='wpc_required'>*</small>" : "" ?>
                                    </label>
                                    <input type='tel' <?php echo esc_attr($phone_required == "required" ? "required" : ""); ?> name='wpc_phone' class='wpc-form-control' id='wpc-phone' value=''>
                                </div>
                            </div>
                            <?php if ($view === "no") { ?>
                                <div class='wpc-col-lg-6'>
                                    <div class='wpc-reservation-field'>
                                        <label for='wpc-booking-date'><?php echo esc_html__('Date', 'wpcafe'); ?><small class='wpc_required'>*</small></label>
                                        <input type='text' name='wpc_booking_date' class='wpc-form-control' id='wpc-booking-date' value='' required aria-required='true' />
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <div class='wpc-row'>
                            <div class='<?php esc_attr_e( $from_to_column ) ;?>'>
                                <?php if( $show_form_field == 'on'): ?>
                                    <div class='wpc-reservation-field time'>
                                        <label for='wpc-from-time'><?php echo esc_html__( $from_field_label , 'wpcafe'); ?>
                                            <?php if ( $required_from_field == 'on') : ?>
                                                <small class='wpc_required'>*</small>
                                            <?php endif; ?> 
                                         </label>
                                        <input type='text' name='wpc_from_time' class='wpc-form-control' id='wpc-from-time' value='' <?php echo ( $required_from_field == 'on' ) ? 'required aria-required="true"' : '' ?>  >
                                    </div>
                                <?php endif;?>
                            </div>
                            <div class='<?php esc_attr_e( $from_to_column ) ;?>'>
                                <?php if( $show_to_field == 'on' ): ?>
                                    <div class='wpc-reservation-field time'>
                                        <label for='wpc-to-time'><?php echo esc_html__( $to_field_label , 'wpcafe'); ?>
                                            <?php if ( $required_to_field == 'on') : ?>
                                                <small class='wpc_required'>*</small>
                                            <?php endif; ?>
                                         </label>
                                        <input type='text' name='wpc_to_time' class='wpc-form-control' id='wpc-to-time' value='' <?php echo ( $required_to_field == 'on' ) ? 'required aria-required="true"' : '' ?>>
                                    </div>
                                <?php endif;?>
                            </div>
                        </div>
                        <div class='wpc-select party wpc-reservation-field'>
                            <label for='wpc-total-guest'><?php echo esc_html__('Total Guest ', 'wpcafe'); ?><small class='wpc_required'>*</small></label>
                            <select name='wpc_guest_count' id='wpc-party' class='wpc-form-control' required aria-required='true'>
                                <option value=""><?php echo esc_html__("Select no of geuests","wpcafe")?></option>
                                <?php
                                for ($i = $wpc_min_guest_no; $i <= $wpc_max_guest_no; $i++) {
                                    $selected = ($wpc_default_gest_no == $i) ? "selected" : ""; ?>
                                    <option value='<?php echo esc_attr( $i ); ?>' <?php echo esc_attr( $selected ); ?>><?php echo esc_html( $i ); ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class='wpc-reservation-fieldarea message wpc-reservation-field'>
                            <label for='wpc-message'><?php echo esc_html__('Note', 'wpcafe'); ?></label>
                            <textarea name='wpc_message' id='wpc-message' class='wpc-form-control'></textarea>
                        </div>
                        <?php
                            // render extra field
                            if( is_array($result_data) && isset( $result_data['reservation_extra_field']) ):
                                echo Wpc_Utilities::wpc_kses($result_data['reservation_extra_field']);
                            endif;
                        ?>
                        <input type='hidden' value='reservation_form_first_step' class='reservation_form_first_step' />
                        <button type='submit' class='reservation_form_submit wpc-btn'><?php echo esc_html__( $booking_button_text , 'wpcafe' ); ?></button>
                        <span id='wpc_cancel_request'><?php echo esc_html__( $cancell_button_text ,'wpcafe'); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

