<?php
namespace WpCafe\Core\Template;

defined( "ABSPATH" ) || exit;

use WpCafe\Utils\Wpc_Utilities;


class Wpc_Key_Options {
    
    use \WpCafe\Traits\Wpc_Singleton;
    
    public $wpc_settings_field;

    /**
     * Settings field
     *
     * @return void
     */
    public function wpc_key_options() {
        if (isset($_GET['action']) && sanitize_text_field($_GET['action']) == 'reservation_details') {
            apply_filters('wpcafe/key_options/reservation_details','wpc_pro_reservation_details');
        } else {
            ?>
            <div class="wrap wpc-settings">
                <h1 class="wpc-settings-title"><?php echo esc_html__('Settings', 'wpcafe' ) ?></h1>
                <?php
                    settings_errors();
                    $visit          = esc_html__('Visit', 'wpcafe');
                    $documentation  = esc_html__('Documentation', 'wpcafe');
                    $schedule_text  = esc_html__('reservation settings section for reservation schedule of your restaurant.', 'wpcafe');
                    $menu_text      = esc_html__(' for food menu options of your restaurant.', 'wpcafe');
                    $sched_doc_link = Wpc_Utilities::wpc_kses( '<a href="https://support.themewinter.com/docs/plugins/docs/general-settings-2/" target="_blank" class="doc-link">'. $documentation .'</a> ' );
                    $fmenu_doc_link = Wpc_Utilities::wpc_kses( '<a href="https://support.themewinter.com/docs/plugins/docs/food-menu/" target="_blank" class="doc-link"> '. $documentation .'</a> ' );
                    // show tab
                    $settings_tabs = array(
                        'key_options'   => [esc_html__('Key options', 'wpcafe'),esc_html__('( For reservation )', 'wpcafe')], 
                        'schedule'      => [esc_html__('Reservation schedule', 'wpcafe'),esc_html__('( For reservation )', 'wpcafe')], 
                        'notification'  => [esc_html__('Notifications', 'wpcafe'),esc_html__('( For reservation )', 'wpcafe')], 
                        'menu_settings' => [esc_html__('Menu settings', 'wpcafe'),esc_html__('( For food menu )', 'wpcafe')],
                        'hooks'         => [esc_html__('Available Shortcode', 'wpcafe'),esc_html__('( General )', 'wpcafe')],
                        );
                    $wpc_doc_link = array(
                        'schedule'      => $visit .' '.$sched_doc_link .' '. $schedule_text .'',
                        'menu_settings' => $visit .' '.$fmenu_doc_link .' '. $menu_text .'',
                    );
                    $tab_arr = [ $settings_tabs , $wpc_doc_link ];
                    ?>
                    <ul class="nav nav-tabs wpc-tab">
                        <?php
                            $filterd_tab = apply_filters('wpcafe/key_options/settings_tab_item', $tab_arr );
                            if( isset( $filterd_tab['settings_tab']) ){
                                $tabs = $filterd_tab['settings_tab'][0];
                                $wpc_doc_link = $filterd_tab['settings_tab'][1];
                            }else{
                                $tabs = $tab_arr[0];
                            }

                            $i=0;
                            foreach ($tabs as $key => $value){
                                $i++
                                ?>
                                    <li>
                                        <a href="#" class="nav-tab <?php echo Wpc_Utilities::wpc_numeric($i) == 1  ? 'nav-tab-active': '';?>" data-id="<?php echo Wpc_Utilities::wpc_numeric($key) ?>">
                                            <i class="wpcafe-icon<?php echo Wpc_Utilities::wpc_numeric($i);?>"></i>
                                            <span><?php esc_html_e( $value[0] , 'wpcafe'  ); ?></span>
                                            <small><?php esc_html_e( $value[1] , 'wpcafe'  )?></small>
                                        </a>
                                    </li>
                                <?php
                            }
                        ?>
                    </ul>
                    <div class="tab-content settings-content-wraps">
                        <?php
                            $week_days = ['Sat','Sun','Mon','Tue','Wed','Thu','Fri'];

                            $sample_date = strtotime('January 15 ' . date('Y'));
                            $date_options         = [
                                'yy-m-d' => date('Y-m-d', $sample_date),
                                'yy/m/d' => date('y/m/d', $sample_date),
                                'm/d/yy' => date('m/d/Y', $sample_date),
                                'dd/m/yy'=> date('j/n/Y', $sample_date),
                                'd/m/yy' => date('d/m/Y', $sample_date),
                                'd-m-yy' => date('n-j-Y', $sample_date),
                                'm-d-yy' => date('m-d-Y', $sample_date),
                                'd-m-yy' => date('d-m-Y', $sample_date),
                                'yy.m.d' => date('Y.m.d', $sample_date),
                                'm.d.y'  => date('m.d.Y', $sample_date),
                                'd.m.yy' => date('d.m.Y', $sample_date),
                            ];
                            $settings                                     =  \WpCafe\Core\Base\Wpc_Settings_Field::instance()->get_settings_option();
                            $get_data = apply_filters('wpcafe/key_options/menu_settings', $settings);

                            $wpc_reservation_form_display_page            =  (isset($settings['wpc_reservation_form_display_page'] ) ?  $settings['wpc_reservation_form_display_page'] : '');
                            $wpcafe_food_location                         =  isset($settings['wpcafe_food_location']) ? "checked" : "";
                            $wpcafe_allow_cart                            =  (! isset($settings['wpcafe_allow_cart'] ) || isset($settings['wpcafe_allow_cart'] ) && $settings['wpcafe_allow_cart'] == 'on' ) ? 'on' : 'off';
                            $wpc_checked_allow_cancellation               =  (! isset($settings['wpc_allow_cancellation'] ) || isset($settings['wpc_allow_cancellation'] ) && $settings['wpc_allow_cancellation'] == 'on' ) ? 'on' : 'off';
                            $checked_require_phone                        =  (isset($settings['wpc_require_phone']) ? "checked" : "");
                            
                            $allow_admin_notif_book_req                   =  (! isset($settings['wpc_admin_notification_for_booking_req'] ) || isset($settings['wpc_admin_notification_for_booking_req'] ) && $settings['wpc_admin_notification_for_booking_req'] == 'on' )  ? 'on' : 'off';
                            $allow_user_notif_book_req                    =  (! isset($settings['wpc_user_notification_for_booking_req'] ) || isset($settings['wpc_user_notification_for_booking_req'] ) && $settings['wpc_user_notification_for_booking_req'] == 'on' )  ? 'on' : 'off';
                            
                            $admin_notif_confirm_book                     =  (isset($get_data['notification_settings']['admin_notif_confirm_book']) ? $get_data['notification_settings']['admin_notif_confirm_book'] : 'off');
                            $user_notif_confirm_book                      =  (isset($get_data['notification_settings']['user_notif_confirm_book']) ? $get_data['notification_settings']['user_notif_confirm_book'] : 'off');
                            
                            $admin_notif_cancel_req                       =  (isset($get_data['notification_settings']['admin_notif_cancel_req']) ? $get_data['notification_settings']['admin_notif_cancel_req'] : 'off');
                            $user_notif_cancel_req                        =  (isset($get_data['notification_settings']['user_notif_cancel_req']) ? $get_data['notification_settings']['user_notif_cancel_req'] : 'off');
                            
                            $wpc_booking_confirmed =  esc_html__('Thank you for  booking. Your booking is confirmed.Please check your email to get invoice no.','wpcafe');
                            $wpc_booking_confirmed_message = $wpc_booking_confirmed;
                            $wpc_pending = esc_html__('Thank you for  booking. Your booking is pending. Please check your email to get invoice no.','wpcafe');
                            $wpc_pending_message = $wpc_pending;
                            if ( isset($settings['wpc_pending_message'])) {
                                if ($settings['wpc_pending_message'] == '') {
                                    $wpc_pending_message = $wpc_pending;
                                }else {
                                    $wpc_pending_message = $settings['wpc_pending_message'];
                                }
                            }

                            if ( isset($settings['wpc_booking_confirmed_message'])) {
                                if ($settings['wpc_booking_confirmed_message'] == '') {
                                    $wpc_booking_confirmed_message = $wpc_booking_confirmed;
                                }else {
                                    $wpc_booking_confirmed_message = $settings['wpc_booking_confirmed_message'];
                                }
                            }
                        ?> 
                        <form method='post' class='wpc_pb_two wpc_tab_content' id='wpc_settings_form' >
                        <?php 
                            foreach ($tabs as $item => $content) {
                                $active_class = (  ( $item == array_keys($tabs)[0] ) ? 'active' : ' ' );
                                if ( in_array( $item, array_keys( $settings_tabs ) ) ) {
                                ?>
                                <div id='<?php echo esc_attr( $item );?>' data-id='tab_<?php echo esc_attr( $item ); ?>' class='tab-pane <?php echo esc_attr( $active_class );?>'>
                                <?php
                                    if ( isset( $wpc_doc_link[$item] ) ) { ?>
                                         <!-- documentation link -->
                                        <div class="mb-2"><?php echo Wpc_Utilities::wpc_kses( $wpc_doc_link[$item] ); ?></div>
                                        <?php
                                    }
                                    //Schedule
                                    if ( $item == 'schedule' ) {
                                        ?>
                                            <h3 class="wpc-tab-title"><?php esc_html_e('Schedule options', 'wpcafe'  ); ?></h3>
                                            <div class="wpc-label-item">
                                                <?php
                                                    // render reservation schedule settings
                                                    if( isset( $get_data['reservation_schedule'])){
                                                        echo Wpc_Utilities::wpc_render( $get_data['reservation_schedule'] );
                                                    }
                                                ?>
                                                <div class="single_schedule">
                                                    <div class="wpc-label">
                                                        <label for="wpc_schedule" class="wpc-settings-label"><?php esc_html_e('Schedule', 'wpcafe'  ); ?></label>
                                                        <p class="wpc-desc"> <?php esc_html_e("Set opening and closing schedule of your restaurant", 'wpcafe'); ?> </p>
                                                    </div>
                                                    <div class="wpc-meta">
                                                    
                                                        <div class="schedule_main_block">
                                                            <h5 class="wpc_pb_two"><?php esc_html_e('Weekly (set opening and closing schedule for each day of a week seperately)', 'wpcafe'  ); ?></h5>
                                                            <?php
                                                            $wpc_schedule['wpc_weekly_schedule'] = isset( $settings['wpc_weekly_schedule'] ) ? $settings['wpc_weekly_schedule'] : [];
                                                            $wpc_schedule['wpc_weekly_schedule_start_time'] = isset( $settings['wpc_weekly_schedule_start_time'] ) ? $settings['wpc_weekly_schedule_start_time'] : [];
                                                            $wpc_schedule['wpc_weekly_schedule_end_time']   = isset( $settings['wpc_weekly_schedule_end_time'] ) ? $settings['wpc_weekly_schedule_end_time'] : [];
                                                            
                                                            if( is_array($wpc_schedule['wpc_weekly_schedule']) && count($wpc_schedule['wpc_weekly_schedule']) >0 ){
                                                                for ( $index=0; $index < count( $wpc_schedule['wpc_weekly_schedule'] ) ; $index ++) { ?>
                                                                    <div class="schedule_block week_schedule_wrap">
                                                                        <div class="wpc-weekly-schedule-list">
                                                                            <?php foreach ($week_days as $key => $value) { ?>
                                                                                <input type="checkbox" name="wpc_weekly_schedule[<?php echo intval($index)?>][<?php echo esc_html($value);?>]" 
                                                                                class="<?php echo esc_html(strtolower($value));?>" id="<?php echo esc_html(strtolower($value).intval($index));?>"
                                                                                <?php echo isset( $wpc_schedule['wpc_weekly_schedule'][$index][$value] ) ? 'checked' : ''?>
                                                                                /><label for="<?php echo esc_html(strtolower($value).intval($index));?>"><?php echo esc_html__($value, "wpcafe" ); ?></label>
                                                                            <?php } ?>
                                                                        </div>
                                                                        <div class="schedule_block wpc-schedule-field">
                                                                            <input type="text"  name="wpc_weekly_schedule_start_time[]" value="<?php echo Wpc_Utilities::wpc_render( $wpc_schedule['wpc_weekly_schedule_start_time'][ $index ] ); ?>" class="wpc_weekly_schedule_start_time wpc_weekly_schedule_start_time_<?php echo Wpc_Utilities::wpc_numeric($index) ?> ml-2 mr-1 wpc-settings-input attr-form-control" id="<?php echo intval($index);?>" placeholder="<?php echo esc_html__("Start time" , 'wpcafe' ); ?>"/>
                                                                            <input type="text"  name="wpc_weekly_schedule_end_time[]"   value="<?php echo Wpc_Utilities::wpc_render( $wpc_schedule['wpc_weekly_schedule_end_time'][ $index ] ); ?>" class="wpc_weekly_schedule_end_time wpc_weekly_schedule_end_time_<?php echo Wpc_Utilities::wpc_numeric($index) ?> ml-2 wpc-settings-input attr-form-control" id="<?php echo intval($index);?>" placeholder="<?php echo esc_html__("End time", 'wpcafe' ); ?>"/>
                                                                            <div class="wpc_weekly_clear" id="<?php echo Wpc_Utilities::wpc_numeric($index) ?>" ><?php echo esc_html__("clear", 'wpcafe' ); ?></div>                                                                     
                                                                        </div>
                                                                        <?php if( $index != 0 ) { ?>
                                                                        <span class="dashicons wpc-btn dashicons dashicons-no-alt remove_reserve_extra_field pl-1"></span>
                                                                        <?php } ?>
                                                                    </div>
                                                                    <?php
                                                                }
                                                            }
                                                            else {
                                                            ?>
                                                                <div class="schedule_block week_schedule_wrap">
                                                                    <div class="wpc-weekly-schedule-list">
                                                                    <?php foreach ($week_days as $key => $value) { ?>
                                                                            <input type="checkbox" name="wpc_weekly_schedule[0][<?php echo esc_html($value);?>]" 
                                                                            class="<?php echo esc_html(strtolower($value));?>" id="schedule_<?php echo esc_html(strtolower($value));?>"
                                                                            /><label for="schedule_<?php echo esc_html(strtolower($value));?>"><?php echo esc_html__($value, "wpcafe" ); ?></label>
                                                                    <?php } ?>
                                                                    </div>
                                                                    <div class="wpc-schedule-field">
                                                                        <input type="text" name="wpc_weekly_schedule_start_time[]" class="wpc_weekly_schedule_start_time wpc_weekly_schedule_start_time_0 mr-1 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__('Start time', 'wpcafe' ); ?>"/>
                                                                        <input type="text" name="wpc_weekly_schedule_end_time[]" class="wpc_weekly_schedule_end_time wpc_weekly_schedule_end_time_0 wpc-settings-input attr-form-control"  placeholder="<?php echo esc_html__('End time', 'wpcafe' ); ?>"/>
                                                                        <div class="wpc_weekly_clear" id="0" ><?php echo esc_html__("clear", 'wpcafe' ); ?></div>  
                                                                    </div>
                                                                </div>
                                                            <?php
                                                            }
                                                            ?>
                                                        </div>
                                                        <div class="wpc_flex_reverse wpc-weekly-schedule-btn">
                                                            <span class="add_schedule_block wpc-btn" data-start_time="<?php echo esc_html__('Start time', 'wpcafe' ); ?>" data-end_time="<?php echo esc_html__('End time', 'wpcafe' ); ?>">
                                                                    <i class="dashicons icon_cursor text-right dashicons-plus-alt  pl-1"></i>
                                                            </span>
                                                        </div>
                                                        <div class="wpc-all-day-schedule">
                                                            <h5 class="wpc_pb_two"><?php esc_html_e('All day (set opening and closing schedule for all days of a week)', 'wpcafe'  ); ?></h5>  
                                                            <div class="wpc-schedule-field">
                                                                <input type="text" name="wpc_all_day_start_time" value="<?php echo esc_attr( isset($settings['wpc_all_day_start_time'] ) ? $settings['wpc_all_day_start_time'] : ''); ?>"
                                                                class="wpc_all_day_start mb-1 wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__('Start time', 'wpcafe' ); ?>" />
                                                                <input type="text" name="wpc_all_day_end_time" value="<?php echo esc_attr( isset($settings['wpc_all_day_end_time'] ) ? $settings['wpc_all_day_end_time'] : ''); ?>" 
                                                                class="wpc_all_day_end wpc-settings-input attr-form-control" placeholder="<?php echo esc_html__('End time', 'wpcafe' ); ?>"/> 
                                                                <div class="wpc_all_day_clear"><?php echo esc_html__("clear", 'wpcafe' ); ?></div> 
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="wpc-label-item wpc-shcedule-event-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_exceptions"><?php esc_html_e('Exceptions', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Set opening and closing schedule for any special day", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta exception_section">
                                                    <div class="exception_main_block">
                                                        <?php
                                                        $wpc_exception['wpc_exception_date']       = isset( $settings['wpc_exception_date'] ) ? $settings['wpc_exception_date'] : [];
                                                        $wpc_exception['wpc_exception_start_time'] = isset( $settings['wpc_exception_start_time'] ) ? $settings['wpc_exception_start_time'] : [];
                                                        $wpc_exception['wpc_exception_end_time']   = isset( $settings['wpc_exception_end_time'] ) ? $settings['wpc_exception_end_time'] : [];
                                                        if( is_array( $wpc_exception['wpc_exception_date'] ) && count($wpc_exception['wpc_exception_date']) > 0 && $wpc_exception['wpc_exception_date']['0'] !== ''){
                                                            for ( $index=0; $index < count( $wpc_exception['wpc_exception_date'] ) ; $index ++) {
                                                                ?>
                                                                <div class="exception_block d-flex mb-2">
                                                                    <input type="text" name="wpc_exception_date[]" value="<?php echo Wpc_Utilities::wpc_render( $wpc_exception['wpc_exception_date'][ $index ] ); ?>" class="wpc_exception_date mr-1 wpc-settings-input attr-form-control" id="exception_date_<?php echo Wpc_Utilities::wpc_render( $index )?>" placeholder="<?php esc_html_e('Date', 'wpcafe' ); ?>" />
                                                                    <input type="text" name="wpc_exception_start_time[]" value="<?php echo Wpc_Utilities::wpc_render( $wpc_exception['wpc_exception_start_time'][ $index ] ); ?>" class="wpc_exception_start_time wpc_exception_start_time_<?php echo intval( $index )?> mr-1 wpc-settings-input attr-form-control" id="exception_start_time_<?php echo intval( $index ) ?>"  placeholder="<?php esc_html_e('Start time', 'wpcafe' ); ?>" />
                                                                    <input type="text"  name="wpc_exception_end_time[]" value="<?php echo Wpc_Utilities::wpc_render( $wpc_exception['wpc_exception_end_time'][ $index ] ); ?>" class="wpc_exception_end_time wpc_exception_end_time_<?php echo intval( $index )?> wpc-settings-input attr-form-control" id="exception_end_time_<?php echo intval( $index ) ?>"  placeholder="<?php esc_html_e('End time', 'wpcafe' ); ?>"/>
                                                                    <div class="exception_time_clear" id="<?php echo intval( $index )?>" ><?php echo esc_html__("clear", 'wpcafe' ); ?></div>
                                                                    <?php if( $index != 0 ) { ?>
                                                                        <span class="wpc-btn dashicons dashicons-no-alt remove_exception_block wpc_icon_middle_position"></span>
                                                                    <?php } ?>
                                                                </div>
                                                                <?php
                                                            }
                                                        }
                                                        else {
                                                        ?>
                                                            <div class="exception_block d-flex mb-2">
                                                                <input type="text" name="wpc_exception_date[]" value="" class="wpc_exception_date mr-1 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e('Date', 'wpcafe'  )?>" />
                                                                <input type="text" name="wpc_exception_start_time[]" value="" class="wpc_exception_start_time wpc_exception_start_time_0 mr-1 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e('Start time', 'wpcafe'  )?>" />
                                                                <input type="text" name="wpc_exception_end_time[]" value="" class="wpc_exception_end_time wpc_exception_end_time_0 wpc-settings-input attr-form-control" placeholder="<?php esc_html_e('End time', 'wpcafe'  )?>"/>
                                                                <div class="exception_time_clear" id="0" ><?php echo esc_html__("clear", 'wpcafe' ); ?></div>
                                                            </div>
                                                        <?php
                                                        }
                                                        ?>
                                                    </div>
                                                    <div class="wpc_flex_reverse">
                                                        <span class="add_exception_block wpc-btn" data-start_time="<?php echo esc_html__('Start time', 'wpcafe' ); ?>" data-end_time="<?php echo esc_html__('End time', 'wpcafe' ); ?>">
                                                            <i class="dashicons icon_cursor text-right dashicons-plus-alt  pl-1"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_early_bookings"><?php esc_html_e('Early bookings', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Set time limit for early booking. user can not pre-book before the defined time", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <select id="wpc_early_bookings" class="wpc-settings-input" name="wpc_early_bookings">
                                                        <?php
                                                        $wpc_early_bookings= array( 
                                                            'any_time'     => esc_html__( 'Any time', 'wpcafe'   ),
                                                            '1day'         => esc_html__( 'From 1 day advance', 'wpcafe'   ),
                                                            '1week'        => esc_html__( 'From 1 week advance', 'wpcafe'   ),
                                                            '1month'       => esc_html__( 'From 1 month advance', 'wpcafe'   ),
                                                            );
                                                            foreach( $wpc_early_bookings as $key => $value ) { ?>
                                                                <option <?php selected( $settings['wpc_early_bookings'] , $key , true ); ?> value='<?php echo esc_attr( $key ); ?>'><?php echo esc_html( $value ); ?></option>
                                                            <?php }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_late_bookings"><?php esc_html_e('Late bookings', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Set time limit for late booking. user can not pre-book after the defined time", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <select id="wpc_late_bookings" class="wpc-settings-input" name="wpc_late_bookings">
                                                        <?php
                                                        $wpc_late_bookings= array( 
                                                            '1'       => esc_html__( 'Up to the last minute', 'wpcafe'   ),
                                                            '15'      => esc_html__( 'Atleast 15 minutes in advance', 'wpcafe'   ),
                                                            '30'      => esc_html__( 'Atleast 30 minutes in advance', 'wpcafe'   ),
                                                            '45'      => esc_html__( 'Atleast 45 minutes in advance', 'wpcafe'   ),
                                                            );
                                                            foreach( $wpc_late_bookings as $key => $value ) { ?>
                                                                <option <?php selected( $settings['wpc_late_bookings'] , $key , true ); ?> value='<?php echo esc_attr( $key ); ?>'><?php echo esc_html( $value ); ?></option>
                                                            <?php }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                        <?php
                                    }
                                    // Key options
                                    elseif ( $item == 'key_options' ) {
                                        ?>
                                            <h3 class="wpc-tab-title"><?php esc_html_e('General Option', 'wpcafe'  ); ?></h3>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="reservation_form_display_page"><?php esc_html_e('Display pages', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Display reservation form only in the selected page", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <select disabled id="reservation_form_display_page" class="wpc-settings-input" name="wpc_reservation_form_display_page">
                                                        <option><?php echo esc_html__("Select a page",'wpcafe' )?></option>
                                                        <?php
                                                         foreach ( get_pages() as $key => $value ) { ?>
                                                            <option <?php selected( $wpc_reservation_form_display_page , $value->ID , true ); ?> value='<?php echo esc_attr($value->ID); ?>'> <?php echo esc_html( $value->post_title ); ?> </option>
                                                        <?php }
                                                        ?>
                                                    </select>
                                                    <span class="wpc-pro-text"> <?php esc_html_e('pro version only', 'wpcafe'  ); ?></span>
                                                </div>
                                            </div>
                                            <?php
                                                // render key settings
                                                if( isset( $get_data['key_options'])){
                                                    echo Wpc_Utilities::wpc_render( $get_data['key_options'] );
                                                }
                                            ?>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_default_gest_no"><?php esc_html_e('Automatically confirmed guest no', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e('Confirmed a reservation if no. of guests is the selected number. This no. must be between minimum and maximum guest no.', 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <select id="wpc_default_gest_no" class="wpc-settings-input" name="wpc_default_gest_no">
                                                        <option value=""><?php echo esc_html__("Select no. of guests",  'wpcafe'  )?></option>
                                                        <?php
                                                        $data = Wpc_Utilities::multi_schedule_time_seat( $settings );
                                                        if( is_array($data) && count($data)>0){
                                                            $wpc_no_range = $data['wpc_no_range'];
                                                        }
                                                        $default_geust_no = isset( $settings['wpc_default_gest_no'] ) && $settings['wpc_default_gest_no'] !== '' ? $settings['wpc_default_gest_no'] : 4;
                                                        for( $i = 1 ; $i <= $wpc_no_range ; $i++ ) { ?>
                                                            <option <?php selected( $default_geust_no , $i , true ); ?> value='<?php echo esc_attr($i); ?>'><?php echo esc_html( $i ); ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_min_guest_no"><?php esc_html_e('Min guest no.', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("No. of minimum allowed guest for a single reservation", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <select id="wpc_min_guest_no" class="wpc-settings-input" name="wpc_min_guest_no">
                                                        <option value=""><?php echo esc_html__("Select no. of guests",  'wpcafe'  )?></option>
                                                        <?php
                                                        $min_geust_no = isset( $settings['wpc_min_guest_no'] ) && $settings['wpc_min_guest_no'] !== '' ? $settings['wpc_min_guest_no'] : 1;
                                                        for( $i = 1 ; $i <= $wpc_no_range ; $i++ ) { ?>
                                                            <option <?php selected( $min_geust_no , $i , true ); ?> value='<?php echo esc_attr($i); ?>'> <?php echo esc_html( $i ); ?> </option>
                                                        <?php }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_max_guest_no"><?php esc_html_e('Max guest no.', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("No. of maximum allowed guest for a single reservation", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <select id="wpc_max_guest_no" class="wpc-settings-input" name="wpc_max_guest_no">
                                                    <option value=""><?php echo esc_html__("Select no. of guests",  'wpcafe'  )?></option>
                                                        <?php
                                                        $max_geust_no = isset( $settings['wpc_max_guest_no'] ) && $settings['wpc_max_guest_no'] !== '' ? $settings['wpc_max_guest_no'] : $wpc_no_range;
                                                        for( $i = 1 ; $i <= $wpc_no_range ; $i++ ) { ?>
                                                            <option <?php selected( $max_geust_no , $i  ); ?> value='<?php echo esc_attr($i); ?>'> <?php echo esc_html( $i ); ?> </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_allow_cancellation"><?php esc_html_e('Allow Cancellations', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Allow user to cancelled reservation through cancellation form", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input name="wpc_allow_cancellation" class="hide_field" type="checkbox" value="off" <?php echo esc_attr( $wpc_checked_allow_cancellation == 'off' ? 'checked' : ''  ); ?> />
                                                    <input id='wpc_allow_cancellation' type="checkbox" <?php echo esc_attr( $wpc_checked_allow_cancellation == 'on' ? 'checked' : ''  ); ?> class="wpcafe-admin-control-input"
                                                    name="wpc_allow_cancellation"/>
                                                    <label for="wpc_allow_cancellation" class="wpcafe_switch_button_label"></label>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="require_phone"><?php esc_html_e('Require phone', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Make phone / contact no. required while placing reservation", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                <input id='require_phone' type="checkbox" 
                                                    <?php echo esc_attr( $checked_require_phone ); ?> 
                                                    class="wpcafe-admin-control-input "
                                                    name="wpc_require_phone" />
                                                    <label for="require_phone" class="wpcafe_switch_button_label"></label>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="pending_message"><?php esc_html_e('Pending message', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Message which will be shown when a user successfully places a reservation", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <textarea id="pending_message" class="wpc-settings-input wpc-msg-box" name="wpc_pending_message" rows="7" cols="30"><?php echo esc_html( $wpc_pending_message );?></textarea>    
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="confirm_message"><?php esc_html_e('Reservation confirmed message', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Message which will be shown when a user's reservation is confirmed", 'wpcafe'); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <textarea id="confirm_message" class="wpc-settings-input wpc-msg-box" name="wpc_booking_confirmed_message" rows="7" cols="30"><?php echo esc_html( $wpc_booking_confirmed_message ) ?></textarea>    
                                                </div>
                                            </div>
                                
                                            <h3 class="wpc-tab-title"><?php esc_html_e('Booking Form', 'wpcafe'  ); ?></h3>  
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_date_format"><?php esc_html_e('Date format', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Date format of reservation form", 'wpcafe' ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <select id="wpc_date_format" name="wpc_date_format" class="wpc-settings-input">
                                                        <?php
                                                        foreach ( $date_options as $key => $date_option ) { ?>
                                                            <option <?php selected($settings["wpc_date_format"], $key, true); ?> value='<?php echo esc_attr( $key ); ?>'> <?php echo esc_html( $date_option ); ?> </option>
                                                        <?php }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>    
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_time_format"><?php esc_html_e('Time format', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Time format of reservation form", 'wpcafe' ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <select id="wpc_time_format" name="wpc_time_format" class="wpc-settings-input">
                                                        <option value="24" <?php selected($settings['wpc_time_format'], '24', true); ?>><?php echo esc_html('24h'); ?></option>
                                                        <option value="12" <?php selected($settings['wpc_time_format'], '12', true); ?>><?php echo esc_html('12h'); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <?php
                                                // render reservation form settings settings
                                                if( isset( $get_data['reservation_form_settings'])){
                                                    echo Wpc_Utilities::wpc_render( $get_data['reservation_form_settings'] );
                                                }
                                    }
                                    //Notification
                                    elseif ( $item == 'notification' ) {
                                        ?>
                                            <h3 class="wpc-tab-title"><?php esc_html_e('Notification', 'wpcafe'  ); ?></h3>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="sender_email"><?php esc_html_e('Sender email address', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Mail will be sent both admin and user from this email address", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="text" class="wpc-settings-input" name="sender_email_address" id="sender_email"
                                                        value="<?php echo esc_attr( isset($settings['sender_email_address'] ) && $settings['sender_email_address'] !== '' ? $settings['sender_email_address'] : wp_get_current_user()->data->user_email ); ?>"
                                                        placeholder="<?php echo esc_attr(wp_get_current_user()->data->user_email) ?>" />
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_reply_to_name"><?php esc_html_e('Reply-To Name', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Set the 'reply-to' name that will be shown on email sent to user", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="text" class="wpc-settings-input" name="wpc_reply_to_name" id="wpc_reply_to_name"
                                                        value="<?php echo esc_attr( isset($settings['wpc_reply_to_name'] ) && $settings['wpc_reply_to_name'] !== '' ? $settings['wpc_reply_to_name'] : wp_get_current_user()->data->display_name ); ?>"
                                                        placeholder="<?php echo esc_attr(wp_get_current_user()->data->display_name)?>" />
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_email_address"><?php esc_html_e('Admin email address', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Set the admin-email address to use in email.If sender email address is not set, mail will be sent both admin and user from this address", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="email" class="wpc-settings-input" name="wpc_admin_email_address" id="wpc_admin_email_address"
                                                        value="<?php echo esc_attr( isset($settings['wpc_admin_email_address'] )  ? $settings['wpc_admin_email_address'] : "" ); ?>" />
                                                </div>
                                            </div> 
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_notification_for_booking_req"><?php esc_html_e('Admin notification for new booking', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Send email to admin when a new reservation arrives", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                <input name="wpc_admin_notification_for_booking_req" class="hide_field" type="checkbox" value="off" <?php echo esc_attr( $allow_admin_notif_book_req == 'off' ? 'checked' : '' ); ?> />
                                                <input id="wpc_admin_notification_for_booking_req" type="checkbox" <?php echo esc_attr( $allow_admin_notif_book_req == 'on' ? 'checked' : '' ); ?> class="wpcafe-admin-control-input"
                                                    name="wpc_admin_notification_for_booking_req" />
                                                <label for="wpc_admin_notification_for_booking_req" class="wpcafe_switch_button_label"></label>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_user_notification_for_booking_req"><?php esc_html_e('Notify user about new booking request', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Send email to user after placing a reservation successfully", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                <input name="wpc_user_notification_for_booking_req" class="hide_field" type="checkbox" value="off" <?php echo esc_attr( $allow_user_notif_book_req == 'off' ? 'checked' : ''  ); ?>>
                                                <input id="wpc_user_notification_for_booking_req" type="checkbox" <?php echo esc_attr( $allow_user_notif_book_req == 'on' ? 'checked' : ''  ); ?> class="wpcafe-admin-control-input"
                                                    name="wpc_user_notification_for_booking_req" />
                                                    <label for="wpc_user_notification_for_booking_req" class="wpcafe_switch_button_label"></label>
                                                </div>
                                            </div> 
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_user_notification_for_confirm_req"><?php esc_html_e('Notify user confirmed request', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Send email to user when admin update reservation status.", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                <input name="wpc_user_notification_for_confirm_req" class="hide_field" type="checkbox" value="off" <?php echo esc_attr( $user_notif_confirm_book == 'off' ? 'checked' : '' ); ?>/>
                                                <input  id='wpc_user_notification_for_confirm_req' type="checkbox" <?php echo esc_attr( $user_notif_confirm_book == 'on' ? 'checked' : '' ); ?> class="wpcafe-admin-control-input "
                                                    name="wpc_user_notification_for_confirm_req" disabled />
                                                    <label for="wpc_user_notification_for_confirm_req" class="wpcafe_switch_button_label"></label>
                                                    <span class="wpc-pro-text"><?php esc_html_e('pro version only', 'wpcafe'  ) ?></span>
                                                </div>
                                            </div> 
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_notification_for_confirm_req"><?php esc_html_e('Notify admin about confirmed request', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Send email to admin when update reservation status from backend", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                <input name="wpc_admin_notification_for_confirm_req" class="hide_field" type="checkbox" value="off" <?php echo esc_attr( $admin_notif_confirm_book =='off' ? 'checked' : '' ); ?>/>
                                                <input id='wpc_admin_notification_for_confirm_req'  
                                                    type="checkbox" 
                                                    <?php echo esc_attr( $admin_notif_confirm_book =='on' ? 'checked' : '' ); ?>
                                                    class="wpcafe-admin-control-input "
                                                    name="wpc_admin_notification_for_confirm_req" disabled />
                                                    <label for="wpc_admin_notification_for_confirm_req" class="wpcafe_switch_button_label"></label>
                                                    <span class="wpc-pro-text"><?php esc_html_e('pro version only', 'wpcafe'  ) ?></span>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_user_notification_for_cancel_req"><?php esc_html_e('Notify user about cancelled request', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Send email to user when a reservation is cancelled from admin", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                <input name="wpc_user_notification_for_cancel_req" class="hide_field" type="checkbox" value="off" <?php echo esc_attr( $user_notif_cancel_req =='off' ? 'checked' : ''  ); ?>/>
                                                <input  id='wpc_user_notification_for_cancel_req' type="checkbox" 
                                                <?php echo esc_attr( $user_notif_cancel_req =='on' ? 'checked' : ''  ); ?> 
                                                class="wpcafe-admin-control-input "
                                                    name="wpc_user_notification_for_cancel_req" disabled />
                                                    <label for="wpc_user_notification_for_cancel_req" class="wpcafe_switch_button_label"></label>
                                                    <span class="wpc-pro-text"><?php esc_html_e('pro version only', 'wpcafe'  ) ?></span>
                                                </div>
                                            </div> 
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_cancel_notification"><?php esc_html_e('Notify admin about cancelled request', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Send email to admin when a reservation is cancelled from backend", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                <input name="wpc_admin_cancel_notification" class="hide_field" type="checkbox" value="off" <?php echo esc_attr( $admin_notif_cancel_req =='off' ? 'checked' : ''  ); ?>/>
                                                <input id='wpc_admin_cancel_notification' type="checkbox"   
                                                <?php echo esc_attr( $admin_notif_cancel_req == 'on' ? 'checked' : ''   ); ?>
                                                class="wpcafe-admin-control-input"
                                                    name="wpc_admin_cancel_notification" disabled />
                                                    <label for="wpc_admin_cancel_notification" class="wpcafe_switch_button_label"></label>
                                                    <span class="wpc-pro-text"><?php esc_html_e('pro version only', 'wpcafe'  ) ?></span>
                                                </div>
                                            </div>  
                                            <h3 class="wpc-tab-title"><?php esc_html_e('Notification Emails', 'wpcafe'  ); ?></h3>
                                            <div class="wpc-label-item wpc-email-tag">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_email_address"><?php esc_html_e('Template tags', 'wpcafe'  ); ?></label>

                                                    <p class="wpc-desc"> <?php echo esc_html__('Use the following tags to automatically add booking information to the emails' , 'wpcafe' ); ?></p>
                                                        <?php
                                                            $tag_box = array (
                                                                array(
                                                                    "tag_name" => '{user_email}',
                                                                    "description" => esc_html__('Email of the user who made the booking' , 'wpcafe'  ),
                                                                ),
                                                                array(
                                                                    "tag_name" => '{user_name}',
                                                                    "description" => esc_html__('* Name of the user who made the booking' , 'wpcafe'  ),
                                                                ),
                                                                array(
                                                                    "tag_name" => '{party}',
                                                                    "description" => esc_html__('* Number of people booked', 'wpcafe'  ),
                                                                ),
                                                                array(
                                                                    "tag_name" => '{date}',
                                                                    "description" => esc_html__('* Date and time of the booking', 'wpcafe'  ),
                                                                ),
                                                                array(
                                                                    "tag_name" => '{phone}',
                                                                    "description" => esc_html__('Phone number if supplied with the request', 'wpcafe'  ),
                                                                ),
                                                                array(
                                                                    "tag_name" => '{message}',
                                                                    "description" => esc_html__('Message added to the request', 'wpcafe'  ),
                                                                ),
                                                                array(
                                                                    "tag_name" => '{site_name}',
                                                                    "description" => esc_html__('The name of this website', 'wpcafe'  ),
                                                                ),
                                                                array(
                                                                    "tag_name" => '{site_link}',
                                                                    "description" => esc_html__('A link to this website', 'wpcafe'  ),
                                                                ),
                                                                array(
                                                                    "tag_name" => '{current_time}',
                                                                    "description" => esc_html__('Current date and time', 'wpcafe'  ),
                                                                ),
                                                        );
                                                        foreach ($tag_box as $key => $value) { ?>
                                                            <div class="wpc-template-tags-box">
                                                            <strong><?php echo esc_html( $value['tag_name'] ); ?></strong> <?php echo  esc_html( $value['description'] ); ?>
                                                            </div>
                                                        <?php } ?> 
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_notification_subject"><?php esc_html_e('Admin new reservation email subject', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Subject of email that will be sent to admin when a new reservation occurs ", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="text" class="wpc-settings-input" name="wpc_admin_notification_subject" id="wpc_admin_notification_subject"
                                                        value="<?php echo esc_attr( isset($settings['wpc_admin_notification_subject'] ) ? $settings['wpc_admin_notification_subject'] : ''); ?>"
                                                        placeholder="<?php esc_html_e( 'New booking request', 'wpcafe'  ); ?>" />
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_notification_email"><?php esc_html_e('Admin new reservation email body', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Body of email that will be sent to admin when a new reservation occurs ", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <?php wp_editor( html_entity_decode( isset( $settings['wpc_admin_notification_email'] ) ? $settings['wpc_admin_notification_email'] : "" ) , 
                                                    'wpc_admin_notification_email', array('textarea_name'=>'wpc_admin_notification_email','media_buttons' => false ) ); ?> 
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_new_req_email_subject"><?php esc_html_e('New request email subject to user', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Subject of email that will be sent to user when a new reservation occurs ", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="text" class="wpc-settings-input" name="wpc_new_req_email_subject" id="wpc_new_req_email_subject"
                                                        value="<?php echo esc_attr( isset($settings['wpc_new_req_email_subject'] ) ? $settings['wpc_new_req_email_subject'] : ''); ?>"
                                                        placeholder="<?php esc_html_e( 'New booking request subject' , 'wpcafe'  );?>" />
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_new_req_email"><?php esc_html_e('User new booking request email body', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Body of email that will be sent to user when a new reservation occurs ",  'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <?php wp_editor( html_entity_decode( isset( $settings['wpc_new_req_email'] ) ? $settings['wpc_new_req_email'] : "" ), 
                                                    'wpc_new_req_email',  array('textarea_name'=>'wpc_new_req_email','media_buttons' => false) ); ?> 
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_booking_confirm_subject"><?php esc_html_e('Admin reservation confirm email subject', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Subject of email that will be sent to admin when a reservation is confirmed ",  'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="text" name="wpc_admin_booking_confirm_subject" class="wpc-settings-input" id="wpc_admin_booking_confirm_subject"
                                                        value="<?php echo esc_attr( isset($settings['wpc_admin_booking_confirm_subject'] ) ? $settings['wpc_admin_booking_confirm_subject'] : ''); ?>"
                                                        placeholder="<?php echo esc_html__("New booking confirmed", "wpcafe");?>" disabled/>
                                                        <span class="wpc-pro-text"><?php esc_html_e('Pro version only', 'wpcafe' ); ?></span>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_booking_confirm_email"><?php esc_html_e('Admin reservation confirm email body', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Body of email that will be sent to admin when a reservation is confirmed ",  'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <?php wp_editor( html_entity_decode( isset( $settings['wpc_admin_booking_confirm_email'] ) ? $settings['wpc_admin_booking_confirm_email'] : "" ), 
                                                    'wpc_admin_booking_confirm_email', array('textarea_name'=>'wpc_admin_booking_confirm_email','media_buttons' => false) ); ?> 
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_booking_cancel_subject"><?php esc_html_e('Admin booking cancelled Subject', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Subject of email that will be sent to admin when a reservation is cancelled ",  'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="text" name="wpc_admin_booking_cancel_subject" class="wpc-settings-input" id="wpc_admin_booking_cancel_subject"
                                                        value="<?php echo esc_attr( isset($settings['wpc_admin_booking_cancel_subject'] ) ? $settings['wpc_admin_booking_cancel_subject'] : ''); ?>"
                                                        placeholder="<?php esc_html_e("Reservation request cancelled", 'wpcafe'  )?>" disabled/>
                                                        <span class="wpc-pro-text"><?php esc_html_e('Pro version only', 'wpcafe' ); ?></span>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_admin_booking_cancel_email"><?php esc_html_e('Admin booking cancelled email', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Body of email that will be sent to admin when a reservation is cancelled ", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <?php wp_editor( html_entity_decode( isset( $settings['wpc_admin_booking_cancel_email'] ) ? $settings['wpc_admin_booking_cancel_email'] : "" ), 
                                                    'wpc_admin_booking_cancel_email', array('textarea_name'=>'wpc_admin_booking_cancel_email', 'media_buttons' => false
                                                    ) ); ?> 
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_confirm_email_subject"><?php esc_html_e('User confirmed email subject', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Subject of email that will be sent to user when reservation is confirmed ", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="text" class="wpc-settings-input" name="wpc_confirm_email_subject" id="wpc_confirm_email_subject"
                                                        value="<?php echo esc_attr( isset($settings['wpc_confirm_email_subject'] ) ? $settings['wpc_confirm_email_subject'] : ''); ?>"
                                                        placeholder="<?php esc_html_e("Confirm email subject", 'wpcafe'  ); ?>" disabled/>
                                                        <span class="wpc-pro-text"><?php esc_html_e('Pro version only', 'wpcafe' ); ?></span>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_confirm_email"><?php esc_html_e('User confirmed email', 'wpcafe'   ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Body of email that will be sent to user when reservation is confirmed ", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <?php wp_editor( html_entity_decode( isset( $settings['wpc_confirm_email'] ) ? $settings['wpc_confirm_email'] : "" ), 
                                                    'wpc_confirm_email',  array('textarea_name'=>'wpc_confirm_email','media_buttons' => false) ); ?> 
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_rejected_email_subject"><?php esc_html_e('User cancelled email subject', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Subject of email that will be sent to user when a reservation is cancelled ", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <input type="text" class="wpc-settings-input" name="wpc_rejected_email_subject" id="wpc_rejected_email_subject"
                                                        value="<?php echo esc_attr( isset($settings['wpc_rejected_email_subject'] ) ? $settings['wpc_rejected_email_subject'] : ''); ?>"
                                                        placeholder="<?php esc_html_e("Rejected email subject", 'wpcafe'  )?>" disabled/>
                                                    <span class="wpc-pro-text"><?php esc_html_e('Pro version only', 'wpcafe' ); ?></span>
                                                </div>
                                            </div>
                                            <div class="wpc-label-item">
                                                <div class="wpc-label">
                                                    <label for="wpc_rejected_email"><?php esc_html_e('User cancelled email', 'wpcafe'  ); ?></label>
                                                    <div class="wpc-desc"> <?php esc_html_e("Body of email that will be sent to user when a reservation is cancelled ", 'wpcafe'  ); ?> </div>
                                                </div>
                                                <div class="wpc-meta">
                                                    <?php wp_editor( html_entity_decode( isset( $settings['wpc_rejected_email'] ) ? $settings['wpc_rejected_email'] : "" ), 
                                                    'wpc_rejected_email',  array('textarea_name'=>'wpc_rejected_email','media_buttons' => false) ); ?> 
                                                </div>
                                            </div>
                                        <?php
                                    }
                                    // Menu settings
                                    elseif ( $item == 'menu_settings' ) {
                                        ?>
                                        <h3 class="wpc-tab-title"><?php esc_html_e("Food Menu Options", "wpcafe"  ); ?></h3>
                                        <div class="wpc-label-item">
                                            <div class="wpc-label">
                                                <label for="wpcafe_food_location"><?php esc_html_e("Allow location", "wpcafe"  ); ?></label>
                                                <div class="wpc-desc"> <?php esc_html_e("Show location dropdown on front-end menu (only in front page) and checkout", "wpcafe"  ); ?> </div>
                                            </div>
                                            <div class="wpc-meta">
                                                <input id='wpcafe_food_location' type="checkbox" <?php echo esc_attr( $wpcafe_food_location ) ; ?> class="wpcafe-admin-control-input"
                                                name="wpcafe_food_location" />
                                                <label for="wpcafe_food_location" class="wpcafe_switch_button_label"></label>
                                            </div>
                                        </div>
                                        <div class="wpc-label-item">
                                            <div class="wpc-label">
                                                <label for="wpcafe_allow_cart"><?php esc_html_e("Allow Cart", "wpcafe"  ); ?></label>
                                                <div class="wpc-desc"> <?php esc_html_e("Show cart on the frontend",  "wpcafe"  ); ?> </div>
                                            </div>
                                            <div class="wpc-meta">
                                                <input name="wpcafe_allow_cart" class="hide_field" type="checkbox" value="off" <?php echo esc_attr( $wpcafe_allow_cart == 'off' ? 'checked' : ''  ) ; ?>/>
                                                <input id='wpcafe_allow_cart' type="checkbox" <?php echo esc_attr( $wpcafe_allow_cart == 'on' ? 'checked' : ''  ) ; ?> class="wpcafe-admin-control-input "
                                                name="wpcafe_allow_cart" />
                                                <label for="wpcafe_allow_cart" class="wpcafe_switch_button_label"></label>
                                            </div>
                                        </div>
                                        <div class="wpc-label-item">
                                            <div class="wpc-label">
                                                <label for="wpc_mini_cart_icon"><?php esc_html_e('Minicart icon', 'wpcafe'  ); ?></label>
                                                <div class="wpc-desc"> <?php esc_html_e("Icon class for mini cart",  'wpcafe'  ); ?> </div>
                                            </div>
                                            <div class="wpc-meta">
                                                <input type="text" class="wpc-settings-input" name="wpc_mini_cart_icon" id="wpc_mini_cart_icon"
                                                value="<?php echo esc_attr( isset($settings['wpc_mini_cart_icon'] ) ? $settings['wpc_mini_cart_icon'] : ''); ?>"
                                                placeholder="<?php esc_html_e("icon here",  'wpcafe'  ); ?>" />
                                                <span class="wpc-admin-settings-message"><?php echo esc_html_e( 'For instance : fa fa-shopping-cart', 'wpcafe'  )?>
                                            </div>
                                        </div>
                                        <div class="wpc-label-item">
                                            <div class="wpc-label">
                                                <label for="wpc_primary_color"><?php esc_html_e('Primary color', 'wpcafe'  ); ?></label>
                                                <div class="wpc-desc"> <?php esc_html_e("Choose primary color for menu", 'wpcafe'  ); ?> </div>
                                            </div>
                                            <div class="wpc-meta">
                                                <input type="text" name="wpc_primary_color" id="wpc_primary_color"
                                                value="<?php echo esc_attr( isset($settings['wpc_primary_color'] ) ? $settings['wpc_primary_color'] : ''); ?>"
                                                />
                                            </div>
                                        </div>
                                        <div class="wpc-label-item">
                                            <div class="wpc-label">
                                                <label for="wpc_secondary_color"><?php esc_html_e('Secondary color', 'wpcafe'  ); ?></label>
                                                <div class="wpc-desc"> <?php esc_html_e("Choose secondary color for menu", 'wpcafe'  ); ?> </div>
                                            </div>
                                            <div class="wpc-meta">
                                                <input type="text" name="wpc_secondary_color" id="wpc_secondary_color"
                                                value="<?php echo esc_attr( isset($settings['wpc_secondary_color'] ) ? $settings['wpc_secondary_color'] : ''); ?>"
                                                />
                                            </div>
                                        </div>
                                        <?php
                                        // render menu settings
                                        if( isset( $get_data['menu_settings'])){
                                            echo Wpc_Utilities::wpc_render($get_data['menu_settings']) ;
                                        }
                                    }
                                    //hooks 
                                    elseif ( $item == 'hooks' ) {
                                        ?>
                                        <h3 class="wpc-tab-title"><?php esc_html_e('Shortcode', 'wpcafe'  ); ?></h3>

                                        <div class="wpc-label-item">
                                            <div class="wpc-label">
                                                <label for="wpc_reservation_form"><?php esc_html_e('Reservation Form', 'wpcafe'  ); ?></label>
                                                <div class="wpc-desc"> <?php esc_html_e("Use this [wpc_reservation_form wpc_image_url=''] shortcode anywhere you want to show the reservation form",  'wpcafe'  );?></div>
                                            </div>
                                            <div class="wpc-meta">
                                                <input class="wpc-settings-input" id="reservation_form_shortcode" type="text" name="wpc_reservation_form" 
                                                value="[wpc_reservation_form wpc_image_url='']"
                                                readonly />
                                                <button type="button" onclick="copyTextData('reservation_form_shortcode');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
                                            </div>
                                        </div>
                                        <?php
                                        apply_filters('wpcafe/key_options/hook_settings',false);
                                        ?>
                                        <div class="wpc-label-item">
                                            <div class="wpc-label">
                                                <label for="show_food_menu"><?php esc_html_e('Show Food Menu tab', 'wpcafe'  ); ?></label>
                                                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_food_menu_tab wpc_food_categories='16,21,18,17,20'  no_of_product='5'  product_thumbnail ='on' wpc_cart_button ='on' ]",  'wpcafe'  );?></div>
                                            </div>
                                            <div class="wpc-meta">
                                                <input type="text" id="food_menu_shortcode_tab" class="wpc-settings-input"
                                                value="[wpc_food_menu_tab wpc_food_categories='16,21,18,17,20' no_of_product='5' product_thumbnail ='on' wpc_cart_button ='on' ]"
                                                readonly />
                                                <button type="button" onclick="copyTextData('food_menu_shortcode_tab');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
                                            </div>
                                        </div>
                                        <div class="wpc-label-item">
                                            <div class="wpc-label">
                                                <label for="food_menu_shortcode_list"><?php esc_html_e('Show Food Menu List', 'wpcafe'  ); ?></label>
                                                <div class="wpc-desc"> <?php esc_html_e("You can use [wpc_food_menu_list wpc_food_categories='16,21,18,17,20'  no_of_product='5'  wpc_cart_button ='on']",  'wpcafe'  );?></div>
                                            </div>
                                            
                                            <div class="wpc-meta">
                                            <input type="text" id="food_menu_shortcode_list" class="wpc-settings-input"
                                                value="[wpc_food_menu_list wpc_food_categories='16,21,18,17,20' no_of_product='5' wpc_cart_button ='on' ]"
                                                readonly />
                                                <button type="button" onclick="copyTextData('food_menu_shortcode_list');" class="wpc_copy_button wpc-btn"><span class="dashicons dashicons-category"></span></button>
                                            </div>
                                        </div>
                                        <?php
                                    }                                   
                                ?>
                                </div>
                            <?php } }
                                apply_filters('wpcafe/key_options/tab_content', $settings,$wpc_doc_link);
                        ?>
                            <input type="hidden" name="wpcafe_settings_key_options_action" value="save">
                            <input type="submit" name="submit" id="submit" class="wpc_mt_two wpc-btn" value="<?php esc_attr_e('Save Changes', 'wpcafe' ); ?>">
                            <?php wp_nonce_field('wpcafe-settings-page', 'wpcafe-settings-page'); ?>
                        </form>
                    </div>
            </div>
        <?php
        }
    }
}

