<?php
namespace WpCafe_Pro\Core\Enqueue;

defined( "ABSPATH" ) || exit;

use WpCafe_Pro\Traits\Singleton;

/**
 * Enqueue all css and js file class
 */
class Enqueue {

    use Singleton;

    /**
     * Main calling function
     */
    public function init() {
        // backend asset
        add_action( 'admin_enqueue_scripts', [$this, 'admin_enqueue_assets'] );
        // frontend asset
        add_action( 'wp_enqueue_scripts', [$this, 'frontend_enqueue_assets'] );
        // enqueue editor js.
        add_action( 'elementor/frontend/before_enqueue_scripts', [$this, 'elementor_js_pro'] );
    }

    /**
     * all js files function
     *
     * @param $var
     */
    public function admin_get_scripts() {
        // js
        return [
            'select2'               => [
                'src'     => WPC_PRO_ASSETS . 'js/select2.min.js',
                'version' => WPC_PRO_VERSION,
            ],

            'wpc-pro-admin'         => [
                'src'     => WPC_PRO_ASSETS . 'js/wpc-pro-admin.js',
                'version' => WPC_PRO_VERSION,
            ],
            'jquery-timepicker' => [
                'src'     => WPC_ASSETS . 'js/jquery.timepicker.min.js',
                'version' => WPC_PRO_VERSION,
                'deps'    => ['jquery'],
            ],
            'wpc-pro-image-media'       => [
                'src'     => WPC_PRO_ASSETS . 'js/image-upload.js',
                'version' => WPC_PRO_VERSION,
                'deps'    => ['jquery'],
            ],
        ];
    }

    /**
     * all css files function
     *
     * @param Type $var
     */
    public function admin_get_styles() {
        return [
            'select2'       => [
                'src'     => WPC_PRO_ASSETS . 'css/select2.min.css',
                'version' => WPC_PRO_VERSION,
            ],
            'wpc-pro-admin' => [
                'src'     => WPC_PRO_ASSETS . 'css/wpc-admin-pro.css',
                'version' => WPC_PRO_VERSION,
            ],
        ];
    }

    /**
     * Enqueue admin js and css function
     *
     * @param  $var
     */
    public function admin_enqueue_assets() {

        // js
        if ( !did_action( 'wp_enqueue_media' ) ) {
            wp_enqueue_media();
        }

        wp_enqueue_script( 'thickbox' );

        $scripts = $this->admin_get_scripts();

        foreach ( $scripts as $key => $value ) {
            $deps       = isset( $value['deps'] ) ? $value['deps'] : false;
            $version    = !empty( $value['version'] ) ? $value['version'] : false;
            wp_enqueue_script( $key, $value['src'], $deps, $version, true );
        }

        // css
        wp_enqueue_style( 'thickbox' );
        $styles = $this->admin_get_styles();

        foreach ( $styles as $key => $value ) {
            $deps       = isset( $value['deps'] ) ? $value['deps'] : false;
            $version    = !empty( $value['version'] ) ? $value['version'] : false;
            wp_enqueue_style( $key, $value['src'], $deps, $version, 'all' );
        }

    }

    /**
     * Make obj to send localize script
     *
     * @return void
     */
    public function settings_obj() {
        $form_data = [];
        $settings  = \WpCafe\Core\Base\Wpc_Settings_Field::instance()->get_settings_option();

        if ( $settings ) {
            $wpc_pickup_exception_date               = ( isset( $settings['wpc_pickup_exception_date'] ) ? $settings['wpc_pickup_exception_date'] : '' );
            $wpc_delivery_exception_date             = ( isset( $settings['wpc_delivery_exception_date'] ) ? $settings['wpc_delivery_exception_date'] : '' );
            $wpc_pickup_holiday                      = ( isset( $settings['wpc_pickup_holiday'] ) ? $settings['wpc_pickup_holiday'] : '' );
            $wpc_delivery_holiday                    = ( isset( $settings['wpc_delivery_holiday'] ) ? $settings['wpc_delivery_holiday'] : '' );
            $wpc_pickup_weekly_schedule              = ( isset( $settings['wpc_pickup_weekly_schedule'] ) ? $settings['wpc_pickup_weekly_schedule'] : '' );
            $wpc_delivery_schedule                   = ( isset( $settings['wpc_delivery_schedule'] ) ? $settings['wpc_delivery_schedule'] : '' );
            $wpc_pickup_weekly_schedule_start_time   = ( isset( $settings['wpc_pickup_weekly_schedule_start_time'] ) ? $settings['wpc_pickup_weekly_schedule_start_time'] : '' );
            $wpc_pickup_weekly_schedule_end_time     = ( isset( $settings['wpc_pickup_weekly_schedule_end_time'] ) ? $settings['wpc_pickup_weekly_schedule_end_time'] : '' );
            $wpc_delivery_weekly_schedule_start_time = ( isset( $settings['wpc_delivery_weekly_schedule_start_time'] ) ? $settings['wpc_delivery_weekly_schedule_start_time'] : '' );
            $wpc_delivery_weekly_schedule_end_time   = ( isset( $settings['wpc_delivery_weekly_schedule_end_time'] ) ? $settings['wpc_delivery_weekly_schedule_end_time'] : '' );

            $form_data = [
                'wpc_pickup_exception_date'               => $wpc_pickup_exception_date,
                'wpc_delivery_exception_date'             => $wpc_delivery_exception_date,
                'wpc_pickup_holiday'                      => $wpc_pickup_holiday,
                'wpc_delivery_holiday'                    => $wpc_delivery_holiday,
                'wpc_pickup_weekly_schedule'              => $wpc_pickup_weekly_schedule,
                'wpc_delivery_schedule'                   => $wpc_delivery_schedule,
                'wpc_pickup_weekly_schedule_start_time'   => $wpc_pickup_weekly_schedule_start_time,
                'wpc_pickup_weekly_schedule_end_time'     => $wpc_pickup_weekly_schedule_end_time,
                'wpc_delivery_weekly_schedule_start_time' => $wpc_delivery_weekly_schedule_start_time,
                'wpc_delivery_weekly_schedule_end_time'   => $wpc_delivery_weekly_schedule_end_time,
            ];
        }

        return $form_data;
    }

    /**
     * all js files function
     *
     * @param $var
     */
    public function frontend_get_scripts() {
        return [
            'pdfmake'                    => [
                'src'     => 'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.22/pdfmake.min.js',
                'version' => WPC_PRO_VERSION,
                'deps'    => ['jquery'],
            ],
            'html2canvas'                => [
                'src'     => 'https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.min.js',
                'version' => WPC_PRO_VERSION,
            ],
            'jquery-timepicker' => [
                'src'     => WPC_ASSETS . 'js/jquery.timepicker.min.js',
                'version' => WPC_PRO_VERSION,
                'deps'    => ['jquery'],
            ],
            'jquery-magnific-popup'  => [
                'src'     => WPC_PRO_ASSETS . 'js/jquery.magnific-popup.min.js',
                'version' => WPC_PRO_VERSION,
            ],
            'swiper-bundle'  => [
                'src'     => WPC_PRO_ASSETS . 'js/swiper-bundle.min.js',
                'version' => WPC_PRO_VERSION,
            ],
            'wpc-pro-widgets-modal-script'   => [
                'src'     => WPC_PRO_ASSETS . 'js/widgets.js',
                'version' => WPC_PRO_VERSION,
            ],
            'wpc-pro-public'             => [
                'src'     => WPC_PRO_ASSETS . 'js/wpc-pro-public.js',
                'version' => WPC_PRO_VERSION,
                'deps'    => ['jquery', 'wpc-pro-widgets-modal-script', 'wpc-public', 'jquery-timepicker'],
            ],
        ];
    }

    /**
     * all css files function
     *
     * @param Type $var
     */
    public function frontend_get_styles() {
        return [
            'jquery-timepicker' => [
                'src'     => WPC_PRO_ASSETS . 'css/jquery.timepicker.min.css',
                'version' => WPC_PRO_VERSION,
            ],
            'magnific-popup'             => [
                'src'     => WPC_PRO_ASSETS . 'css/magnific-popup.css',
                'version' => WPC_PRO_VERSION,
            ],
            'swiper-bundle'             => [
                'src'     => WPC_PRO_ASSETS . 'css/swiper-bundle.min.css',
                'version' => WPC_PRO_VERSION,
            ],
       
            'wpc-public-pro'             => [
                'src'     => WPC_PRO_ASSETS . 'css/wpc-public-pro.css',
                'version' => WPC_PRO_VERSION,
            ],
        ];
    }

    /**
     * Enqueue frontend js and css function
     *
     * @param  $var
     */
    public function frontend_enqueue_assets() {
        // js
        $scripts = $this->frontend_get_scripts();

        foreach ( $scripts as $key => $value ) {
            $deps       = isset( $value['deps'] ) ? $value['deps'] : false;
            $version    = !empty( $value['version'] ) ? $value['version'] : false;
            wp_enqueue_script( $key, $value['src'], $deps, $version, true );
        }

        // css
        $styles = $this->frontend_get_styles();

        foreach ( $styles as $key => $value ) {
            $deps       = isset( $value['deps'] ) ? $value['deps'] : false;
            $version    = !empty( $value['version'] ) ? $value['version'] : false;
            wp_enqueue_style( $key, $value['src'], $deps, $version, 'all' );
        }

        // locallize for frontend
        wp_localize_script( 'wpc-pro-public', 'wpc_obj', [
            'ajax_url'              => admin_url( 'admin-ajax.php' ),
            'security'              => wp_create_nonce( 'load_more_posts' ),
            'variaion_popup_nonce'  => wp_create_nonce( 'variaion_popup_nonce' ),
            'live_search_nonce'     => wp_create_nonce( 'live_search_nonce' ),
            'settings_options'      => $this->settings_obj(),
        ] );
    }

    /**
     *elementor js loaded
     */
    public function elementor_js_pro() {
        wp_enqueue_script( 'wpc-pro-elementor', WPC_PRO_ASSETS . 'js/elementor.js', ['elementor-frontend'], WPC_PRO_VERSION, true );
    }

}
