<?php
namespace WpCafe_Pro\Core\Action;

defined( "ABSPATH" ) || exit;

use WpCafe\Utils\Wpc_Utilities;

Class Ajax_Action {

    use \WpCafe\Traits\Wpc_Singleton;

    public function init() {
        // load more
        add_action( 'wp_ajax_load_posts_by_ajax', [$this, 'load_posts_by_ajax'] );
        add_action( 'wp_ajax_nopriv_load_posts_by_ajax', [$this, 'load_posts_by_ajax'] );
        // live search
        add_action( 'wp_ajax_live_search_ajax', [$this, 'live_search_ajax'] );
        add_action( 'wp_ajax_nopriv_live_search_ajax', [$this, 'live_search_ajax'] );
        // variation popup
        add_action( 'wp_ajax_variaion_product_popup_content', [$this, 'variaion_product_popup_content'] );
        add_action( 'wp_ajax_nopriv_variaion_product_popup_content', [$this, 'variaion_product_popup_content'] );
    }

    /**
     * Check nonce of ajax call
     */
    public function check_nonce( $nonce_param , $nonce, $post ){
        $wpc_pro_secured = Wpc_Utilities::is_secured( $nonce_param, $nonce , $post );
        if ( $wpc_pro_secured == false && current_user_can( 'edit_posts' ) == false ) {
            $response = ['status_code' => 500, 'message' => [ esc_html__('somthing is wrong','wpcafe-pro') ], 'data' => []];
            wp_send_json_error( $response );
        }
    }

    /**
     * function for load-more
     */
    public function load_posts_by_ajax() {

        $this->check_nonce( 'security_nonce', 'load_more_posts' , $_POST );

        //check for valid nonce
        $all_data         = filter_input_array( INPUT_POST, FILTER_SANITIZE_STRING );
        $settings         = $all_data['ajax_json_data'];
        $widget_id        = isset( $settings['widget_id'] ) ? $settings['widget_id'] : 0;
        $show_item_status = $settings['show_item_status'];
        $wpc_cart_button  = $settings['wpc_cart_button_show'];
        $title_link_show  = $settings['title_link_show'];
        $wpc_btn_text     = $settings['wpc_btn_text'];
        $wpc_desc_limit   = $settings['wpc_desc_limit'];
        $wpc_show_desc    = $settings['wpc_show_desc'];
        $customize_btn    = $settings["customize_btn"];
        $show_thumbnail   = $settings['show_thumbnail'];
        $cat_id           = $settings['cat_id'];
        $wpc_menu_count   = $settings['wpc_menu_count'];
        $order            = $settings['order'];
        $col              = ( $show_thumbnail == 'yes' ) ? 'wpc-col-md-9' : 'wpc-col-md-12';
        $permalink        = (  ( $title_link_show == 'yes' ) ? get_the_permalink() : '' );
        $class            = (  ( $title_link_show == 'yes' ) ? '' : 'wpc-no-link' );
        $paged            = isset( $all_data['paged'] ) ? $all_data['paged'] : 1;

        $products = Wpc_Utilities::product_query( "product", $wpc_menu_count , $cat_id , $order , $paged );

        if ( (is_array( $products ) && count( $products )>0 ) ):
            include WPC_PRO_DIR . "/widgets/food-menu-loadmore/style/style-1.php";
        endif;
        wp_die();
    }

    /**
     * Variation popup
     */
    public function variaion_product_popup_content(){

        $this->check_nonce( '_wpcnonce', 'variaion_popup_nonce' , $_POST );

        if ( "variaion_popup" == sanitize_text_field( $_POST['wpc_action'] ) ) {
            $post_arr     = filter_input_array( INPUT_POST, FILTER_SANITIZE_STRING );
            $product_id   = $post_arr['product_id'];
            if( $product_id !== ''){
                ob_start();
                \WpCafe_Pro\Core\Widgets\Hook::instance()->variation_popup_template( $product_id );
                wp_send_json_success( ['success'=>1,'message'=>'success','data'=>json_encode(ob_get_clean())] );
            }
        }

    }

    /**
     * Live search in product title
     *
     * @return void
     */
    public function live_search_ajax(){
        $this->check_nonce( 'security_nonce', 'live_search_nonce' , $_POST );
        $search_html = '';
        $post_arr               = filter_input_array( INPUT_POST, FILTER_SANITIZE_STRING );
        $wpc_cart_button        = $post_arr['wpc_cart_button'];
        // widget data
        if( $post_arr['widget_arr'] ){
            $widget_arr             = $post_arr['widget_arr'];
            $addtocart_link_show    = isset( $widget_arr['addtocart_link_show'] ) ? $widget_arr['addtocart_link_show'] : "";
            $title_link_show        = isset( $widget_arr['title_link_show'] ) ? $widget_arr['title_link_show'] : "";
            $show_thumbnail         = isset( $widget_arr['show_thumbnail'] ) ? $widget_arr['show_thumbnail'] : "";
            $wpc_menu_order         = isset( $widget_arr['wpc_menu_order'] ) ? $widget_arr['wpc_menu_order'] : "";
            $show_item_status       = isset( $widget_arr['show_item_status'] ) ? $widget_arr['show_item_status'] : "";
            $wpc_delivery_time_show = isset( $widget_arr['wpc_delivery_time_show'] ) ? $widget_arr['wpc_delivery_time_show'] : "";
            $wpc_show_desc          = isset( $widget_arr['wpc_show_desc'] ) ? $widget_arr['wpc_show_desc'] : "";
            $wpc_menu_col           = isset( $widget_arr['wpc_menu_col'] ) ? $widget_arr['wpc_menu_col'] : "";
            $wpc_desc_limit         = isset( $widget_arr['wpc_desc_limit'] ) ? $widget_arr['wpc_desc_limit'] : "";
            $wpc_btn_text           = isset( $widget_arr['wpc_btn_text'] ) ? $widget_arr['wpc_btn_text'] : "";
            $customize_btn          = isset( $widget_arr['customize_btn'] ) ? $widget_arr['customize_btn'] : "";
            $widget_id              = isset( $widget_arr['widget_id'] ) ? $widget_arr['widget_id'] : "";
            $wpc_slider_count       = isset( $widget_arr['wpc_slider_count'] ) ? $widget_arr['wpc_slider_count'] : "";
            $wpc_slider_dot_show    = isset( $widget_arr['wpc_slider_dot_show'] ) ? $widget_arr['wpc_slider_dot_show'] : "";
            $wpc_slider_nav_show    = isset( $widget_arr['wpc_slider_nav_show'] ) ? $widget_arr['wpc_slider_nav_show'] : "";
        }
        $class_id="";
        
        if( $post_arr['search_value'] !=="" ){
            ob_start();
            ?><ul class="get_result"><?php
            
            $search_data    = trim( $post_arr['search_value'] , " " ); 

            $get_cat_id = get_term_by('name', $search_data, 'product_cat');

            $wpc_menu_order == '' ? 'DESC' : $wpc_menu_order;
            $wpc_menu_order == '' ? 'DESC' : $wpc_menu_order;

            if($get_cat_id){
                if( $post_arr['template_name'] !== "list_template"){
                    $class_id       = $get_cat_id->term_id;
                }
                $wpc_cat            = [ $get_cat_id->term_id ];
                $products           = Wpc_Utilities::product_query( "product" , $post_arr['total_product'] , $wpc_cat , $wpc_menu_order );
                $products_search    = Wpc_Utilities::product_query( "product" , -1 , $wpc_cat , $wpc_menu_order );
            }else {
                $products       = Wpc_Utilities::product_query( "product" , $post_arr['total_product'] , $post_arr['cat_arr'] , $wpc_menu_order , null , false , $search_data );
                $products_search= Wpc_Utilities::product_query( "product" , -1 , $post_arr['cat_arr'] , $wpc_menu_order , null , false , $search_data );
            }
            if( is_array( $products_search ) ){                    
                foreach ( $products_search as $key => $product) {
                    $select_cat_id = '';
                    $term_list = wp_get_post_terms($product->get_id(), 'product_cat', array('fields' => 'ids'));
                    if( is_array( $term_list ) && count( $term_list ) >0 ){
                        $select_cat_id = array_values($term_list)[0];
                        if( $post_arr['template_name'] !== "list_template"){
                            $class_id       = $select_cat_id;
                        }
                    }
                    ?>
                    <li data-cat_id="<?php echo intval($select_cat_id) ?>"> <?php esc_html_e($product->get_name());?> </li>
                    <?php
                }
            }else {
            ?><li><?php  esc_html_e( "No data found", "wpcafe-pro" ) ?></li><?php  
            }
            ?></ul><?php
            $search_html = ob_get_clean();
        }else {
            $products       = Wpc_Utilities::product_query( "product" , $post_arr['total_product'] , $post_arr['cat_arr'] , $wpc_menu_order , null , false , null );

            if($post_arr['template_name'] == "tab_template" ){
                if(is_array( $post_arr['cat_arr'] ) && count($post_arr['cat_arr']) ){
                    $class_id = $post_arr['cat_arr'][0];
                }else{
                    $class_id = 0;
                }
            }
        }
        
        ob_start();
        if( $post_arr['template_path'] !== ''){
            include $post_arr['template_path'];
        }
        $content = ob_get_clean();
        wp_send_json_success( ['success'=>1,'message'=>'success','data'=> [ 'search_html'=>$search_html , 'content'=>$content , 'template_name' => $post_arr['template_name'] , 'cat_id' => $class_id ] ] );
        wp_die();
    }
}
