(function($) {
    
    "use strict";

    $(document).ready(function() {

        // decalare class name
        var wpc_from_time = $("#wpc_from_time");
        var wpc_to_time   = $("#wpc_to_time");

        // load color picker   
        $("#wpc_primary_color").wpColorPicker();
        $("#wpc_secondary_color").wpColorPicker();

        // load date flatpicker  
        $(".exception_main_block").on('focus',".wpc_exception_date", function(){
            $(this).flatpickr({
                dateFormat: 'yy-m-d',
            });
        });

        var time_class = ['.wpc_weekly_schedule_start_time','.wpc_weekly_schedule_end_time','.wpc_exception_start_time',
        '.wpc_exception_end_time'];
        
        // load  timepicker  
        $.map(time_class,function(value,index){
            $('.schedule_main_block,.exception_main_block').on('focus', value , function(){
                $(this).timepicker({
                    timeFormat: 'h:i A',
                    dynamic: true
                });

                time_picker( $(this) )
            }); 
        });
        var checkbox_arr = ['#wpc_allow_cancellation','#wpc_admin_notification_for_booking_req',
        '#wpc_user_notification_for_booking_req','#wpcafe_allow_cart',
        '#wpc_user_notification_for_confirm_req','#wpc_admin_notification_for_confirm_req',
        '#wpc_user_notification_for_cancel_req','#wpc_admin_cancel_notification'];
        
        $.map( checkbox_arr, function( value , index ){
            // checkbox checked / unchecked value set
            $(value).on('change',function(){
                var get_sibling = $(this).siblings('input[type="checkbox"][value="off"]');
                if (get_sibling) {
                    if ( $(this).is(':checked') ) {
                        $(this).attr('checked',true)
                        get_sibling.attr('checked',false)
                    }else{
                        $(this).removeAttr('checked')
                        get_sibling.attr('checked',true)
                    }
                }
            })
        } )


        /**********************
            Add remove block
        **********************/

        // Exceptional Shcedule dynamically increase decrease
        var exception_obj = {wrapper_block: '.exception_block' , parent_block:'.exception_section',second_wrapper:'exception_block',
            append_wrapper:'.exception_main_block',button_wrapper:'.add_exception_block',date_name:'wpc_exception_date',
            start_time_name:'wpc_exception_start_time',end_time_name:'wpc_exception_end_time',remove_button:'remove_exception_block'};
        
        add_exception_block( exception_obj , 'reservation_exception_schedule' );

        // Weekly shcedule dynamically increase decrease
        add_week_block('schedule_block', 'wpc-weekly-schedule-list', 'week_schedule_wrap' , '.schedule_main_block' , '.wpc-weekly-schedule-btn' , '.add_schedule_block' , 'wpc_weekly_schedule' , 'wpc_weekly_schedule_start_time' , 'wpc_weekly_schedule_end_time' , 'remove_schedule_block','wpc_weekly_clear'); 
    
        // remove shcedule block
        var remove_weekly_blcok = { parent_block:'.schedule_main_block', remove_button:'.remove_schedule_block'
        , removing_block:'.schedule_block' };

        remove_block( remove_weekly_blcok );

        // remove exception shcedule block
        var remove_excepion_blcok = { parent_block:'.exception_main_block', remove_button:'.remove_exception_block'
        , removing_block:'.exception_block' };

        remove_block( remove_excepion_blcok );

        // clear action
        var clear_class = ['.wpc_weekly_clear','.wpc_all_day_clear','.exception_time_clear'];

        $.each(clear_class,function(ind,val){
            $('.wpc-all-day-schedule,.schedule_main_block,.exception_main_block').on('click', val ,function(){
                if ( ind === 0 ) {
                    $('.wpc_weekly_schedule_start_time_'+$(this).attr("id") ).val('');
                    $('.wpc_weekly_schedule_end_time_'+$(this).attr("id") ).val('');
                }
                else if( ind === 1 ) {
                    $('input[name="wpc_all_day_start_time"]').val('');
                    $('input[name="wpc_all_day_end_time"]').val('');
                }
                else if( ind === 2 ) {
                    $('.wpc_exception_start_time_'+$(this).attr("id") ).val('');
                    $('.wpc_exception_end_time_'+$(this).attr("id") ).val('');
                }
            })
        })

        // weekly schedule select
        var selected_values = new Array();
        $('.week_schedule_wrap :checkbox').each(function(){
            if($(this).is(":checked")){
                selected_values.push($(this).attr('class'))
            }
        });

        $('.schedule_main_block').on( 'change' , '.week_schedule_wrap :checkbox' , function(){
            var wpc_all_day_start = $(".wpc_all_day_start").val();
            var wpc_all_day_end   = $(".wpc_all_day_end").val();
            if( wpc_all_day_start == "" && wpc_all_day_end == "" ){
                var value = $(this).attr('class');
                if( $(this).is(":checked") )
                {
                    var check = $.inArray(value , selected_values );
                    // if not exist , push in array
                    if( check == -1 ){
                        selected_values.push(value);
                    }else{
                        $(this).prop("checked", false);
                        alert( value.toUpperCase() + " " +"day exist. Please check another day");
                    }
                }
                else{
                    selected_values.splice(selected_values.indexOf(value),1);
                }
                if (selected_values.length == 0) {
                    $('input.wpc_all_day_start,input.wpc_all_day_end').removeAttr("disabled");
                }
            }
            else
            {
                var schedule_block = $(".week_schedule_wrap :checkbox");
                $(schedule_block). prop("checked", false);
                alert( "You have already set allday schedule . Please unset allday schedule .");
            }
        });
        
        // all day shcedule
        $(".wpc-all-day-schedule").on('focus',".wpc_all_day_start , .wpc_all_day_end", function(){
            if( selected_values.length == 0 ){
                $('input.wpc_all_day_start,input.wpc_all_day_end').removeAttr("disabled");
                $(this).timepicker({
                    timeFormat: 'h:i A',
                    dynamic: true,
                });

                time_picker( $(this) );

            }else{
                $('input.wpc_all_day_start,input.wpc_all_day_end').val();
                $('input.wpc_all_day_start,input.wpc_all_day_end').prop( 'disabled', 'disabled' );
                alert( "You have already checked weekly schedule . Please uncheck weekly schedule .");
            }
        });


        /****************************
            Guest reservation form
        *****************************/

        // get data from enqueue
        var wpc_booking_form_data;    
        if ( typeof wpc_form_data !=="undefined") {
            wpc_booking_form_data = wpc_form_data;
        }
  
        var wpc_date_format = ""; var wpc_start_time = "";var wpc_end_time = "";
        var wpc_all_day_start_time ="";var wpc_all_day_end_time ="";
        
        // change time format according to settings
       var wpc_time_format; var wpc_date_format;

        if ( typeof wpc_booking_form_data === "undefined" ){
            wpc_time_format = 'H:i';
            wpc_date_format = 'yyyy-mm-dd'
        }
        else{
            if (wpc_booking_form_data.wpc_time_format == "24" || wpc_booking_form_data.wpc_time_format == "") {
                wpc_time_format = 'H:i';
            } else {
                wpc_time_format = 'h:i A';
            }
            // date format
            if( wpc_booking_form_data.wpc_date_format != "" ){
                wpc_date_format = wpc_booking_form_data.wpc_date_format;
            }else{
                wpc_date_format = 'yyyy-mm-dd'
            }
        }

        // check weekly and all day schedule
        const wpc_weekly_daily_schedule = ( selected_day ) =>{
            // check multislot weekly and all day schedule
            if( typeof wpc_booking_form_data.reser_multi_schedule !== 'undefined' && 
            wpc_booking_form_data.reser_multi_schedule == "on" ){
                if ( $.isArray(wpc_booking_form_data.multi_start_time) && $.isArray(wpc_booking_form_data.multi_end_time) && wpc_booking_form_data.multi_start_time.length !== 0 && wpc_booking_form_data.multi_end_time.length !== 0  ) {
                    // generate time list based on multislot start and end time which will be excluded from the timepicker time list for creating disableTimeRange array
                    let multislotData = multislotTimePicker( wpc_booking_form_data.multi_start_time, wpc_booking_form_data.multi_end_time , wpc_booking_form_data.wpc_time_format );
                    wpc_booking_form_data.multi_time_excludes = multislotData['multi_time_excludes'];
                    wpc_start_time = multislotData['wpc_start_time'];
                    wpc_end_time = multislotData['wpc_end_time'];
                }
            }
            //multislot end
            else{
                // time range for all day
                if( wpc_booking_form_data.wpc_all_day_start_time != "" && wpc_booking_form_data.wpc_all_day_end_time != "" ){
                    wpc_all_day_start_time = wpc_booking_form_data.wpc_all_day_start_time ;
                    wpc_all_day_end_time   = wpc_booking_form_data.wpc_all_day_end_time ;
        
                    if (wpc_booking_form_data.wpc_time_format == '24') {
                        wpc_start_time = convertTime12to24( wpc_all_day_start_time );
                        wpc_end_time   = convertTime12to24( wpc_all_day_end_time ); 
                    }else{
                        wpc_start_time = wpc_all_day_start_time;
                        wpc_end_time   = wpc_all_day_end_time; 
                    }
                }
                else
                {
                    var weekly_schedule_arr = wpc_booking_form_data.wpc_weekly_schedule;
                    var day= $.map(weekly_schedule_arr, function(value, index) {
                        var key = objectKeyName( value );
                        return key;
                    });
        
                    if ( $.inArray( selected_day,day ) !== -1) {
                        for (let index = 0; index < weekly_schedule_arr.length; index++) {
                            const element = weekly_schedule_arr[index];
                            var key = objectKeyName( element );
                            for (let i = 0; i < key.length; i++) {
                                const element = key[i];
                                if(selected_day == element){
                                    wpc_from_time.prop('disabled',false);
                                    $("#wpc-to-time").prop('disabled',false);
                                    if (wpc_booking_form_data.wpc_time_format == '24') {
                                        wpc_start_time = convertTime12to24( wpc_booking_form_data.wpc_weekly_schedule_start_time[ index ] );
                                        wpc_end_time   = convertTime12to24( wpc_booking_form_data.wpc_weekly_schedule_end_time[ index ] ); 
                                    }else{
                                        wpc_start_time = wpc_booking_form_data.wpc_weekly_schedule_start_time[ index ];
                                        wpc_end_time   = wpc_booking_form_data.wpc_weekly_schedule_end_time[ index ]; 
                                    }
                                } 
                            }
                        }    
                    } 
                    else {
                        $("#wpc_booking_date").val(" ");
                        if (selected_day !== '') {
                            alert("No schedule set for the day .");
                        }
                        wpc_from_time.prop('disabled',true);
                        wpc_to_time.prop('disabled',true);
                        return;
                    } 
        
                }
            }

        }

        if( typeof wpc_date_format === 'undefined'){
            wpc_date_format = 'yy-m-d';
        }

        // check late booking
        const wpc_check_late_booking =( selected_time , last_booking_time , min) =>{
            time_diff_latebooked = time_diff_for_before_after_equal(selected_time,last_booking_time);
            if (time_diff_latebooked == 'late') {
                alert("You can boook before  "+min+" minutes of closing time .");
                wpc_from_time.val(' ');
            }
        }

        //  from time  
        wpc_from_time.timepicker({
            timeFormat  : wpc_time_format,
            listWidth     : 1,
            dynamic     : true,
        });

        wpc_from_time.on('changeTime',function(){
            if ($(this).val() !== null) {
                var selected_time     = $(this).val();

                if ( typeof wpc_booking_form_data !=="undefined" ) {
                    var wpc_late_bookings = wpc_booking_form_data.wpc_late_bookings;
                    // check late bookings
                    if ( wpc_time_format != 'H:i' &&  typeof wpc_end_time !== 'undefined' ){
                        wpc_end_time  = convertTime12to24( wpc_end_time );
                        selected_time = convertTime12to24( selected_time );
                    }
    
                    if (typeof wpc_late_bookings !== 'undefinded' && wpc_late_bookings == '15') {
                        var last_booking_time = time_diff(wpc_end_time, "00:14");
                        if (selected_time !== '' && selected_time !== ',undefined' ) {
                            wpc_check_late_booking(selected_time,last_booking_time,15);
                        }
                    }
                    else if (typeof wpc_late_bookings !== 'undefinded' && wpc_late_bookings == '30') {
                        var last_booking_time = time_diff(wpc_end_time, "00:29");
                        if (selected_time !== '' && selected_time !== ',undefined' ) {
                            wpc_check_late_booking(selected_time,last_booking_time,30);
                        }
                    }
                    else if (wpc_late_bookings != 'undefinded' && wpc_late_bookings == '45') {
                        var last_booking_time = time_diff(wpc_end_time, "00:44");
                        if (selected_time !== '' && selected_time !== ',undefined' ) {
                            wpc_check_late_booking(selected_time,last_booking_time,45);
                        }
                    }
                }
            }
        })
        
        //  To
        wpc_to_time.timepicker({
            timeFormat  : wpc_time_format,
            listWidth     : 1,
            dynamic     : true,
        });

        // flatpicker date picker
        $('.wpcafe-meta').on('focus','#wpc_booking_date', function( e ){
            e.preventDefault();
            if ( typeof wpc_booking_form_data !=="undefined") {
                var wpc_early_bookings    = wpc_booking_form_data.wpc_early_bookings;
                var wpc_one_day           = wpc_booking_form_data.wpc_one_day;
                var wpc_one_week          = wpc_booking_form_data.wpc_one_week;
                var wpc_one_month         = wpc_booking_form_data.wpc_one_month;
                var wpc_one_day           = wpc_booking_form_data.wpc_one_day;
                var wpc_max_day ='';

                // early bookings
                if (typeof wpc_early_bookings !== 'undefinded' && wpc_early_bookings == '1day') {
                    wpc_max_day = new Date(wpc_one_day);
                }
                else if(typeof wpc_early_bookings !== 'undefinded' && wpc_early_bookings == '1week' )
                {
                    wpc_max_day = new Date(wpc_one_week);
                }
                else if( typeof wpc_early_bookings !== 'undefinded' && wpc_early_bookings == '1month' )
                {
                    wpc_max_day = new Date(wpc_one_month);
                }
                else{
                    wpc_max_day = false;
                }
                $(this).flatpickr({
                    dateFormat: wpc_date_format,
                    minDate   : "today",
                    maxDate   : wpc_max_day, 
                    position  : "below", 
                    onChange  : function(selectedDates, dateStr, instance) {
                        var wpc_new_selected_date = wpc_flatpicker_date_change(selectedDates,"Y-m-d");
                        var exception_date        = wpc_booking_form_data.wpc_exception_date;
                        $("#wpc_booking_date").val('');
                        $("#wpc_booking_date").val(dateStr);

                        if ( typeof exception_date === "undefined" ) 
                        {
                            var wpc_new_selected_date = wpc_flatpicker_date_change(selectedDates,"D");
                            wpc_weekly_daily_schedule( wpc_new_selected_date );  
                        }
                        else{
        
                            if (exception_date.length > 0 && exception_date[0] !== '') {
                                if ( $.inArray( wpc_new_selected_date,exception_date) !== -1) 
                                {
                                    var index = exception_date.indexOf(wpc_new_selected_date); 
                                    wpc_start_time = wpc_booking_form_data.wpc_exception_start_time[index];
                                    wpc_end_time   = wpc_booking_form_data.wpc_exception_end_time[index];
                                } 
                                else
                                {
                                    var wpc_new_selected_date = wpc_flatpicker_date_change(selectedDates,"D");
                                    wpc_weekly_daily_schedule( wpc_new_selected_date );
                                } 
                            }
                            else
                            {
                                var wpc_new_selected_date = wpc_flatpicker_date_change(selectedDates,"D");
                                wpc_weekly_daily_schedule( wpc_new_selected_date );
                            } 
                        }
                        if( wpc_booking_form_data.length == 0 ){
                            $("#wpc-booking-date").val(' ');
                            alert("No schedule set.");
                            wpc_from_time.prop('disabled',true);
                            wpc_to_time.prop('disabled',true);
        
                        }else{
                            wpc_from_time.prop('disabled',false);
                            wpc_to_time.prop('disabled',false);

                            if (wpc_time_format == "H:i") {        
                                wpc_start_time = convertTime12to24(wpc_start_time);
                                wpc_end_time   = convertTime12to24(wpc_end_time);
                            }

                            wpc_from_time.timepicker('option','minTime', wpc_start_time);
                            wpc_from_time.timepicker('option','maxTime', wpc_end_time);
                            // Disable time for multi slot
                            wpc_from_time.timepicker('option', 'disableTimeRanges', wpc_booking_form_data.multi_time_excludes );

                            wpc_to_time.timepicker('option','minTime', wpc_start_time);
                            wpc_to_time.timepicker('option','maxTime', wpc_end_time);
                            // Disable time for multi slot
                            wpc_to_time.timepicker('option', 'disableTimeRanges', wpc_booking_form_data.multi_time_excludes );
                        }
                    }
                    // onset function end
                });
                // flatpicker date end
            }
            else{
                alert("No schedule set from admin")
            }
        });
        
        // if get value 0 turn into time
        function time_picker( data ) {
            data.on('changeTime',function(){
                if (0 == data.val()) {
                    data.val('12:00 AM')
                }
                data.timepicker('hide');
            })
        }

        //admin settings tab
        $('.wpc-settings').on('click',".wpc-tab li a",function(e){
            e.preventDefault();
            $(".wpc-tab li a").removeClass("nav-tab-active");
            $(this).addClass("nav-tab-active");
            $(".tab-content .tab-pane").removeClass("active");
            $(".tab-pane[data-id='tab_" + $(this).attr('data-id') + "']").addClass("active");
        });

    });

  })(jQuery)
  

    // copy text
    function copyTextData(FIledid){
        var FIledidData = document.getElementById(FIledid);
        if(FIledidData){
            FIledidData.select();
            document.execCommand("copy");
        }
    }

    // adding  schedule block  
    function add_week_block( parent_block, second_wrapper ,  second_wrapper_extra ='' , append_wrapper , button_wrapper , button_class , name , start_time_name , end_time_name , remove_button , clear_button ) {
        var week_days = ['Sat','Sun','Mon','Tue','Wed','Thu','Fri'];
        var i = jQuery( '.'+parent_block ).length;
        var createField = 7 - i ; var html = "";
        // add shcedule block
        jQuery( button_wrapper ).on( 'click' , button_class , function() {
            if( i <= createField ){
                var startTimeText = jQuery(this).data("start_time");
                var endTimeText = jQuery(this).data("end_time");
                var html ="";
                jQuery( append_wrapper ).append(
                        '<div class="'+parent_block+' '+second_wrapper_extra+'">'+
                        '<div class="'+second_wrapper+'">'+
                        jQuery.map( week_days , function( day , key ){
                            var day_lower = day.toLowerCase();
                            html +='<input type="checkbox" name="'+name+'['+i+']['+day+']" class="'+day_lower+'" id="'+day_lower+''+i+'"/><label for="'+day_lower+i+'">'+day+'</label>'
                        })
                        +html+'</div>'+
                        '<div class="wpc-schedule-field">'+
                            '<input type="text" name="'+start_time_name+'[]" class="'+start_time_name+' '+start_time_name+'_'+i+' wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="'+ startTimeText +'" />'+
                            '<input type="text" name="'+end_time_name+'[]" class="'+end_time_name+' '+end_time_name+'_'+i+'  wpc-settings-input attr-form-control" placeholder="'+ endTimeText +'"/>'+
                            '<span class="'+clear_button+'" id='+i+'> clear </span>'+
                        '</div>'+
                        '<span class="dashicons dashicons-no-alt '+remove_button+' wpc-btn"></span>'+

                    '</div>');
                i++;
            }
        });

        return html;
    }
    

    // adding exception block 
    function add_exception_block( obj , block_name=false) {
        var increase = jQuery(obj.wrapper_block).length;
        jQuery(obj.parent_block).on( 'click' , obj.button_wrapper , function() {
            increase++;
            switch (block_name) {
                case 'reservation_exception_schedule':
                    var startTimeText = jQuery(this).data("start_time");
                    var endTimeText = jQuery(this).data("end_time");
                    jQuery( obj.append_wrapper ).append(
                        '<div class="'+obj.second_wrapper+' d-flex mb-2">'+
                            '<input type="text" name="'+obj.date_name+'[]" class="'+obj.date_name+' wpc_mt_two wpc-mr-one wpc-settings-input attr-form-control" placeholder="Date" id="'+obj.date_name+'_'+increase+'" />'+
                            '<input type="text" name="'+obj.start_time_name+'[]" class="'+obj.start_time_name+'_'+increase+' wpc-settings-input attr-form-control" id="'+obj.start_time_name+'_'+increase+'" placeholder="'+ startTimeText +'" />'+ 
                            '<input type="text" name="'+obj.end_time_name+'[]" class="'+obj.end_time_name+'_'+increase+' wpc-settings-input attr-form-control" id="'+obj.end_time_name+'_'+increase+'" placeholder="'+ endTimeText +'"/>'+ 
                            '<span class="exception_time_clear" id='+increase+'> clear </span>'+
                            '<span class="wpc-btn dashicons dashicons-no-alt '+obj.remove_button+' wpc_icon_middle_position"></span>'+
                        '</div>');
                    jQuery('.'+obj.start_time_name+'_'+increase+', .'+obj.end_time_name+'_'+increase+' ').
                    timepicker({
                        timeFormat: 'H:i',
                        interval: 30,
                        dynamic: true,
                        dropdown: true,
                        scrollbar: true
                    })
                    break;
            
                default:
                    break;
            }

        
        });
    }

    // remove block 
    function remove_block( obj ) {
        jQuery(obj.parent_block).on( 'click' , obj.remove_button , function(e) {
            e.preventDefault();
            jQuery(this).parent( obj.removing_block ).remove();
        });
    }
