"use strict";

// Same task of Frontend and Backend  

// convert time 12 to 24
const convertTime12to24 = (time12h) => {

    const [time, modifier] = time12h.split(' ');

    let [hours, minutes] = time.split(':');

    if (hours === '12') {
        hours = '00';
    }

    if (modifier === 'PM') {
        hours = parseInt(hours, 10) + 12;
    }

    return `${hours}:${minutes}`;
}

// calculate time difference
const time_diff =( wpc_end_time,last_time )=>{
    wpc_end_time  = wpc_end_time.replace(',',':');
    var startTime = moment(wpc_end_time, "H:i");
    var endTime   = moment(last_time, "H:i");
    var duration  = moment.duration(startTime.diff(endTime));
    var hours     = parseInt(duration.asHours());
    var minutes   = parseInt(duration.asMinutes())-hours*60;
    return hours + ':'+ minutes ;
}

// check late booking
const time_diff_for_before_after_equal = (select_time, last_booking_time) => {
    var startTime = moment(select_time, "H:i");
    var endTime = moment(last_booking_time, "H:i");
    var data;
    if (startTime.isBefore(endTime)) {
        data = "early";
    } else if (startTime.isSame(endTime)) {
        data = "equal";
    } else if (startTime.isAfter(endTime)) {
        data = "late";
    } else {
        data = "unknown";
    }

    return data;
}

//add one minute with the existing time
const addMinute = (time , timeFormat) => {
    let new_time= time.split(":");
    let new_hour = new_time[0];
    let minute = new_time[1].split(" ");
    let new_minute = parseInt(minute[0]);
    let am_pm='';

    if (timeFormat == '24') {
        time = convertTime12to24(time);
        am_pm = '';
    }else{
        am_pm = ' ' + minute[1];
    }

    new_minute = (new_minute < 10) ? ("0"+ ++new_minute) : ++new_minute;
    new_time = new_hour +':'+ new_minute + am_pm;
    return new_time;
}

//generate time list based on multislot
const multislotTimePicker = (startTime, endTime, timeFormat ) => {
    let multislotData = [];
    let multi_time_excludes = [];
    for (let i = 0; i < startTime.length; i++) {
        if ( timeFormat == '24') {
            startTime[i] = convertTime12to24(startTime[i]);
            endTime[i] = convertTime12to24(endTime[i]);
        }
        //add one minute to the last element of the array
        let start_time = addMinute(endTime[i] , timeFormat);
        // Don't add to the array for last element
        if(i < startTime.length-1){
            multi_time_excludes.push([
                start_time,
                startTime[i+1]
            ]);
        }
    }
    multislotData['multi_time_excludes'] = multi_time_excludes;

    if (timeFormat == '24') {
        multislotData['wpc_start_time'] = convertTime12to24(startTime[0]);
        multislotData['wpc_end_time'] = convertTime12to24(endTime[ endTime.length - 1]);
    } else {
        multislotData['wpc_end_time'] = startTime[0];
        multislotData['wpc_end_time'] = endTime[ endTime.length - 1];
    }

    return multislotData;
}

// get object key name
function objectKeyName (obj){
    var key_arr = [];
    for (var key in obj) {
        key_arr.push(key);
    }
    return key_arr;
}

// change date format to expected format
const wpc_flatpicker_date_change =(selectedDates,format)=>{
    const wpc_date_ar         = selectedDates.map(date => flatpickr.formatDate(date, format));
    var wpc_new_selected_date = wpc_date_ar.toString();
    return wpc_new_selected_date;
}

